﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <cstring>
#include "../../kern_Platform.h"
#include "kern_KKernelPageTable.h"
#include "kern_MemoryMap.h"
#include "kern_KPageTableDefinition.h"
#include "../../kern_Kernel.h"
#include "../../kern_CPUSelect.h"
#include <nn/nn_BitTypes.h>

namespace nn { namespace kern { namespace ARMv8A {

void
KKernelPageTable::Initialize(int32_t coreNo)
{
    {
        Bit64 ttbr0;
        HW_GET_TTBR0_EL1(ttbr0);
        m_Ttbr0[coreNo] = ttbr0;
    }
    // TTBR0 の変換を禁止する。
    {
        Bit64 tcr = KCPU::GetCurrentTcr();
        tcr |=HW_TCR_EPD0;
        KCPU::SwitchProcess(tcr, 0, 0xfffffffful);
    }

    {
        Bit64 sctlr_el1 = KCPU::GetSctlr();
        KCPU::SetSctlr(sctlr_el1 | HW_SCTLR_WXN);
        KCPU::DataSynchronizationBarrier();
        KCPU::InstructionMemoryBarrier();
    }

    // TLB の無効化
    KCPU::InvalidateEntireTlb();

    if (coreNo == 0)
    {
        Bit64 ttbr1;
        HW_GET_TTBR1_EL1(ttbr1);
        KPhysicalAddress pa = (ttbr1 & ((1ul << HW_MMU_PHYSICAL_ADDRESS_BITS) - 1));
        m_Table.InitializeForKernel(GetUntypedPointer(KPageTableBase::GetLinearMapVirtualAddress(pa)),
                NN_KERN_V_ADDR_KERNEL, NN_KERN_V_ADDR_KERNEL_END);
    }
}

void KKernelPageTable::Finalize(int32_t coreNo)
{
    NN_UNUSED(coreNo);

    // キャッシュの無効化
    KCPU::FlushEntireDataCacheLocal();
    KCPU::InvalidateEntireInstructionCacheLocal();

    // TLB の無効化
    KCPU::InvalidateEntireTlb();
}

}}}
