﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "kern_ExceptionHandler.h"

namespace nn { namespace kern { namespace ARMv8A {

#ifdef NN_KERN_FOR_DEVELOPMENT
    void CommonExceptionHandlerDebug(ARM64::ExceptionContext* pContext, Bit32 esr, uintptr_t fa);
#else
    inline void CommonExceptionHandlerDebug(ARM64::ExceptionContext* pContext, Bit32 esr, uintptr_t fa)
    {
        NN_UNUSED(pContext);
        NN_UNUSED(esr);
        NN_UNUSED(fa);
    }
#endif

}}}

