﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "kern_MemoryMapCpuDetail.h"

#define NN_KERN_L1_PAGE_TABLE_SIZE                          NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE
#define NN_KERN_MMU_L1_PAGE_TABLE_0_SIZE                    NN_KERN_DETAIL_MMU_L1_PAGE_TABLE_0_SIZE
#define NN_KERN_MMU_TTBCR                                   NN_KERN_DETAIL_MMU_TTBCR
#define NN_KERN_V_ADDR_KERNEL                               NN_KERN_DETAIL_V_ADDR_KERNEL
#define NN_KERN_V_ADDR_KERNEL_END                           NN_KERN_DETAIL_V_ADDR_KERNEL_END
#define NN_KERN_V_ADDR_PROCESS                              NN_KERN_DETAIL_V_ADDR_PROCESS
#define NN_KERN_V_ADDR_PROCESS_END                          NN_KERN_DETAIL_V_ADDR_PROCESS_END
#define NN_KERN_V_ADDR_SVC_STACK_END                        NN_KERN_DETAIL_V_ADDR_SVC_STACK_END

#define NN_KERN_V_ADDR_L1_PAGE_TABLE                        NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_SIZE                   NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_SIZE
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_END                    NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_END

#define NN_KERN_P_ADDR_MAIN_MEMORY                          NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY
#define NN_KERN_P_ADDR_MAIN_MEMORY_SIZE                     NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_SIZE
#define NN_KERN_P_ADDR_MAIN_MEMORY_END                      NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_END
#define NN_KERN_V_ADDR_MAIN_MEMORY                          NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY
#define NN_KERN_V_ADDR_MAIN_MEMORY_SIZE                     NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY_SIZE
#define NN_KERN_V_ADDR_MAIN_MEMORY_END                      NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY_END
#define NN_KERN_V_ADDR_TMPMAP                               NN_KERN_DETAIL_V_ADDR_TMPMAP
#define NN_KERN_V_ADDR_TMPMAP_SIZE                          NN_KERN_DETAIL_V_ADDR_TMPMAP_SIZE

#define NN_KERN_P_KTRACE_BUFFER                             NN_KERN_DETAIL_P_KTRACE_BUFFER
#define NN_KERN_P_KTRACE_BUFFER_SIZE                        NN_KERN_DETAIL_P_KTRACE_BUFFER_SIZE

#define NN_KERN_P_TRACE_BUFFER                              NN_KERN_DETAIL_P_TRACE_BUFFER
#define NN_KERN_P_TRACE_BUFFER_SIZE                         NN_KERN_DETAIL_P_TRACE_BUFFER_SIZE


#define NN_KERN_V_ADDR_CORE_LOCAL_REGION                    NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_SIZE               NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_SIZE
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_END                NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_END

#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_0                  NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_0_SIZE             NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_SIZE
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_0_END              NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_END
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_1                  NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_1_SIZE             NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1_SIZE
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_1_END              NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1_END
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_2                  NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_2_SIZE             NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2_SIZE
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_2_END              NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2_END
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_3                  NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_3_SIZE             NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3_SIZE
#define NN_KERN_P_ADDR_CORE_LOCAL_REGION_3_END              NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3_END
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_0                  NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_0_SIZE             NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0_SIZE
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_0_END              NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0_END
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_1                  NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_1_SIZE             NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1_SIZE
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_1_END              NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1_END
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_2                  NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_2_SIZE             NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2_SIZE
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_2_END              NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2_END
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_3                  NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_3_SIZE             NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3_SIZE
#define NN_KERN_V_ADDR_CORE_LOCAL_REGION_3_END              NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3_END


#define NN_KERN_P_ADDR_CODE_MAIN                            NN_KERN_DETAIL_P_ADDR_CODE_MAIN
#define NN_KERN_P_ADDR_CODE_MAIN_SIZE                       NN_KERN_DETAIL_P_ADDR_CODE_MAIN_SIZE
#define NN_KERN_P_ADDR_CODE_MAIN_END                        NN_KERN_DETAIL_P_ADDR_CODE_MAIN_END
#define NN_KERN_V_ADDR_CODE_MAIN                            NN_KERN_DETAIL_V_ADDR_CODE_MAIN
#define NN_KERN_V_ADDR_CODE_MAIN_SIZE                       NN_KERN_DETAIL_V_ADDR_CODE_MAIN_SIZE
#define NN_KERN_V_ADDR_CODE_MAIN_END                        NN_KERN_DETAIL_V_ADDR_CODE_MAIN_END

#define NN_KERN_P_ADDR_CODE_MAIN_CODE                       NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE
#define NN_KERN_P_ADDR_CODE_MAIN_CODE_SIZE                  NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE_SIZE
#define NN_KERN_P_ADDR_CODE_MAIN_CODE_END                   NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE_END
#define NN_KERN_V_ADDR_CODE_MAIN_CODE                       NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE
#define NN_KERN_V_ADDR_CODE_MAIN_CODE_SIZE                  NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE_SIZE
#define NN_KERN_V_ADDR_CODE_MAIN_CODE_END                   NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE_END
#define NN_KERN_P_ADDR_CODE_MAIN_RO                         NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RO
#define NN_KERN_P_ADDR_CODE_MAIN_RO_SIZE                    NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RO_SIZE
#define NN_KERN_P_ADDR_CODE_MAIN_RO_END                     NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RO_END
#define NN_KERN_V_ADDR_CODE_MAIN_RO                         NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO
#define NN_KERN_V_ADDR_CODE_MAIN_RO_SIZE                    NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_SIZE
#define NN_KERN_V_ADDR_CODE_MAIN_RO_END                     NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_END
#define NN_KERN_P_ADDR_CODE_MAIN_RW_ZI                      NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW_ZI
#define NN_KERN_P_ADDR_CODE_MAIN_RW_ZI_SIZE                 NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW_ZI_SIZE
#define NN_KERN_P_ADDR_CODE_MAIN_RW_ZI_END                  NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW_ZI_END
#define NN_KERN_V_ADDR_CODE_MAIN_RW_ZI                      NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI
#define NN_KERN_V_ADDR_CODE_MAIN_RW_ZI_SIZE                 NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI_SIZE
#define NN_KERN_V_ADDR_CODE_MAIN_RW_ZI_END                  NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI_END

#define NN_KERN_V_ADDR_CODE_MAIN_ZI                         NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI
#define NN_KERN_V_ADDR_CODE_MAIN_ZI_SIZE                    NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_SIZE
#define NN_KERN_V_ADDR_CODE_MAIN_ZI_END                     NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_END


#define NN_KERN_V_ADDR_KERNEL_CODE_IO                       NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO
#define NN_KERN_V_ADDR_KERNEL_CODE_IO_SIZE                  NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO_SIZE
#define NN_KERN_V_ADDR_KERNEL_CODE_IO_END                   NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO_END

#define NN_KERN_P_ADDR_INITIAL_PROCESS_DEST                 NN_KERN_DETAIL_P_ADDR_INITIAL_PROCESS

#define NN_KERN_V_ADDR_STACK_CMN                            NN_KERN_DETAIL_V_ADDR_STACK_CMN
#define NN_KERN_V_ADDR_STACK_CMN_END                        NN_KERN_DETAIL_V_ADDR_STACK_CMN_END
#define NN_KERN_V_ADDR_STACK_MAIN                           NN_KERN_DETAIL_V_ADDR_STACK_MAIN
#define NN_KERN_V_ADDR_STACK_MAIN_END                       NN_KERN_DETAIL_V_ADDR_STACK_MAIN_END
#define NN_KERN_V_ADDR_STACK_IDLE                           NN_KERN_DETAIL_V_ADDR_STACK_IDLE
#define NN_KERN_V_ADDR_STACK_IDLE_END                       NN_KERN_DETAIL_V_ADDR_STACK_IDLE_END


#define NN_KERN_V_ADDR_STACK_CMN_0                      NN_KERN_DETAIL_V_ADDR_STACK_CMN_0
#define NN_KERN_V_ADDR_STACK_CMN_1                      NN_KERN_DETAIL_V_ADDR_STACK_CMN_1
#define NN_KERN_V_ADDR_STACK_CMN_2                      NN_KERN_DETAIL_V_ADDR_STACK_CMN_2
#define NN_KERN_V_ADDR_STACK_CMN_3                      NN_KERN_DETAIL_V_ADDR_STACK_CMN_3
#define NN_KERN_P_ADDR_STACK_CMN_0                      NN_KERN_DETAIL_P_ADDR_STACK_CMN_0
#define NN_KERN_P_ADDR_STACK_CMN_1                      NN_KERN_DETAIL_P_ADDR_STACK_CMN_1
#define NN_KERN_P_ADDR_STACK_CMN_2                      NN_KERN_DETAIL_P_ADDR_STACK_CMN_2
#define NN_KERN_P_ADDR_STACK_CMN_3                      NN_KERN_DETAIL_P_ADDR_STACK_CMN_3

#define NN_KERN_V_ADDR_STACK_MAIN_0                     NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0
#define NN_KERN_V_ADDR_STACK_MAIN_1                     NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1
#define NN_KERN_V_ADDR_STACK_MAIN_2                     NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2
#define NN_KERN_V_ADDR_STACK_MAIN_3                     NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3
#define NN_KERN_P_ADDR_STACK_MAIN_0                     NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0
#define NN_KERN_P_ADDR_STACK_MAIN_1                     NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1
#define NN_KERN_P_ADDR_STACK_MAIN_2                     NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2
#define NN_KERN_P_ADDR_STACK_MAIN_3                     NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3

#define NN_KERN_V_ADDR_STACK_IDLE_0                     NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0
#define NN_KERN_V_ADDR_STACK_IDLE_1                     NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1
#define NN_KERN_V_ADDR_STACK_IDLE_2                     NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2
#define NN_KERN_V_ADDR_STACK_IDLE_3                     NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3
#define NN_KERN_P_ADDR_STACK_IDLE_0                     NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0
#define NN_KERN_P_ADDR_STACK_IDLE_1                     NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1
#define NN_KERN_P_ADDR_STACK_IDLE_2                     NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2
#define NN_KERN_P_ADDR_STACK_IDLE_3                     NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3

#define NN_KERN_V_ADDR_STACK_CMN_0_SIZE                 NN_KERN_DETAIL_V_ADDR_STACK_CMN_0_SIZE
#define NN_KERN_V_ADDR_STACK_CMN_1_SIZE                 NN_KERN_DETAIL_V_ADDR_STACK_CMN_1_SIZE
#define NN_KERN_V_ADDR_STACK_CMN_2_SIZE                 NN_KERN_DETAIL_V_ADDR_STACK_CMN_2_SIZE
#define NN_KERN_V_ADDR_STACK_CMN_3_SIZE                 NN_KERN_DETAIL_V_ADDR_STACK_CMN_3_SIZE
#define NN_KERN_P_ADDR_STACK_CMN_0_SIZE                 NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_SIZE
#define NN_KERN_P_ADDR_STACK_CMN_1_SIZE                 NN_KERN_DETAIL_P_ADDR_STACK_CMN_1_SIZE
#define NN_KERN_P_ADDR_STACK_CMN_2_SIZE                 NN_KERN_DETAIL_P_ADDR_STACK_CMN_2_SIZE
#define NN_KERN_P_ADDR_STACK_CMN_3_SIZE                 NN_KERN_DETAIL_P_ADDR_STACK_CMN_3_SIZE

#define NN_KERN_V_ADDR_STACK_MAIN_0_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0_SIZE
#define NN_KERN_V_ADDR_STACK_MAIN_1_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1_SIZE
#define NN_KERN_V_ADDR_STACK_MAIN_2_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2_SIZE
#define NN_KERN_V_ADDR_STACK_MAIN_3_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3_SIZE
#define NN_KERN_P_ADDR_STACK_MAIN_0_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_SIZE
#define NN_KERN_P_ADDR_STACK_MAIN_1_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1_SIZE
#define NN_KERN_P_ADDR_STACK_MAIN_2_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2_SIZE
#define NN_KERN_P_ADDR_STACK_MAIN_3_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3_SIZE

#define NN_KERN_V_ADDR_STACK_IDLE_0_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0_SIZE
#define NN_KERN_V_ADDR_STACK_IDLE_1_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1_SIZE
#define NN_KERN_V_ADDR_STACK_IDLE_2_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2_SIZE
#define NN_KERN_V_ADDR_STACK_IDLE_3_SIZE                NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3_SIZE
#define NN_KERN_P_ADDR_STACK_IDLE_0_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_SIZE
#define NN_KERN_P_ADDR_STACK_IDLE_1_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1_SIZE
#define NN_KERN_P_ADDR_STACK_IDLE_2_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2_SIZE
#define NN_KERN_P_ADDR_STACK_IDLE_3_SIZE                NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3_SIZE

#define NN_KERN_V_ADDR_STACK_CMN_0_END                  NN_KERN_DETAIL_V_ADDR_STACK_CMN_0_END
#define NN_KERN_V_ADDR_STACK_CMN_1_END                  NN_KERN_DETAIL_V_ADDR_STACK_CMN_1_END
#define NN_KERN_V_ADDR_STACK_CMN_2_END                  NN_KERN_DETAIL_V_ADDR_STACK_CMN_2_END
#define NN_KERN_V_ADDR_STACK_CMN_3_END                  NN_KERN_DETAIL_V_ADDR_STACK_CMN_3_END
#define NN_KERN_P_ADDR_STACK_CMN_0_END                  NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_END
#define NN_KERN_P_ADDR_STACK_CMN_1_END                  NN_KERN_DETAIL_P_ADDR_STACK_CMN_1_END
#define NN_KERN_P_ADDR_STACK_CMN_2_END                  NN_KERN_DETAIL_P_ADDR_STACK_CMN_2_END
#define NN_KERN_P_ADDR_STACK_CMN_3_END                  NN_KERN_DETAIL_P_ADDR_STACK_CMN_3_END

#define NN_KERN_V_ADDR_STACK_MAIN_0_END                 NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0_END
#define NN_KERN_V_ADDR_STACK_MAIN_1_END                 NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1_END
#define NN_KERN_V_ADDR_STACK_MAIN_2_END                 NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2_END
#define NN_KERN_V_ADDR_STACK_MAIN_3_END                 NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3_END
#define NN_KERN_P_ADDR_STACK_MAIN_0_END                 NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_END
#define NN_KERN_P_ADDR_STACK_MAIN_1_END                 NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1_END
#define NN_KERN_P_ADDR_STACK_MAIN_2_END                 NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2_END
#define NN_KERN_P_ADDR_STACK_MAIN_3_END                 NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3_END

#define NN_KERN_V_ADDR_STACK_IDLE_0_END                 NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0_END
#define NN_KERN_V_ADDR_STACK_IDLE_1_END                 NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1_END
#define NN_KERN_V_ADDR_STACK_IDLE_2_END                 NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2_END
#define NN_KERN_V_ADDR_STACK_IDLE_3_END                 NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3_END
#define NN_KERN_P_ADDR_STACK_IDLE_0_END                 NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_END
#define NN_KERN_P_ADDR_STACK_IDLE_1_END                 NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1_END
#define NN_KERN_P_ADDR_STACK_IDLE_2_END                 NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2_END
#define NN_KERN_P_ADDR_STACK_IDLE_3_END                 NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3_END

#define NN_KERN_P_ADDR_PT_HEAP                          NN_KERN_DETAIL_P_ADDR_PT_HEAP
#define NN_KERN_P_ADDR_PT_HEAP_SIZE                     NN_KERN_DETAIL_P_ADDR_PT_HEAP_SIZE
#define NN_KERN_P_ADDR_PT_HEAP_END                      NN_KERN_DETAIL_P_ADDR_PT_HEAP_END

#define NN_KERN_P_ADDR_SLAB_RESERVED_SIZE               NN_KERN_DETAIL_P_ADDR_SLAB_RESERVED_SIZE

#define NN_KERN_V_ADDR_L2_PAGE_TABLE                    NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_SIZE               NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_SIZE
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_END                NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_END
#define NN_KERN_P_ADDR_L2_PAGE_TABLE                    NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_SIZE               NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_SIZE
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_END                NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_END

#define NN_KERN_P_ADDR_L1_PAGE_TABLE_0                  NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_0_SIZE             NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0_SIZE
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_0_END              NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0_END
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_1                  NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_1_SIZE             NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1_SIZE
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_1_END              NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1_END
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_2                  NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_2_SIZE             NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2_SIZE
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_2_END              NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2_END
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_3                  NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_3_SIZE             NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3_SIZE
#define NN_KERN_P_ADDR_L1_PAGE_TABLE_3_END              NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3_END
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_0                  NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_0_SIZE             NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0_SIZE
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_0_END              NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0_END
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_1                  NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_1_SIZE             NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1_SIZE
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_1_END              NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1_END
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_2                  NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_2_SIZE             NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2_SIZE
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_2_END              NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2_END
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_3                  NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_3_SIZE             NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3_SIZE
#define NN_KERN_V_ADDR_L1_PAGE_TABLE_3_END              NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3_END

#define NN_KERN_P_ADDR_L2_PAGE_TABLE_0                  NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_0_SIZE             NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0_SIZE
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_0_END              NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0_END
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_1                  NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_1_SIZE             NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1_SIZE
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_1_END              NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1_END
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_2                  NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_2_SIZE             NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2_SIZE
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_2_END              NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2_END
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_3                  NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_3
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_3_SIZE             NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_3_SIZE
#define NN_KERN_P_ADDR_L2_PAGE_TABLE_3_END              NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_3_END
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_0                  NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_0
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_0_SIZE             NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_0_SIZE
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_0_END              NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_0_END
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_1                  NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_1
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_1_SIZE             NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_1_SIZE
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_1_END              NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_1_END
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_2                  NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_2
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_2_SIZE             NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_2_SIZE
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_2_END              NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_2_END
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_3                  NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_3
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_3_SIZE             NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_3_SIZE
#define NN_KERN_V_ADDR_L2_PAGE_TABLE_3_END              NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_3_END



#define NN_KERN_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK      NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK
#define NN_KERN_V_ADDR_SVC_STACK                        NN_KERN_DETAIL_V_ADDR_SVC_STACK

#define NN_KERN_V_ADDR_HEAP                             NN_KERN_DETAIL_V_ADDR_HEAP
#define NN_KERN_V_ADDR_HEAP_SIZE                        NN_KERN_DETAIL_V_ADDR_HEAP_SIZE
#define NN_KERN_V_ADDR_HEAP_END                         NN_KERN_DETAIL_V_ADDR_HEAP_END

#define NN_KERN_P_ADDR_KERNEL_REGION                    NN_KERN_DETAIL_P_ADDR_KERNEL_REGION
#define NN_KERN_P_ADDR_KERNEL_REGION_SIZE               NN_KERN_DETAIL_P_ADDR_KERNEL_REGION_SIZE
#define NN_KERN_P_ADDR_KERNEL_REGION_END                NN_KERN_DETAIL_P_ADDR_KERNEL_REGION_END

