﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <cstring>
#include "../../kern_Platform.h"
#include "kern_KKernelPageTable.h"
#include "kern_MemoryMap.h"
#include "../../kern_Kernel.h"
#include "../../kern_CPUSelect.h"
#include <nn/nn_BitTypes.h>

namespace nn { namespace kern { namespace ARMv7A {

void
KKernelPageTable::Initialize(int32_t coreNo)
{
    // 未使用領域を初期化
    std::memset(reinterpret_cast<void *>(NN_KERN_V_ADDR_L1_PAGE_TABLE), 0, NN_KERN_MMU_L1_PAGE_TABLE_0_SIZE);

    // TLB の無効化
    KCPU::InvalidateEntireTlb();

    if( coreNo == 0 )
    {
        m_Table.InitializeForKernel(reinterpret_cast<void*>(NN_KERN_V_ADDR_L1_PAGE_TABLE),
                NN_KERN_V_ADDR_KERNEL, NN_KERN_V_ADDR_KERNEL_END);
    }
}

void KKernelPageTable::Finalize(int32_t coreNo)
{
    NN_UNUSED(coreNo);

    // キャッシュの無効化
    KCPU::FlushEntireDataCacheLocal();
    KCPU::InvalidateEntireInstructionCacheLocal();

    // TLB の無効化
    KCPU::InvalidateEntireTlb();
}

}}}
