﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

namespace nn {
    namespace kern {
        namespace ARMv7A {

            struct KInterruptName
            {
                static const int32_t INTR_CORE_ID_PMN       =  4;   //  4: パフォーマンスモニタ
                static const int32_t INTR_CORE_ID_TERMINATE =  5;   //  5: スレッド強制終了
                static const int32_t INTR_CORE_ID_CONTROL   =  6;   //  6: システム制御
                static const int32_t INTR_CORE_ID_CACHE     =  7;   //  7: キャッシュ操作
                static const int32_t INTR_CORE_ID_SCHEDULER =  8;   //  8: スケジューラ
                static const int32_t INTR_CORE_ID_CONTEXT   =  9;   //  9: VFP スイッチ
                static const int32_t INTR_CORE_ID_PAGETABLE = 10;   // 10: ページテーブルの書き換え
                static const int32_t INTR_CORE_ID_PRINT     = 11;   // 11: デバッグ出力通知
                static const int32_t INTR_CORE_ID_HVC       = 12;   // 12: Call HVC
                static const int32_t INTR_CORE_ID_CC        = 13;
                static const int32_t INTR_CORE_ID_STOP      = 14;   // 14: Stop other cores for KTrace dump

#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
                static const int32_t INTR_CORE_ID_MC        = 109;
#endif
            };

        }
    }
}

