﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/nn_Common.h>
#include <nn/svc/svc_Kernel.h>
#include "../../kern_Platform.h"
#include "kern_KHardwareTimer.h"
#include "../../kern_Kernel.h"
#include "../../kern_InterruptManagerSelect.h"
#include "../../kern_DebugString.h"
#include "../../kern_KScopedSchedulingLock.h"

#if defined NN_BUILD_CONFIG_CPU_CORTEX_A9
#error not supported on Cortex-A9
#endif

namespace nn { namespace kern {
    namespace ARMv7A {

void KHardwareTimer::Initialize(int32_t coreNo)
{
    InitGlobalTimer(coreNo);

    for (int32_t i = 0; i < KCPU::NUM_CORE; i++)
    {
        if (i == coreNo)
        {
            Kernel::GetInterruptManager().BindHandler(this, INTERRUPT_ID_TIMER, coreNo, KInterruptController::PriorityLevel_TimInterrupt, true, true);
        }
        // スケジューラ有効前に Mutexで競合するとNGなのでBindHandler()が競合しないようにする。
        KCPU::SynchronizeAllCore();
    }
}

void KHardwareTimer::Finalize(int32_t coreNo)
{
    NN_UNUSED(coreNo);
    StopHardwareTimer();
}

void KHardwareTimer::DoInterruptTask()
{
    // 割り込みタスクスレッド内

    {
        KScopedSchedulingLock schLock;
        KScopedSimpleLock lock(&GetLockMutex());

        DisableHardwareTimerInterrupt();
        int64_t next = DoInterruptTaskImpl(GetTick());
        if (next > 0)
        {
            SetTimerCount(next);
            EnableHardwareTimerInterrupt();
        }
    }
    Kernel::GetInterruptManager().ClearInterrupt(INTERRUPT_ID_TIMER, GetCurrentCpuNo());
}

    }
}}


