﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM/kern_Assembly.h"

    .balign 0x20
    .section ".text"
    .globl  ExceptionVector
    .type   ExceptionVector, %function
ExceptionVector:
reset:  b       reset_code
undef:  b       UndefinedInstructionHandlerVeneer
swi:    b       SwiHandlerVeneer
iabt:   b       InstructionAbortHandlerVeneer
dabt:   b       DataAbortHandlerVeneer
reserve:b       reserve
irq:    b       IrqHandlerVeneer
fiq:    b       fiq

reset_code:
        wfe
        b reset_code

UndefinedInstructionHandlerVeneer:
        clrex
        ldr      pc, =_ZN2nn4kern6ARMv7A27UndefinedInstructionHandlerEv

SwiHandlerVeneer:
        clrex
        ldr      pc, =_ZN2nn4kern3svc10SwiHandlerEv

InstructionAbortHandlerVeneer:
        clrex
        ldr      pc, =_ZN2nn4kern6ARMv7A20PrefetchAbortHandlerEv

DataAbortHandlerVeneer:
        clrex
        ldr      pc, =_ZN2nn4kern6ARMv7A16DataAbortHandlerEv

IrqHandlerVeneer:
        clrex
        ldr      pc, =_ZN2nn4kern3ARM23InterruptRequestHandlerEv
SET_SIZE(ExceptionVector)

