﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include "kern_AssemblyOffset.h"
#include "../../ARM/kern_Assembly.h"

#define UNUSED_CORE_TERMINATE_VECTOR         (0x00028818)

#define REG_NO_CORE_NO              r4
#define REG_NO_NUM_CORE             r5
#define REG_NO_COMMON_STACK_ADDR    r6
#define REG_NO_SVC_P_STACK_ADDR     r7
#define REG_NO_SVC_V_STACK_ADDR     r8


/*---------------------------------------------------------------------------*
  Name:         StartCore0

  Description:  Primary Core (core0) 用の開始処理

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
START_ENTRY(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore0Ev)
    // スタックアドレスのロード
    ldr     REG_NO_COMMON_STACK_ADDR, =NN_KERN_V_ADDR_STACK_CMN_END
    ldr     REG_NO_SVC_P_STACK_ADDR,  =NN_KERN_P_ADDR_STACK_MAIN_0_END
    ldr     REG_NO_SVC_V_STACK_ADDR,  =(NN_KERN_V_ADDR_STACK_MAIN_END - PARAMS_ON_STACK_SIZE)

    bx      lr
SET_SIZE(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore0Ev)

/*---------------------------------------------------------------------------*
  Name:         StartCore1

  Description:  Slave Core (core1) 用の開始処理

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
START_ENTRY(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore1Ev)
    // スタックアドレスのロード
    ldr     REG_NO_COMMON_STACK_ADDR, =NN_KERN_V_ADDR_STACK_CMN_1_END
    ldr     REG_NO_SVC_P_STACK_ADDR,  =NN_KERN_P_ADDR_STACK_MAIN_1_END
    ldr     REG_NO_SVC_V_STACK_ADDR,  =(NN_KERN_V_ADDR_STACK_MAIN_END - PARAMS_ON_STACK_SIZE)

    bx      lr
SET_SIZE(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore1Ev)

/*---------------------------------------------------------------------------*
  Name:         StartCore2

  Description:  Slave Core (core2) 用の開始処理

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
START_ENTRY(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore2Ev)
    // スタックアドレスのロード
    ldr     REG_NO_COMMON_STACK_ADDR, =NN_KERN_V_ADDR_STACK_CMN_2_END
    ldr     REG_NO_SVC_P_STACK_ADDR,  =NN_KERN_P_ADDR_STACK_MAIN_2_END
    ldr     REG_NO_SVC_V_STACK_ADDR,  =(NN_KERN_V_ADDR_STACK_MAIN_END - PARAMS_ON_STACK_SIZE)

    bx      lr
SET_SIZE(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore2Ev)

/*---------------------------------------------------------------------------*
  Name:         StartCore3

  Description:  Slave Core (core3) 用の開始処理

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
START_ENTRY(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore3Ev)
    // スタックアドレスのロード
    ldr     REG_NO_COMMON_STACK_ADDR, =NN_KERN_V_ADDR_STACK_CMN_3_END
    ldr     REG_NO_SVC_P_STACK_ADDR,  =NN_KERN_P_ADDR_STACK_MAIN_3_END
    ldr     REG_NO_SVC_V_STACK_ADDR,  =(NN_KERN_V_ADDR_STACK_MAIN_END - PARAMS_ON_STACK_SIZE)

    bx      lr
SET_SIZE(_ZN2nn4kern3DEV6ARMv7A4crt010StartCore3Ev)


/*---------------------------------------------------------------------------*
  Name:         __ctr_start

  Description:  Horizon Kernel 用スタートアップルーチン

  Arguments:    None

  Returns:      None.

  Note:         レジスタ用途
                    r4  コア番号
                    r5  コア数
                    r6  共通スタックアドレス（仮想アドレス）
                    r7  メインスレッドスタックアドレス（物理アドレス）
                    r8  メインスレッドスタックアドレス（仮想アドレス）
 *---------------------------------------------------------------------------*/
START_ENTRY(_start)
        //---------------------------------------------------
        // entry point
        adr     r6, _start
        ldr     r7, =_start
        cmp     r6, r7
        beq     _start_nocopy

        mrc     p15,0, r0, c0, c0, 5
        and     r0, r0, #HW_C0_AP_CPU_ID_MASK
        cmp     r0, #0
        beq     2f
1:      b       1b
        // copy kernel
2:      sub     r5, r6, r7
        ldr     r0, =NN_KERN_P_ADDR_CODE_MAIN
        add     r1, r0, r5
        ldr     r2, =Load$$ZI$$Base
2:      cmp     r0, r2
        bcs     3f
        ldr     r3, [r1]
        str     r3, [r0]
        mcr     p15, 0, r0, c7, c14, 1
        add     r0, r0, #4
        add     r1, r1, #4
        b       2b
        // copy initial process
3:      ldr     r0, =Load$$INITIAL_PROCESS$$Base
#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
        ldr     r1, =0xdc000000
#elif defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6)
        ldr     r1, =0x2c000000
#else
1:      b       1b
#endif
        ldr     r2, [r1, #INITIAL_PROCESS_IMAGE_HEADER_SIGNATURE]
        ldr     r3, =INITIAL_PROCESS_IMAGE_HEADER_VALIDSIGNATURE
        cmp     r2, r3
        ldr     r2, [r1, #INITIAL_PROCESS_IMAGE_HEADER_TOTALLENGTH]
        beq     5f
        // シグネチャが誤っていた場合、ヘッダだけコピーしておく（後のチェックで PANIC させる）
        mov     r2, #INITIAL_PROCESS_IMAGE_HEADER_SIZE
5:      add     r2, r0, r2
2:      cmp     r0, r2
        bcs     4f
        ldr     r3, [r1]
        str     r3, [r0]
        mcr     p15, 0, r0, c7, c14, 1
        add     r0, r0, #4
        add     r1, r1, #4
        b       2b
4:      dsb     sy
        mov     r0, #0
        mcr     p15, 0, r0, c7, c1, 0
        dsb     sy
        isb
        ldr     r0,=_start_nocopy
        bx      r0
_start_nocopy:
        // 割り込み禁止
        cpsid   ifa

        bl      _ZN2nn4kern3DEV6ARMv7A4crt05Step0Ev

        mrc     p15,0, r0, c0, c0, 0
        lsl     r0, #16
        lsr     r0, #20
#if defined NN_BUILD_CONFIG_CPU_CORTEX_A7
        ldr     r1, =0xc07
#elif defined NN_BUILD_CONFIG_CPU_CORTEX_A9
        ldr     r1, =0xc09
#elif defined NN_BUILD_CONFIG_CPU_CORTEX_A15
        ldr     r1, =0xc0f
#endif
        cmp     r1, r0
        beq     1f
        ldr     r0, =UNUSED_CORE_TERMINATE_VECTOR
        blx     r0

1:
        // CPU レジスタを初期化
        mov     r0, #0
        mov     r1, #0
        mov     r2, #0
        mov     r3, #0
        mov     r4, #0
        mov     r5, #0
        mov     r6, #0
        mov     r7, #0
        mov     r8, #0
        mov     r9, #0
        mov     r10, #0
        mov     r11, #0
        mov     r12, #0

        // CPU ID およびコア数の取得
        mrc     p15,0, REG_NO_CORE_NO, c0, c0, 5
        and     REG_NO_CORE_NO, REG_NO_CORE_NO, #HW_C0_AP_CPU_ID_MASK

        // core 毎の開始処理
        // 未使用コアはここで止まる
        adr     r0, func_table_start
        ldr     r0, [r0, REG_NO_CORE_NO, LSL #2]
        blx     r0

        // ここで r6-8 にスタックアドレスが入っている

        //--- SP, LR, SPSR を初期化

        // システム モード  （未使用）
        cps     #HW_PSR_SYS_MODE
        mov     sp, #0
        mov     lr, #0

        // IRQ モード       （共通スタック）
        cps     #HW_PSR_IRQ_MODE
        mov     sp, REG_NO_COMMON_STACK_ADDR
        mov     lr, #0
        msr     spsr_cxsf, #0

        // FIQ モード       （スタック未使用）
        cps     #HW_PSR_FIQ_MODE
        mov     sp, #0
        mov     lr, #0
        msr     spsr_cxsf, #0

        // アボート モード  （共通スタック）
        cps     #HW_PSR_ABORT_MODE
        mov     sp, REG_NO_COMMON_STACK_ADDR
        mov     lr, #0
        msr     spsr_cxsf, #0

        // 未定義 モード    （共通スタック）
        cps     #HW_PSR_UNDEF_MODE
        mov     sp, REG_NO_COMMON_STACK_ADDR
        mov     lr, #0
        msr     spsr_cxsf, #0

        // SVC モード       （物理アドレススタック）
        cps     #HW_PSR_SVC_MODE
        mov     sp, REG_NO_SVC_P_STACK_ADDR
        mov     lr, #0
        msr     spsr_cxsf, #0

        //---- 以降 SVC モード

        // step0: MMU を有効にするまで
        mov     r0, REG_NO_CORE_NO
        bl      _ZN2nn4kern3DEV6ARMv7A4crt05Step1Ei

        // SVC モード (仮想アドレススタック)
        cps     #HW_PSR_SVC_MODE
        mov     sp, REG_NO_SVC_V_STACK_ADDR
        mov     lr, #0

        // step1: 仮想アドレススタックに切り替えてから
        mov     r0, REG_NO_CORE_NO
        bl      _ZN2nn4kern3DEV6ARMv7A4crt05Step2Ei

#if defined NN_KERN_CHECK_KERNEL_STACK
        mov     r0, sp
        ldr     r1, =(0 - NN_KERN_THREAD_SVC_STACK_SIZE)
        and     r0, r0, r1
        mov     r1, sp
        ldr     r2, =0xcccccccc
1:      cmp     r0, r1
        beq     2f
        str     r2, [r0], #4
        b       1b
2:
#endif

        //---- start
        ldr     r0, = KernelMain
        blx     r0
1:      b       1b

func_table_start:
        .long   _ZN2nn4kern3DEV6ARMv7A4crt010StartCore0Ev
        .long   _ZN2nn4kern3DEV6ARMv7A4crt010StartCore1Ev
        .long   _ZN2nn4kern3DEV6ARMv7A4crt010StartCore2Ev
        .long   _ZN2nn4kern3DEV6ARMv7A4crt010StartCore3Ev
        .long   ExceptionVector
SET_SIZE(_start)

START_ENTRY(_ZN2nn4kern3DEV6ARMv7A4crt05Step0Ev)
        // スタックが準備されていないのでアセンブラで書かなければならない
        // CP15 制御レジスタ
        ldr     r0, =HW_C1_0_C0_0_RESET     // リセット時のデフォルト値
        mcr     p15, 0, r0, c1, c0, 0

        // CP15 補助制御レジスタ
        ldr     r0, =HW_C1_0_C0_1_RESET     // リセット時のデフォルト値
        mcr     p15, 0, r0, c1, c0, 1

        dsb
        isb

        // キャッシュの無効化(Invalidate)
        mov     r0, #0
        mcr     p15, 0, r0, c7, c5, 0   // 命令キャッシュ

        // データキャッシュの無効化(ARMv7-Aでは全操作がない)
        mov     r0, #0
1:
        lsl     r1, r0, #1
        mcr     p15, 2, r1, c0, c0, #0
        isb
        mrc     p15, 1, r1, c0, c0, #0
        mvn     r2, #0x78000
        ubfx    r6, r1, #3, #10
        and     r3, r1, #7
        and     r2, r2, r1, LSR #13
        add     r12, r3, #4
        clz     r7, r6
        cmp     r6, #0
        mov     r5, #0
        blt     5f
2:
        cmp     r2, #0
        lslge   r3, r5, r7
        mov     r1, #0
        blt     4f
3:
        orr     r4, r3, r1, lsl r12
        orr     r4, r4, r0, lsl #1
        mcr     p15, 0, r4, c7, c6, #2
        add     r1, r1, #1
        cmp     r2, r1
        bge     3b
4:
        add     r5, r5, #1
        cmp     r6, r5
        bge     2b
5:
        add     r0, r0, #1
        cmp     r0, #2
        bne     1b

        dsb
        isb

        bx      lr
SET_SIZE(_ZN2nn4kern3DEV6ARMv7A4crt05Step0Ev)

