﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_AssemblyOffset.h"
#include "../kern_Assembly.h"


#define SAVE_AARCH64_REGS \
    sub     sp, sp, #(8 * 8); \
    stp     x0, x1, [sp, #(8 * 0)] ; \
    stp     x2, x3, [sp, #(8 * 2)] ; \
    stp     x4, x5, [sp, #(8 * 4)] ; \
    stp     x6, x7, [sp, #(8 * 6)]

#define RESTORE_AARCH64_REGS \
    ldp     x0, x1, [sp, #(8 * 0)] ; \
    ldp     x2, x3, [sp, #(8 * 2)] ; \
    ldp     x4, x5, [sp, #(8 * 4)] ; \
    ldp     x6, x7, [sp, #(8 * 6)] ; \
    add     sp, sp, #(8 * 8)

#if defined NN_KERN_ENABLE_KTRACE || defined NN_KERN_ENABLE_KERNEL_TRACE || defined NN_KERN_ENABLE_SVC_PROFILE
#define NN_KERN_KTRACE_SVC_ENTER_TRACE(reg) \
    sub     sp, sp, #(8 * 10);              \
    stp     x0, x1, [sp, #(8 * 0)] ;        \
    stp     x2, x3, [sp, #(8 * 2)] ;        \
    stp     x4, x5, [sp, #(8 * 4)] ;        \
    stp     x6, x7, [sp, #(8 * 6)] ;        \
    str     reg,    [sp, #(8 * 8)] ;        \
    mov     x0, sp;                         \
    bl      SvcEnterTrace;                  \
    ldp     x0, x1, [sp, #(8 * 0)] ;        \
    ldp     x2, x3, [sp, #(8 * 2)] ;        \
    ldp     x4, x5, [sp, #(8 * 4)] ;        \
    ldp     x6, x7, [sp, #(8 * 6)] ;        \
    ldr     reg,    [sp, #(8 * 8)] ;        \
    add     sp, sp, #(8 * 10)

#define NN_KERN_KTRACE_SVC_LEAVE_TRACE      \
    sub     sp, sp, #(8 * 8);               \
    stp     x0, x1, [sp, #(8 * 0)] ;        \
    stp     x2, x3, [sp, #(8 * 2)] ;        \
    stp     x4, x5, [sp, #(8 * 4)] ;        \
    stp     x6, x7, [sp, #(8 * 6)] ;        \
    mov     x0, sp;                         \
    bl      SvcLeaveTrace;                  \
    ldp     x0, x1, [sp, #(8 * 0)] ;        \
    ldp     x2, x3, [sp, #(8 * 2)] ;        \
    ldp     x4, x5, [sp, #(8 * 4)] ;        \
    ldp     x6, x7, [sp, #(8 * 6)] ;        \
    add     sp, sp, #(8 * 8)

#else
#define NN_KERN_KTRACE_SVC_ENTER_TRACE(reg)
#define NN_KERN_KTRACE_SVC_LEAVE_TRACE
#endif


ENTRY(SvcHandler64)
    sub     sp, sp, #STACK_OFFSET

    // ReturnFromException用に保存する
    stp     x9, x10, [sp, #(EXCEPTION_CONTEXT_X9)]
    str     x11,     [sp, #(EXCEPTION_CONTEXT_X11)]
    str     x18,     [sp, #(EXCEPTION_CONTEXT_X18)]

    mrs     x8, sp_el0
    mrs     x9, elr_el1
    mrs     x10, spsr_el1
    mrs     x11, tpidr_el0

    // サスペンドのため、callee-save registerを保存する
    stp     x19, x20, [sp, #(EXCEPTION_CONTEXT_X19)]
    stp     x21, x22, [sp, #(EXCEPTION_CONTEXT_X21)]
    stp     x23, x24, [sp, #(EXCEPTION_CONTEXT_X23)]
    stp     x25, x26, [sp, #(EXCEPTION_CONTEXT_X25)]
    stp     x27, x28, [sp, #(EXCEPTION_CONTEXT_X27)]

    // デバッガのため、レジスタを保存する
    stp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    stp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X2)]
    stp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X4)]
    stp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X6)]
    stp     x29, x30, [sp, #(EXCEPTION_CONTEXT_X29)]
    stp      x8, x9,  [sp, #(EXCEPTION_CONTEXT_SP)]
    stp     x10, x11, [sp, #(EXCEPTION_CONTEXT_PSR)]

    mov     w10, #1
    strb    w10, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]

    // システムコール番号取得
    mrs     x8, esr_el1
    and     x8, x8, #0xFF
    cmp     x8, #128
    b.ge    .Linvalid_svc_handler

    // プロセスに許可されている SVC_ID か否かをチェック
    mov     x9, sp
    add     x9, x9, x8, lsr #3
    ldrb    w9, [x9, #(STACK_OFFSET + PARAMS_ON_STACK_SVCPERMISSION)]
    and     x10, x8, #0x7
    lsr     x10, x9, x10
    tst     x10, #1
    b.eq    .Linvalid_svc_handler

    // システムコールハンドラを取得
    adr     x10, nnkernServiceTableAarch64
    ldr     x11, [x10, x8, lsl #3]
    cbz     x11, .Linvalid_svc_handler

    mrs     x18, tpidr_el1
    strb    w8, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_SVCNO)]

    NN_KERN_KTRACE_SVC_ENTER_TRACE(x11)

    msr     daifclr, #2
    blr     x11
    msr     daifset, #2

.Ldpc_handler:
    ldrb    w8, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_DPCFLAGS)]
    cmp     w8, #0
    b.eq    .Lsvc_return

    SAVE_AARCH64_REGS
    bl      _ZN2nn4kern3svc10DpcHandlerEv
    RESTORE_AARCH64_REGS
    b       .Ldpc_handler

.Linvalid_svc_handler:
    stp      x0,  x1, [sp, #(8 * 0)]
    stp      x2,  x3, [sp, #(8 * 2)]
    stp      x4,  x5, [sp, #(8 * 4)]
    stp      x6,  x7, [sp, #(8 * 6)]
    stp     xzr, xzr, [sp, #(8 * 8)]
    stp     xzr, xzr, [sp, #(8 * 10)]
    stp     xzr, xzr, [sp, #(8 * 12)]
    stp     xzr, xzr, [sp, #(8 * 14)]
    stp     xzr, xzr, [sp, #(8 * 16)]
    stp     xzr, x19, [sp, #(8 * 18)]
    stp     x20, x21, [sp, #(8 * 20)]
    stp     x22, x23, [sp, #(8 * 22)]
    stp     x24, x25, [sp, #(8 * 24)]
    stp     x26, x27, [sp, #(8 * 26)]
    stp     x28, x29, [sp, #(8 * 28)]

    mov     x0, sp
    mrs     x18, tpidr_el1
    bl      _ZN2nn4kern6ARMv8A15HandleExceptionEPNS0_5ARM6416ExceptionContextE

    ldp     x30,  x8, [sp, #(EXCEPTION_CONTEXT_X30)]
    ldp      x9, x10, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x11,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr     sp_el0,   x8
    msr     elr_el1,  x9
    msr     spsr_el1, x10
    msr     tpidr_el0, x11
    ldp      x0,  x1, [sp, #(8 * 0)]
    ldp      x2,  x3, [sp, #(8 * 2)]
    ldp      x4,  x5, [sp, #(8 * 4)]
    ldp      x6,  x7, [sp, #(8 * 6)]
    ldp      x8,  x9, [sp, #(8 * 8)]
    ldp     x10, x11, [sp, #(8 * 10)]
    ldp     x12, x13, [sp, #(8 * 12)]
    ldp     x14, x15, [sp, #(8 * 14)]
    ldp     x16, x17, [sp, #(8 * 16)]
    ldp     x18, x19, [sp, #(8 * 18)]
    ldp     x20, x21, [sp, #(8 * 20)]
    ldp     x22, x23, [sp, #(8 * 22)]
    ldp     x24, x25, [sp, #(8 * 24)]
    ldp     x26, x27, [sp, #(8 * 26)]
    ldp     x28, x29, [sp, #(8 * 28)]

    add sp, sp, #STACK_OFFSET
    eret

.Lsvc_return:
    NN_KERN_KTRACE_SVC_LEAVE_TRACE

    mov     w8, #0
    strb    w8, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]

    ldp     x30,  x8, [sp, #(EXCEPTION_CONTEXT_X30)]
    ldp      x9, x10, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x11,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr     sp_el0,   x8
    msr     elr_el1,  x9
    msr     spsr_el1, x10
    msr     tpidr_el0, x11

    mov     x8, #0
    mov     x9, #0
    mov     x10, #0
    mov     x11, #0
    mov     x12, #0
    mov     x13, #0
    mov     x14, #0
    mov     x15, #0
    mov     x16, #0
    mov     x17, #0
    mov     x18, #0

    add sp, sp, #STACK_OFFSET
    eret
SET_SIZE(SvcHandler64)



#define SAVE_AARCH32_REGS           \
    sub     sp, sp, #(4 * 8)      ; \
    stp     w0, w1, [sp, #(4 * 0)]; \
    stp     w2, w3, [sp, #(4 * 2)]; \
    stp     w4, w5, [sp, #(4 * 4)]; \
    stp     w6, w7, [sp, #(4 * 6)]

#define RESTORE_AARCH32_REGS        \
    ldp     w0, w1, [sp, #(4 * 0)]; \
    ldp     w2, w3, [sp, #(4 * 2)]; \
    ldp     w4, w5, [sp, #(4 * 4)]; \
    ldp     w6, w7, [sp, #(4 * 6)]; \
    add     sp, sp, #(4 * 8)

ENTRY(SvcHandler32)
    // x0 ～ x7 のレジスタの上位32bitをクリアする。
    // x8 ～ x14はテンポラリレジスタなのでクリアしない。
    // Linuxでは x0 のみクリアしているので、ARM Architecture Reference Manual にない
    // 最適化ができるかもしれない。

    mov w0, w0
    mov w1, w1
    mov w2, w2
    mov w3, w3
    mov w4, w4
    mov w5, w5
    mov w6, w6
    mov w7, w7

    sub     sp, sp, #STACK_OFFSET
    mrs     x17, elr_el1
    mrs     x20, spsr_el1
    mrs     x19, tpidr_el0
    stp     x17, x20, [sp, #(EXCEPTION_CONTEXT_PC)]
    str     x19,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]

    // user mode register の保存
    stp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    stp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X2)]
    stp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X4)]
    stp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X6)]
    stp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X8)]
    stp      x10,x11, [sp, #(EXCEPTION_CONTEXT_X10)]
    stp      x12,x13, [sp, #(EXCEPTION_CONTEXT_X12)]
    stp      x14,xzr, [sp, #(EXCEPTION_CONTEXT_X14)]

    // システムコール番号取得
    mrs     x16, esr_el1
    and     x16, x16, #0xFF
    cmp     x16, #128
    b.ge    .Linvalid_svc_handler32

    // プロセスに許可されている SVC_ID か否かをチェック
    mov     x20, sp
    add     x20, x20, x16, lsr #3
    ldrb    w20, [x20, #(STACK_OFFSET + PARAMS_ON_STACK_SVCPERMISSION)]
    and     x17, x16, #0x7
    lsr     x17, x20, x17
    tst     x17, #1
    b.eq    .Linvalid_svc_handler32

    // システムコールハンドラを取得
    adr     x15, nnkernServiceTableAarch64From32
    ldr     x19, [x15, x16, lsl #3]
    cbz     x19, .Linvalid_svc_handler32

    mov     w15, #1
    strb    w15, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]
    strb    w16, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_SVCNO)]
    mrs     x18, tpidr_el1

    NN_KERN_KTRACE_SVC_ENTER_TRACE(x19)

    msr     daifclr, #2
    blr     x19
    msr     daifset, #2

.Ldpc_handler32:
    ldrb    w16, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_DPCFLAGS)]
    cmp     w16, #0
    b.eq    .Lsvc_return32

    SAVE_AARCH32_REGS
    bl      _ZN2nn4kern3svc10DpcHandlerEv
    RESTORE_AARCH32_REGS

    b       .Ldpc_handler32

.Linvalid_svc_handler32:
    // x8 - x14, spsr, pc は保存済み
    stp      x0,  x1, [sp, #(8 * 0)]
    stp      x2,  x3, [sp, #(8 * 2)]
    stp      x4,  x5, [sp, #(8 * 4)]
    stp      x6,  x7, [sp, #(8 * 6)]
    stp     xzr, xzr, [sp, #(8 * 16)]
    stp     xzr, xzr, [sp, #(8 * 18)]
    stp     xzr, xzr, [sp, #(8 * 20)]
    stp     xzr, xzr, [sp, #(8 * 22)]
    stp     xzr, xzr, [sp, #(8 * 24)]
    stp     xzr, xzr, [sp, #(8 * 26)]
    stp     xzr, xzr, [sp, #(8 * 28)]
    stp     xzr, xzr, [sp, #(8 * 30)]

    mov     x0, sp
    mrs     x18, tpidr_el1
    bl      _ZN2nn4kern6ARMv8A15HandleExceptionEPNS0_5ARM6416ExceptionContextE

    ldp     x17, x20, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x19,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr     elr_el1,  x17
    msr     spsr_el1, x20
    msr     tpidr_el0, x19
    ldp      x0,  x1, [sp, #(8 * 0)]
    ldp      x2,  x3, [sp, #(8 * 2)]
    ldp      x4,  x5, [sp, #(8 * 4)]
    ldp      x6,  x7, [sp, #(8 * 6)]
    ldp      x8,  x9, [sp, #(8 * 8)]
    ldp     x10, x11, [sp, #(8 * 10)]
    ldp     x12, x13, [sp, #(8 * 12)]
    ldp     x14, x15, [sp, #(8 * 14)]
    add     sp, sp, #STACK_OFFSET
    eret

.Lsvc_return32:
    NN_KERN_KTRACE_SVC_LEAVE_TRACE

    mov     w16, #0
    strb    w16, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]
    ldp      x8,  x9, [sp, #(8 * 8)]
    ldp     x10, x11, [sp, #(8 * 10)]
    ldp     x12, x13, [sp, #(8 * 12)]
    ldp     x14, xzr, [sp, #(8 * 14)]
    ldp     x17, x20, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x19,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr elr_el1, x17
    msr spsr_el1, x20
    msr tpidr_el0, x19
    add sp, sp, #STACK_OFFSET
    eret
SET_SIZE(SvcHandler32)

ENTRY(_ZN2nn4kern3svc14RestoreContextEm)
    mov     sp, x0
    msr     daifset, #2

.Ldpc_handler1:
    ldrb    w8, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_DPCFLAGS)]
    cbz     w8, .Lsvc_return1

    SAVE_AARCH64_REGS
    bl      _ZN2nn4kern3svc10DpcHandlerEv
    RESTORE_AARCH64_REGS
    b       .Ldpc_handler1

.Lsvc_return1:
    mov     w8, #0
    strb    w8, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]

    ldp     x30,  x8, [sp, #(EXCEPTION_CONTEXT_X30)]
    ldp      x9, x10, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x11,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr     sp_el0,   x8
    msr     elr_el1,  x9
    msr     spsr_el1, x10
    msr     tpidr_el0, x11

    ldp      x0,  x1, [sp, #(8 * 0)]
    ldp      x2,  x3, [sp, #(8 * 2)]
    ldp      x4,  x5, [sp, #(8 * 4)]
    ldp      x6,  x7, [sp, #(8 * 6)]
    ldp      x8,  x9, [sp, #(8 * 8)]
    ldp     x10, x11, [sp, #(8 * 10)]
    ldp     x12, x13, [sp, #(8 * 12)]
    ldp     x14, x15, [sp, #(8 * 14)]
    ldp     x16, x17, [sp, #(8 * 16)]
    ldp     x18, x19, [sp, #(8 * 18)]
    ldp     x20, x21, [sp, #(8 * 20)]
    ldp     x22, x23, [sp, #(8 * 22)]
    ldp     x24, x25, [sp, #(8 * 24)]
    ldp     x26, x27, [sp, #(8 * 26)]
    ldp     x28, x29, [sp, #(8 * 28)]
    add     sp, sp, #STACK_OFFSET
    eret
SET_SIZE(_ZN2nn4kern3svc14RestoreContextEm)

ENTRY(_ZN2nn4kern3svc24SvcReturnFromException64ENS_6ResultE)
    // x9, x10, x11, x18 は保存済み
    stp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X12)]
    stp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X14)]
    stp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X16)]
    str     x19,      [sp, #(EXCEPTION_CONTEXT_X19)]
    stp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X20)]
    stp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X22)]
    stp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X24)]
    stp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X26)]
    stp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X28)]
    // x0～x8, x30, sp, pc, spsr はプロセス固有領域からコピーされる
    bl      _ZN2nn4kern6ARMv8A19ReturnFromExceptionENS_6ResultE
1:  b       1b
SET_SIZE(_ZN2nn4kern3svc24SvcReturnFromException64ENS_6ResultE)

ENTRY(_ZN2nn4kern3svc30SvcReturnFromException64From32ENS_6ResultE)
    // x9 ～ x14 は保存済み
    // x0～x8, spsr はproc info
    bl      _ZN2nn4kern6ARMv8A19ReturnFromExceptionENS_6ResultE
1:  b       1b
SET_SIZE(_ZN2nn4kern3svc30SvcReturnFromException64From32ENS_6ResultE)
