﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#pragma once

#include "../../../svc/kern_KUserPointer.h"
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_BaseType.h>
#include <nn/svc/svc_DdType.h>
#include <nn/svc/svc_DmntType.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_ServerType.h>
#include <nn/svc/svc_TcbType.h>

#include <nn/svc/svc_BaseType.lp64.autogen.h>
#include <nn/svc/svc_DdType.lp64.autogen.h>
#include <nn/svc/svc_DmntType.lp64.autogen.h>
#include <nn/svc/svc_TcbType.lp64.autogen.h>

#ifdef __cplusplus

namespace nn {
namespace kern {
namespace svc {

    Result  SvcSetHeapSize64                    (uintptr_t* pOut, size_t size);
    Result  SvcSetMemoryPermission64            (uintptr_t addr, size_t size, nn::svc::MemoryPermission permission);
    Result  SvcSetMemoryAttribute64             (uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute);
    Result  SvcMapMemory64                      (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  SvcUnmapMemory64                    (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  SvcQueryMemory64                    (KUserPointer<nn::svc::lp64::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr);
    void    SvcExitProcess64                    ();
    Result  SvcCreateThread64                   (nn::svc::Handle* pOut, nn::svc::lp64::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore);
    Result  SvcStartThread64                    (nn::svc::Handle thread);
    void    SvcExitThread64                     ();
    void    SvcSleepThread64                    (int64_t ns);
    Result  SvcGetThreadPriority64              (int32_t* pOut, nn::svc::Handle thread);
    Result  SvcSetThreadPriority64              (nn::svc::Handle thread, int32_t priority);
    Result  SvcGetThreadCoreMask64              (int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread);
    Result  SvcSetThreadCoreMask64              (nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask);
    int32_t SvcGetCurrentProcessorNumber64      ();
    Result  SvcSignalEvent64                    (nn::svc::Handle event);
    Result  SvcClearEvent64                     (nn::svc::Handle event);
    Result  SvcMapSharedMemory64                (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  SvcUnmapSharedMemory64              (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result  SvcCreateTransferMemory64           (nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  SvcCloseHandle64                    (nn::svc::Handle handle);
    Result  SvcResetSignal64                    (nn::svc::Handle handle);
    Result  SvcWaitSynchronization64            (int32_t* pOut, KUserPointer<const nn::svc::Handle*> handles, int32_t numHandles, int64_t ns);
    Result  SvcCancelSynchronization64          (nn::svc::Handle handle);
    Result  SvcArbitrateLock64                  (nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue);
    Result  SvcArbitrateUnlock64                (uintptr_t addr);
    Result  SvcWaitProcessWideKeyAtomic64       (uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns);
    void    SvcSignalProcessWideKey64           (uintptr_t cvKey, int32_t num);
    int64_t SvcGetSystemTick64                  ();
    Result  SvcConnectToNamedPort64             (nn::svc::Handle* pOut, KUserPointer<const char*> name);
    Result  SvcSendSyncRequestLight64           (nn::svc::Handle session);
    Result  SvcSendSyncRequest64                (nn::svc::Handle session);
    Result  SvcSendSyncRequestWithUserBuffer64  (uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  SvcSendAsyncRequestWithUserBuffer64 (nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  SvcGetProcessId64                   (nn::Bit64* pOut, nn::svc::Handle process);
    Result  SvcGetThreadId64                    (nn::Bit64* pOut, nn::svc::Handle thread);
    void    SvcBreak64                          (nn::svc::BreakReason reason, uintptr_t data, size_t length);
    Result  SvcOutputDebugString64              (KUserPointer<const char*> text, size_t length);
    void    SvcReturnFromException64            (nn::Result result);
    Result  SvcGetInfo64                        (nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param);
    void    SvcFlushEntireDataCache64           ();
    Result  SvcFlushDataCache64                 (uintptr_t addr, size_t size);
    Result  SvcMapPhysicalMemory64              (uintptr_t addr, size_t size);
    Result  SvcUnmapPhysicalMemory64            (uintptr_t addr, size_t size);
    Result  SvcGetDebugFutureThreadInfo64       (nn::svc::lp64::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns);
    Result  SvcGetLastThreadInfo64              (nn::svc::lp64::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag);
    Result  SvcGetResourceLimitLimitValue64     (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  SvcGetResourceLimitCurrentValue64   (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  SvcSetThreadActivity64              (nn::svc::Handle handle, nn::svc::ThreadActivity activity);
    Result  SvcGetThreadContext364              (KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle handle);
    Result  SvcWaitForAddress64                 (uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns);
    Result  SvcSignalToAddress64                (uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num);
    void    SvcKernelDebug64                    (nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2);
    void    SvcChangeKernelTraceState64         (nn::svc::KernelTraceState state);
    Result  SvcCreateSession64                  (nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name);
    Result  SvcAcceptSession64                  (nn::svc::Handle* pOut, nn::svc::Handle port);
    Result  SvcReplyAndReceiveLight64           (nn::svc::Handle session);
    Result  SvcReplyAndReceive64                (int32_t* pIndex, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    Result  SvcReplyAndReceiveWithUserBuffer64  (int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    Result  SvcCreateEvent64                    (nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle);
    Result  SvcMapPhysicalMemoryUnsafe64        (uintptr_t addr, size_t size);
    Result  SvcUnmapPhysicalMemoryUnsafe64      (uintptr_t addr, size_t size);
    Result  SvcSetUnsafeLimit64                 (size_t limitSize);
    Result  SvcCreateCodeMemory64               (nn::svc::Handle* pOut, uintptr_t addr, size_t size);
    Result  SvcControlCodeMemory64              (nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission);
    void    SvcSleepSystem64                    ();
    Result  SvcReadWriteRegister64              (nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value);
    Result  SvcSetProcessActivity64             (nn::svc::Handle handle, nn::svc::ProcessActivity activity);
    Result  SvcCreateSharedMemory64             (nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission);
    Result  SvcMapTransferMemory64              (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission);
    Result  SvcUnmapTransferMemory64            (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result  SvcCreateInterruptEvent64           (nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type);
    Result  SvcQueryPhysicalAddress64           (nn::svc::lp64::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr);
    Result  SvcQueryIoMapping64                 (uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size);
    Result  SvcCreateDeviceAddressSpace64       (nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize);
    Result  SvcAttachDeviceAddressSpace64       (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result  SvcDetachDeviceAddressSpace64       (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result  SvcMapDeviceAddressSpaceByForce64   (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcMapDeviceAddressSpaceAligned64   (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcMapDeviceAddressSpace64          (size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcUnmapDeviceAddressSpace64        (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress);
    Result  SvcInvalidateProcessDataCache64     (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcStoreProcessDataCache64          (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcFlushProcessDataCache64          (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcDebugActiveProcess64             (nn::svc::Handle* pOut, nn::Bit64 processId);
    Result  SvcBreakDebugProcess64              (nn::svc::Handle debug);
    Result  SvcTerminateDebugProcess64          (nn::svc::Handle debug);
    Result  SvcGetDebugEvent64                  (KUserPointer<nn::svc::lp64::DebugEventInfo*> pInfo, nn::svc::Handle debug);
    Result  SvcContinueDebugEvent64             (nn::svc::Handle debug, nn::Bit32 flags, KUserPointer<const nn::Bit64*> pThreadIds, int32_t arraySize);
    Result  SvcGetProcessList64                 (int32_t* pNumProcesses, KUserPointer<nn::Bit64*> pProcessIds, int32_t arraySize);
    Result  SvcGetThreadList64                  (int32_t* pNumThreads, KUserPointer<nn::Bit64*> pThreadIds, int32_t arraySize, nn::svc::Handle domain);
    Result  SvcGetDebugThreadContext64          (KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags);
    Result  SvcSetDebugThreadContext64          (nn::svc::Handle debug, nn::Bit64 threadId, KUserPointer<const nn::svc::ThreadContext*> context, nn::Bit32 controlFlags);
    Result  SvcQueryDebugProcessMemory64        (KUserPointer<nn::svc::lp64::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr);
    Result  SvcReadDebugProcessMemory64         (uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size);
    Result  SvcWriteDebugProcessMemory64        (nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size);
    Result  SvcSetHardwareBreakPoint64          (nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value);
    Result  SvcGetDebugThreadParam64            (nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select);
    Result  SvcGetSystemInfo64                  (nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param);
    Result  SvcCreatePort64                     (nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name);
    Result  SvcManageNamedPort64                (nn::svc::Handle* pOutServer, KUserPointer<const char*> name, int32_t maxSessions);
    Result  SvcConnectToPort64                  (nn::svc::Handle* pOut, nn::svc::Handle port);
    Result  SvcSetProcessMemoryPermission64     (nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission);
    Result  SvcMapProcessMemory64               (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result  SvcUnmapProcessMemory64             (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result  SvcQueryProcessMemory64             (KUserPointer<nn::svc::lp64::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr);
    Result  SvcMapProcessCodeMemory64           (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result  SvcUnmapProcessCodeMemory64         (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result  SvcCreateProcess64                  (nn::svc::Handle* pOut, KUserPointer<const nn::svc::lp64::CreateProcessParameter*> params, KUserPointer<const nn::Bit32*> flags, int32_t flagsNum);
    Result  SvcStartProcess64                   (nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize);
    Result  SvcTerminateProcess64               (nn::svc::Handle process);
    Result  SvcGetProcessInfo64                 (int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type);
    Result  SvcCreateResourceLimit64            (nn::svc::Handle* pOut);
    Result  SvcSetResourceLimitLimitValue64     (nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value);
    void    SvcCallSecureMonitor64              ();

} // end of namespace svc
} // end of namespace kern
} // end of namespace nn

#endif  // ifdef __cplusplus

