﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */


//
// type name                                size al abstr comon
//
// Handle                                      4  4 True  True 
// ProgramId                                   8  8 True  True 
// MemoryState                                 4  4 True  True 
// MemoryAttribute                             4  4 True  True 
// MemoryPermission                            4  4 True  True 
// InterruptType                               4  4 True  True 
// BreakReason                                 4  4 True  True 
// InfoType                                    4  4 True  True 
// SystemInfoType                              4  4 True  True 
// KernelDebugType                             4  4 True  True 
// LimitableResource                           4  4 True  True 
// ThreadActivity                              4  4 True  True 
// ProcessActivity                             4  4 True  True 
// KernelTraceState                            4  4 True  True 
// CodeMemoryOperation                         4  4 True  True 
// ArbitrationType                             4  4 True  True 
// SignalType                                  4  4 True  True 
// PageInfo                                    4  4 True  True 
// ThreadFunc                                  4  4 True  False
// MemoryInfo                                 40  8 False False
// LastThreadContext                          16  4 False False
// DebugEvent                                  4  4 True  True 
// DebugException                              4  4 True  True 
// ProcessExitReason                           4  4 True  True 
// ThreadExitReason                            4  4 True  True 
// BreakPointType                              4  4 True  True 
// DebugThreadParam                            4  4 True  True 
// HardwareBreakPointRegisterName              4  4 True  True 
// DebugInfoCreateProcess                     40  8 False False
// DebugInfoCreateThread                      16  8 False False
// DebugInfoExitProcess                        4  4 False False
// DebugInfoExitThread                         4  4 False False
// DebugInfoExceptionAccessViolationData       4  4 False False
// DebugInfoExceptionDataTypeMissaligned       4  4 False False
// DebugInfoExceptionBreakPoint                8  4 False False
// DebugInfoExceptionUserBreak                12  4 False False
// DebugInfoExceptionDebuggerBreak            32  8 False False
// DebugInfoExceptionUndefinedInstruction      4  4 False False
// DebugInfoExceptionUndefinedSystemCall       4  4 False False
// DebugInfoExceptionDetail                   32  8 False False
// DebugInfoException                         40  8 False False
// DebugInfo                                  40  8 False False
// DebugEventInfo                             56  8 False False
// ThreadContext                             332  4 True  True 
// DeviceName                                  4  4 True  True 
// PhysicalAddress                             8  8 True  True 
// DMADeviceConfig                            10  2 True  True 
// DmaConfig                                  24  2 True  True 
// PhysicalMemoryInfo                         16  8 False False
// CreateProcessParameterFlags                 4  4 True  True 
// ProcessInfoType                             4  4 True  True 
// CreateProcessParameter                     48  8 False False
//

//-------------------------------------------------
// Result SetHeapSize(uintptr_t* pOut, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 size     Register 1       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallSetHeapSizeEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallSetHeapSizeEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallSetHeapSizeEv, %function
    .type    _ZN2nn4kern3svc22SvcSetHeapSize64From32EPmm, %function
_ZN2nn4kern3svc13Aarch64From3215CallSetHeapSizeEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcSetHeapSize64From32EPmm

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallSetHeapSizeEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallSetHeapSizeEv]

//-------------------------------------------------
// Result SetMemoryPermission(uintptr_t addr, size_t size, nn::svc::MemoryPermission permission)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       4 addr         Register 0       8 addr
//     Register 1       4 size         Register 1       8 size
//     Register 2       4 permission   Register 2       4 permission
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3223CallSetMemoryPermissionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3223CallSetMemoryPermissionEv
    .type    _ZN2nn4kern3svc13Aarch64From3223CallSetMemoryPermissionEv, %function
    .type    _ZN2nn4kern3svc30SvcSetMemoryPermission64From32EmmNS_3svc16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3223CallSetMemoryPermissionEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc30SvcSetMemoryPermission64From32EmmNS_3svc16MemoryPermissionE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3223CallSetMemoryPermissionEv, [.-_ZN2nn4kern3svc13Aarch64From3223CallSetMemoryPermissionEv]

//-------------------------------------------------
// Result SetMemoryAttribute(uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute)
//
//     Invariant s=4 r=8 p=4          AArch64 s=8 r=8 p=8
// in  svc                            abi
//     Register 0       4 addr        Register 0       8 addr
//     Register 1       4 size        Register 1       8 size
//     Register 2       4 mask        Register 2       4 mask
//     Register 3       4 attribute   Register 3       4 attribute
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallSetMemoryAttributeEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallSetMemoryAttributeEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallSetMemoryAttributeEv, %function
    .type    _ZN2nn4kern3svc29SvcSetMemoryAttribute64From32Emmjj, %function
_ZN2nn4kern3svc13Aarch64From3222CallSetMemoryAttributeEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc29SvcSetMemoryAttribute64From32Emmjj
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallSetMemoryAttributeEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallSetMemoryAttributeEv]

//-------------------------------------------------
// Result MapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 fromAddr   Register 1       8 fromAddr
//     Register 2       4 size       Register 2       8 size
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3213CallMapMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3213CallMapMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3213CallMapMemoryEv, %function
    .type    _ZN2nn4kern3svc20SvcMapMemory64From32Emmm, %function
_ZN2nn4kern3svc13Aarch64From3213CallMapMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc20SvcMapMemory64From32Emmm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3213CallMapMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3213CallMapMemoryEv]

//-------------------------------------------------
// Result UnmapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 fromAddr   Register 1       8 fromAddr
//     Register 2       4 size       Register 2       8 size
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallUnmapMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallUnmapMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallUnmapMemoryEv, %function
    .type    _ZN2nn4kern3svc22SvcUnmapMemory64From32Emmm, %function
_ZN2nn4kern3svc13Aarch64From3215CallUnmapMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc22SvcUnmapMemory64From32Emmm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallUnmapMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallUnmapMemoryEv]

//-------------------------------------------------
// Result QueryMemory(KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//                                     Register 1  ref  4 pPageInfo
//     Register 2       4 addr         Register 2       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallQueryMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallQueryMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallQueryMemoryEv, %function
    .type    _ZN2nn4kern3svc22SvcQueryMemory64From32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoEm, %function
_ZN2nn4kern3svc13Aarch64From3215CallQueryMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcQueryMemory64From32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoEm

    ldr      w1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallQueryMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallQueryMemoryEv]

//-------------------------------------------------
// void ExitProcess()
//
//     Invariant s=4 r=8 p=4   AArch64 s=8 r=8 p=8
// in  svc   abi
//
// in  svc   abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallExitProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallExitProcessEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallExitProcessEv, %function
    .type    _ZN2nn4kern3svc22SvcExitProcess64From32Ev, %function
_ZN2nn4kern3svc13Aarch64From3215CallExitProcessEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc22SvcExitProcess64From32Ev
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallExitProcessEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallExitProcessEv]

//-------------------------------------------------
// Result CreateThread(nn::svc::Handle* pOut, nn::svc::ilp32::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore)
//
//     Invariant s=4 r=8 p=4            AArch64 s=8 r=8 p=8
// in  svc                              abi
//     Register 0       4 priority      Register 0  ref  4 pOut
//     Register 1       4 f             Register 1       4 f
//     Register 2       4 param         Register 2       8 param
//     Register 3       4 stackBottom   Register 3       8 stackBottom
//     Register 4       4 idealCore     Register 4       4 priority
//                                      Register 5       4 idealCore
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOut          
//
// conversion
//   Move            priority
//   Move            idealCore
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3216CallCreateThreadEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3216CallCreateThreadEv
    .type    _ZN2nn4kern3svc13Aarch64From3216CallCreateThreadEv, %function
    .type    _ZN2nn4kern3svc23SvcCreateThread64From32EPNS_3svc6HandleEmmmii, %function
_ZN2nn4kern3svc13Aarch64From3216CallCreateThreadEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    sub      sp, sp, #16

    mov      x5, x4                    // idealCore
    mov      x4, x0                    // priority

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcCreateThread64From32EPNS_3svc6HandleEmmmii

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3216CallCreateThreadEv, [.-_ZN2nn4kern3svc13Aarch64From3216CallCreateThreadEv]

//-------------------------------------------------
// Result StartThread(nn::svc::Handle thread)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 thread   Register 0       4 thread
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallStartThreadEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallStartThreadEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallStartThreadEv, %function
    .type    _ZN2nn4kern3svc22SvcStartThread64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3215CallStartThreadEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc22SvcStartThread64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallStartThreadEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallStartThreadEv]

//-------------------------------------------------
// void ExitThread()
//
//     Invariant s=4 r=8 p=4   AArch64 s=8 r=8 p=8
// in  svc   abi
//
// in  svc   abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3214CallExitThreadEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3214CallExitThreadEv
    .type    _ZN2nn4kern3svc13Aarch64From3214CallExitThreadEv, %function
    .type    _ZN2nn4kern3svc21SvcExitThread64From32Ev, %function
_ZN2nn4kern3svc13Aarch64From3214CallExitThreadEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc21SvcExitThread64From32Ev
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3214CallExitThreadEv, [.-_ZN2nn4kern3svc13Aarch64From3214CallExitThreadEv]

//-------------------------------------------------
// void SleepThread(int64_t ns)
//
//     Invariant s=4 r=8 p=4   AArch64 s=8 r=8 p=8
// in  svc                     abi
//     Register 0       8 ns   Register 0       8 ns
//     Register 1       8 ns   
//
// in  svc                     abi
//
// conversion
//   Pack            ns

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallSleepThreadEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallSleepThreadEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallSleepThreadEv, %function
    .type    _ZN2nn4kern3svc22SvcSleepThread64From32El, %function
_ZN2nn4kern3svc13Aarch64From3215CallSleepThreadEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    orr      x0, x0, x1, lsl #32       // ns を 32 bit x2 から 64 bit へ

    bl       _ZN2nn4kern3svc22SvcSleepThread64From32El
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallSleepThreadEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallSleepThreadEv]

//-------------------------------------------------
// Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 thread   Register 1       4 thread
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallGetThreadPriorityEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallGetThreadPriorityEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallGetThreadPriorityEv, %function
    .type    _ZN2nn4kern3svc28SvcGetThreadPriority64From32EPiNS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3221CallGetThreadPriorityEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc28SvcGetThreadPriority64From32EPiNS_3svc6HandleE

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallGetThreadPriorityEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallGetThreadPriorityEv]

//-------------------------------------------------
// Result SetThreadPriority(nn::svc::Handle thread, int32_t priority)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 thread     Register 0       4 thread
//     Register 1       4 priority   Register 1       4 priority
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallSetThreadPriorityEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallSetThreadPriorityEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallSetThreadPriorityEv, %function
    .type    _ZN2nn4kern3svc28SvcSetThreadPriority64From32ENS_3svc6HandleEi, %function
_ZN2nn4kern3svc13Aarch64From3221CallSetThreadPriorityEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcSetThreadPriority64From32ENS_3svc6HandleEi
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallSetThreadPriorityEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallSetThreadPriorityEv]

//-------------------------------------------------
// Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread)
//
//     Invariant s=4 r=8 p=4              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  4 pIdealCore
//                                        Register 1  ref  8 pAffinityMask
//     Register 2       4 thread          Register 2       4 thread
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       4 pIdealCore      
//     Register 2       8 pAffinityMask   
//     Register 3       8 pAffinityMask   
//
// conversion
//   Scatter         pIdealCore
//   Scatter         pAffinityMask

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallGetThreadCoreMaskEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallGetThreadCoreMaskEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallGetThreadCoreMaskEv, %function
    .type    _ZN2nn4kern3svc28SvcGetThreadCoreMask64From32EPiPmNS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3221CallGetThreadCoreMaskEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pIdealCore の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pIdealCore のアドレスをレジスタへ
    str      w2, [sp, #8]              // pAffinityMask の第 1 ワードをレジスタからスタックへ
    str      w3, [sp, #12]             // pAffinityMask の第 2 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pAffinityMask のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc28SvcGetThreadCoreMask64From32EPiPmNS_3svc6HandleE

    ldr      w1, [sp, #0]              // pIdealCore の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #8]              // pAffinityMask の第 1 ワードをスタックからレジスタへ
    ldr      w3, [sp, #12]             // pAffinityMask の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallGetThreadCoreMaskEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallGetThreadCoreMaskEv]

//-------------------------------------------------
// Result SetThreadCoreMask(nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask)
//
//     Invariant s=4 r=8 p=4             AArch64 s=8 r=8 p=8
// in  svc                               abi
//     Register 0       4 thread         Register 0       4 thread
//     Register 1       4 idealCore      Register 1       4 idealCore
//     Register 2       8 affinityMask   Register 2       8 affinityMask
//     Register 3       8 affinityMask   
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//
// conversion
//   Pack            affinityMask

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallSetThreadCoreMaskEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallSetThreadCoreMaskEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallSetThreadCoreMaskEv, %function
    .type    _ZN2nn4kern3svc28SvcSetThreadCoreMask64From32ENS_3svc6HandleEim, %function
_ZN2nn4kern3svc13Aarch64From3221CallSetThreadCoreMaskEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // affinityMask を 32 bit x2 から 64 bit へ

    bl       _ZN2nn4kern3svc28SvcSetThreadCoreMask64From32ENS_3svc6HandleEim
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallSetThreadCoreMaskEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallSetThreadCoreMaskEv]

//-------------------------------------------------
// int32_t GetCurrentProcessorNumber()
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3229CallGetCurrentProcessorNumberEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3229CallGetCurrentProcessorNumberEv
    .type    _ZN2nn4kern3svc13Aarch64From3229CallGetCurrentProcessorNumberEv, %function
    .type    _ZN2nn4kern3svc36SvcGetCurrentProcessorNumber64From32Ev, %function
_ZN2nn4kern3svc13Aarch64From3229CallGetCurrentProcessorNumberEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc36SvcGetCurrentProcessorNumber64From32Ev
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3229CallGetCurrentProcessorNumberEv, [.-_ZN2nn4kern3svc13Aarch64From3229CallGetCurrentProcessorNumberEv]

//-------------------------------------------------
// Result SignalEvent(nn::svc::Handle event)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 event    Register 0       4 event
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallSignalEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallSignalEventEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallSignalEventEv, %function
    .type    _ZN2nn4kern3svc22SvcSignalEvent64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3215CallSignalEventEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc22SvcSignalEvent64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallSignalEventEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallSignalEventEv]

//-------------------------------------------------
// Result ClearEvent(nn::svc::Handle event)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 event    Register 0       4 event
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3214CallClearEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3214CallClearEventEv
    .type    _ZN2nn4kern3svc13Aarch64From3214CallClearEventEv, %function
    .type    _ZN2nn4kern3svc21SvcClearEvent64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3214CallClearEventEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc21SvcClearEvent64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3214CallClearEventEv, [.-_ZN2nn4kern3svc13Aarch64From3214CallClearEventEv]

//-------------------------------------------------
// Result MapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     Invariant s=4 r=8 p=4             AArch64 s=8 r=8 p=8
// in  svc                               abi
//     Register 0       4 handle         Register 0       4 handle
//     Register 1       4 addr           Register 1       8 addr
//     Register 2       4 size           Register 2       8 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3219CallMapSharedMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3219CallMapSharedMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3219CallMapSharedMemoryEv, %function
    .type    _ZN2nn4kern3svc26SvcMapSharedMemory64From32ENS_3svc6HandleEmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3219CallMapSharedMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc26SvcMapSharedMemory64From32ENS_3svc6HandleEmmNS2_16MemoryPermissionE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3219CallMapSharedMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3219CallMapSharedMemoryEv]

//-------------------------------------------------
// Result UnmapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 handle   Register 0       4 handle
//     Register 1       4 addr     Register 1       8 addr
//     Register 2       4 size     Register 2       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallUnmapSharedMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallUnmapSharedMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallUnmapSharedMemoryEv, %function
    .type    _ZN2nn4kern3svc28SvcUnmapSharedMemory64From32ENS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3221CallUnmapSharedMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcUnmapSharedMemory64From32ENS_3svc6HandleEmm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallUnmapSharedMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallUnmapSharedMemoryEv]

//-------------------------------------------------
// Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     Invariant s=4 r=8 p=4             AArch64 s=8 r=8 p=8
// in  svc                               abi
//                                       Register 0  ref  4 pOut
//     Register 1       4 addr           Register 1       8 addr
//     Register 2       4 size           Register 2       8 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pOut           
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallCreateTransferMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallCreateTransferMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallCreateTransferMemoryEv, %function
    .type    _ZN2nn4kern3svc31SvcCreateTransferMemory64From32EPNS_3svc6HandleEmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3224CallCreateTransferMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc31SvcCreateTransferMemory64From32EPNS_3svc6HandleEmmNS2_16MemoryPermissionE

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallCreateTransferMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallCreateTransferMemoryEv]

//-------------------------------------------------
// Result CloseHandle(nn::svc::Handle handle)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 handle   Register 0       4 handle
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallCloseHandleEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallCloseHandleEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallCloseHandleEv, %function
    .type    _ZN2nn4kern3svc22SvcCloseHandle64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3215CallCloseHandleEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc22SvcCloseHandle64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallCloseHandleEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallCloseHandleEv]

//-------------------------------------------------
// Result ResetSignal(nn::svc::Handle handle)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 handle   Register 0       4 handle
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallResetSignalEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallResetSignalEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallResetSignalEv, %function
    .type    _ZN2nn4kern3svc22SvcResetSignal64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3215CallResetSignalEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc22SvcResetSignal64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallResetSignalEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallResetSignalEv]

//-------------------------------------------------
// Result WaitSynchronization(int32_t* pOut, KUserPointer<const nn::svc::Handle*> handles, int32_t numHandles, int64_t ns)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       8 ns           Register 0  ref  4 pOut
//     Register 1  ref -- handles      Register 1  ref -- handles
//     Register 2       4 numHandles   Register 2       4 numHandles
//     Register 3       8 ns           Register 3       8 ns
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pOut         
//
// conversion
//   Pack            ns
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3223CallWaitSynchronizationEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3223CallWaitSynchronizationEv
    .type    _ZN2nn4kern3svc13Aarch64From3223CallWaitSynchronizationEv, %function
    .type    _ZN2nn4kern3svc30SvcWaitSynchronization64From32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEil, %function
_ZN2nn4kern3svc13Aarch64From3223CallWaitSynchronizationEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    orr      x3, x0, x3, lsl #32       // ns を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc30SvcWaitSynchronization64From32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEil

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3223CallWaitSynchronizationEv, [.-_ZN2nn4kern3svc13Aarch64From3223CallWaitSynchronizationEv]

//-------------------------------------------------
// Result CancelSynchronization(nn::svc::Handle handle)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 handle   Register 0       4 handle
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallCancelSynchronizationEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallCancelSynchronizationEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallCancelSynchronizationEv, %function
    .type    _ZN2nn4kern3svc32SvcCancelSynchronization64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3225CallCancelSynchronizationEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc32SvcCancelSynchronization64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallCancelSynchronizationEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallCancelSynchronizationEv]

//-------------------------------------------------
// Result ArbitrateLock(nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 addr       Register 1       8 addr
//     Register 2       4 ownValue   Register 2       4 ownValue
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallArbitrateLockEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallArbitrateLockEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallArbitrateLockEv, %function
    .type    _ZN2nn4kern3svc24SvcArbitrateLock64From32ENS_3svc6HandleEmj, %function
_ZN2nn4kern3svc13Aarch64From3217CallArbitrateLockEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc24SvcArbitrateLock64From32ENS_3svc6HandleEmj
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallArbitrateLockEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallArbitrateLockEv]

//-------------------------------------------------
// Result ArbitrateUnlock(uintptr_t addr)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3219CallArbitrateUnlockEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3219CallArbitrateUnlockEv
    .type    _ZN2nn4kern3svc13Aarch64From3219CallArbitrateUnlockEv, %function
    .type    _ZN2nn4kern3svc26SvcArbitrateUnlock64From32Em, %function
_ZN2nn4kern3svc13Aarch64From3219CallArbitrateUnlockEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc26SvcArbitrateUnlock64From32Em
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3219CallArbitrateUnlockEv, [.-_ZN2nn4kern3svc13Aarch64From3219CallArbitrateUnlockEv]

//-------------------------------------------------
// Result WaitProcessWideKeyAtomic(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 addr       Register 0       8 addr
//     Register 1       4 cvKey      Register 1       8 cvKey
//     Register 2       4 ownValue   Register 2       4 ownValue
//     Register 3       8 ns         Register 3       8 ns
//     Register 4       8 ns         
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Pack            ns

    .section .text._ZN2nn4kern3svc13Aarch64From3228CallWaitProcessWideKeyAtomicEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3228CallWaitProcessWideKeyAtomicEv
    .type    _ZN2nn4kern3svc13Aarch64From3228CallWaitProcessWideKeyAtomicEv, %function
    .type    _ZN2nn4kern3svc35SvcWaitProcessWideKeyAtomic64From32Emmjl, %function
_ZN2nn4kern3svc13Aarch64From3228CallWaitProcessWideKeyAtomicEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x3, x3, x4, lsl #32       // ns を 32 bit x2 から 64 bit へ

    bl       _ZN2nn4kern3svc35SvcWaitProcessWideKeyAtomic64From32Emmjl
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3228CallWaitProcessWideKeyAtomicEv, [.-_ZN2nn4kern3svc13Aarch64From3228CallWaitProcessWideKeyAtomicEv]

//-------------------------------------------------
// void SignalProcessWideKey(uintptr_t cvKey, int32_t num)
//
//     Invariant s=4 r=8 p=4      AArch64 s=8 r=8 p=8
// in  svc                        abi
//     Register 0       4 cvKey   Register 0       8 cvKey
//     Register 1       4 num     Register 1       4 num
//
// in  svc                        abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallSignalProcessWideKeyEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallSignalProcessWideKeyEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallSignalProcessWideKeyEv, %function
    .type    _ZN2nn4kern3svc31SvcSignalProcessWideKey64From32Emi, %function
_ZN2nn4kern3svc13Aarch64From3224CallSignalProcessWideKeyEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc31SvcSignalProcessWideKey64From32Emi
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallSignalProcessWideKeyEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallSignalProcessWideKeyEv]

//-------------------------------------------------
// int64_t GetSystemTick()
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//
// in  svc                         abi
//     Register 0       8 return   Register 0       8 return
//     Register 1       8 return   
//
// conversion
//   Pack            return

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallGetSystemTickEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallGetSystemTickEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallGetSystemTickEv, %function
    .type    _ZN2nn4kern3svc24SvcGetSystemTick64From32Ev, %function
_ZN2nn4kern3svc13Aarch64From3217CallGetSystemTickEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!

    bl       _ZN2nn4kern3svc24SvcGetSystemTick64From32Ev

    lsr      x1, x0, #32               // return の Hi
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallGetSystemTickEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallGetSystemTickEv]

//-------------------------------------------------
// Result ConnectToNamedPort(nn::svc::Handle* pOut, KUserPointer<const char*> name)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1  ref -- name     Register 1  ref -- name
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallConnectToNamedPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallConnectToNamedPortEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallConnectToNamedPortEv, %function
    .type    _ZN2nn4kern3svc29SvcConnectToNamedPort64From32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEE, %function
_ZN2nn4kern3svc13Aarch64From3222CallConnectToNamedPortEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcConnectToNamedPort64From32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEE

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallConnectToNamedPortEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallConnectToNamedPortEv]

//-------------------------------------------------
// Result SendSyncRequestLight(nn::svc::Handle session)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 session   Register 0       4 session
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallSendSyncRequestLightEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallSendSyncRequestLightEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallSendSyncRequestLightEv, %function
    .type    _ZN2nn4kern3svc31SvcSendSyncRequestLight64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3224CallSendSyncRequestLightEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc31SvcSendSyncRequestLight64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallSendSyncRequestLightEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallSendSyncRequestLightEv]

//-------------------------------------------------
// Result SendSyncRequest(nn::svc::Handle session)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 session   Register 0       4 session
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3219CallSendSyncRequestEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3219CallSendSyncRequestEv
    .type    _ZN2nn4kern3svc13Aarch64From3219CallSendSyncRequestEv, %function
    .type    _ZN2nn4kern3svc26SvcSendSyncRequest64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3219CallSendSyncRequestEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc26SvcSendSyncRequest64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3219CallSendSyncRequestEv, [.-_ZN2nn4kern3svc13Aarch64From3219CallSendSyncRequestEv]

//-------------------------------------------------
// Result SendSyncRequestWithUserBuffer(uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       4 pMessage     Register 0       8 pMessage
//     Register 1       4 bufferSize   Register 1       8 bufferSize
//     Register 2       4 session      Register 2       4 session
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3233CallSendSyncRequestWithUserBufferEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3233CallSendSyncRequestWithUserBufferEv
    .type    _ZN2nn4kern3svc13Aarch64From3233CallSendSyncRequestWithUserBufferEv, %function
    .type    _ZN2nn4kern3svc40SvcSendSyncRequestWithUserBuffer64From32EmmNS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3233CallSendSyncRequestWithUserBufferEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc40SvcSendSyncRequestWithUserBuffer64From32EmmNS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3233CallSendSyncRequestWithUserBufferEv, [.-_ZN2nn4kern3svc13Aarch64From3233CallSendSyncRequestWithUserBufferEv]

//-------------------------------------------------
// Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//                                     Register 0  ref  4 pEvent
//     Register 1       4 pMessage     Register 1       8 pMessage
//     Register 2       4 bufferSize   Register 2       8 bufferSize
//     Register 3       4 session      Register 3       4 session
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pEvent       
//
// conversion
//   Scatter         pEvent

    .section .text._ZN2nn4kern3svc13Aarch64From3234CallSendAsyncRequestWithUserBufferEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3234CallSendAsyncRequestWithUserBufferEv
    .type    _ZN2nn4kern3svc13Aarch64From3234CallSendAsyncRequestWithUserBufferEv, %function
    .type    _ZN2nn4kern3svc41SvcSendAsyncRequestWithUserBuffer64From32EPNS_3svc6HandleEmmS3_, %function
_ZN2nn4kern3svc13Aarch64From3234CallSendAsyncRequestWithUserBufferEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pEvent の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pEvent のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc41SvcSendAsyncRequestWithUserBuffer64From32EPNS_3svc6HandleEmmS3_

    ldr      w1, [sp, #0]              // pEvent の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3234CallSendAsyncRequestWithUserBufferEv, [.-_ZN2nn4kern3svc13Aarch64From3234CallSendAsyncRequestWithUserBufferEv]

//-------------------------------------------------
// Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//                                  Register 0  ref  8 pOut
//     Register 1       4 process   Register 1       4 process
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//     Register 1       8 pOut      
//     Register 2       8 pOut      
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3216CallGetProcessIdEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3216CallGetProcessIdEv
    .type    _ZN2nn4kern3svc13Aarch64From3216CallGetProcessIdEv, %function
    .type    _ZN2nn4kern3svc23SvcGetProcessId64From32EPmNS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3216CallGetProcessIdEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcGetProcessId64From32EPmNS_3svc6HandleE

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3216CallGetProcessIdEv, [.-_ZN2nn4kern3svc13Aarch64From3216CallGetProcessIdEv]

//-------------------------------------------------
// Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 thread   Register 1       4 thread
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallGetThreadIdEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallGetThreadIdEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallGetThreadIdEv, %function
    .type    _ZN2nn4kern3svc22SvcGetThreadId64From32EPmNS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3215CallGetThreadIdEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcGetThreadId64From32EPmNS_3svc6HandleE

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallGetThreadIdEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallGetThreadIdEv]

//-------------------------------------------------
// void Break(nn::svc::BreakReason reason, uintptr_t data, size_t length)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 reason   Register 0       4 reason
//     Register 1       4 data     Register 1       8 data
//     Register 2       4 length   Register 2       8 length
//
// in  svc                         abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From329CallBreakEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From329CallBreakEv
    .type    _ZN2nn4kern3svc13Aarch64From329CallBreakEv, %function
    .type    _ZN2nn4kern3svc16SvcBreak64From32ENS_3svc11BreakReasonEmm, %function
_ZN2nn4kern3svc13Aarch64From329CallBreakEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc16SvcBreak64From32ENS_3svc11BreakReasonEmm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From329CallBreakEv, [.-_ZN2nn4kern3svc13Aarch64From329CallBreakEv]

//-------------------------------------------------
// Result OutputDebugString(KUserPointer<const char*> text, size_t length)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0  ref -- text     Register 0  ref -- text
//     Register 1       4 length   Register 1       8 length
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallOutputDebugStringEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallOutputDebugStringEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallOutputDebugStringEv, %function
    .type    _ZN2nn4kern3svc28SvcOutputDebugString64From32ENS1_12KUserPointerIPKcvEEm, %function
_ZN2nn4kern3svc13Aarch64From3221CallOutputDebugStringEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcOutputDebugString64From32ENS1_12KUserPointerIPKcvEEm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallOutputDebugStringEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallOutputDebugStringEv]

//-------------------------------------------------
// void ReturnFromException(nn::Result result)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 result   Register 0       4 result
//
// in  svc                         abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3223CallReturnFromExceptionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3223CallReturnFromExceptionEv
    .type    _ZN2nn4kern3svc13Aarch64From3223CallReturnFromExceptionEv, %function
    .type    _ZN2nn4kern3svc30SvcReturnFromException64From32ENS_6ResultE, %function
_ZN2nn4kern3svc13Aarch64From3223CallReturnFromExceptionEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc30SvcReturnFromException64From32ENS_6ResultE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3223CallReturnFromExceptionEv, [.-_ZN2nn4kern3svc13Aarch64From3223CallReturnFromExceptionEv]

//-------------------------------------------------
// Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       8 param    Register 0  ref  8 pOut
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Pack            param
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3211CallGetInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3211CallGetInfoEv
    .type    _ZN2nn4kern3svc13Aarch64From3211CallGetInfoEv, %function
    .type    _ZN2nn4kern3svc18SvcGetInfo64From32EPmNS_3svc8InfoTypeENS3_6HandleEm, %function
_ZN2nn4kern3svc13Aarch64From3211CallGetInfoEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    orr      x3, x0, x3, lsl #32       // param を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcGetInfo64From32EPmNS_3svc8InfoTypeENS3_6HandleEm

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3211CallGetInfoEv, [.-_ZN2nn4kern3svc13Aarch64From3211CallGetInfoEv]

//-------------------------------------------------
// void FlushEntireDataCache()
//
//     Invariant s=4 r=8 p=4   AArch64 s=8 r=8 p=8
// in  svc   abi
//
// in  svc   abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallFlushEntireDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallFlushEntireDataCacheEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallFlushEntireDataCacheEv, %function
    .type    _ZN2nn4kern3svc31SvcFlushEntireDataCache64From32Ev, %function
_ZN2nn4kern3svc13Aarch64From3224CallFlushEntireDataCacheEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc31SvcFlushEntireDataCache64From32Ev
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallFlushEntireDataCacheEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallFlushEntireDataCacheEv]

//-------------------------------------------------
// Result FlushDataCache(uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3218CallFlushDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3218CallFlushDataCacheEv
    .type    _ZN2nn4kern3svc13Aarch64From3218CallFlushDataCacheEv, %function
    .type    _ZN2nn4kern3svc25SvcFlushDataCache64From32Emm, %function
_ZN2nn4kern3svc13Aarch64From3218CallFlushDataCacheEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc25SvcFlushDataCache64From32Emm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3218CallFlushDataCacheEv, [.-_ZN2nn4kern3svc13Aarch64From3218CallFlushDataCacheEv]

//-------------------------------------------------
// Result MapPhysicalMemory(uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallMapPhysicalMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallMapPhysicalMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallMapPhysicalMemoryEv, %function
    .type    _ZN2nn4kern3svc28SvcMapPhysicalMemory64From32Emm, %function
_ZN2nn4kern3svc13Aarch64From3221CallMapPhysicalMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcMapPhysicalMemory64From32Emm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallMapPhysicalMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallMapPhysicalMemoryEv]

//-------------------------------------------------
// Result UnmapPhysicalMemory(uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3223CallUnmapPhysicalMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3223CallUnmapPhysicalMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3223CallUnmapPhysicalMemoryEv, %function
    .type    _ZN2nn4kern3svc30SvcUnmapPhysicalMemory64From32Emm, %function
_ZN2nn4kern3svc13Aarch64From3223CallUnmapPhysicalMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc30SvcUnmapPhysicalMemory64From32Emm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3223CallUnmapPhysicalMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3223CallUnmapPhysicalMemoryEv]

//-------------------------------------------------
// Result GetDebugFutureThreadInfo(nn::svc::ilp32::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       8 ns         Register 0  ref 16 pContext
//     Register 1       8 ns         Register 1  ref  8 threadId
//     Register 2       4 debug      Register 2       4 debug
//                                   Register 3       8 ns
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1      16 pContext   
//     Register 2      16 pContext   
//     Register 3      16 pContext   
//     Register 4      16 pContext   
//     Register 5       8 threadId   
//     Register 6       8 threadId   
//
// conversion
//   Pack            ns
//   Scatter         pContext
//   Scatter         threadId

    .section .text._ZN2nn4kern3svc13Aarch64From3228CallGetDebugFutureThreadInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3228CallGetDebugFutureThreadInfoEv
    .type    _ZN2nn4kern3svc13Aarch64From3228CallGetDebugFutureThreadInfoEv, %function
    .type    _ZN2nn4kern3svc35SvcGetDebugFutureThreadInfo64From32EPNS_3svc5ilp3217LastThreadContextEPmNS2_6HandleEl, %function
_ZN2nn4kern3svc13Aarch64From3228CallGetDebugFutureThreadInfoEv:

    stp      x7, x30, [sp, #-16]!
    sub      sp, sp, #32

    orr      x3, x0, x1, lsl #32       // ns を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pContext の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pContext の第 2 ワードをレジスタからスタックへ
    str      w3, [sp, #8]              // pContext の第 3 ワードをレジスタからスタックへ
    str      w4, [sp, #12]             // pContext の第 4 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pContext のアドレスをレジスタへ
    str      w5, [sp, #16]             // threadId の第 1 ワードをレジスタからスタックへ
    str      w6, [sp, #20]             // threadId の第 2 ワードをレジスタからスタックへ
    add      x1, sp, #16               // threadId のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc35SvcGetDebugFutureThreadInfo64From32EPNS_3svc5ilp3217LastThreadContextEPmNS2_6HandleEl

    ldr      w1, [sp, #0]              // pContext の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pContext の第 2 ワードをスタックからレジスタへ
    ldr      w3, [sp, #8]              // pContext の第 3 ワードをスタックからレジスタへ
    ldr      w4, [sp, #12]             // pContext の第 4 ワードをスタックからレジスタへ
    ldr      w5, [sp, #16]             // threadId の第 1 ワードをスタックからレジスタへ
    ldr      w6, [sp, #20]             // threadId の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #32
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3228CallGetDebugFutureThreadInfoEv, [.-_ZN2nn4kern3svc13Aarch64From3228CallGetDebugFutureThreadInfoEv]

//-------------------------------------------------
// Result GetLastThreadInfo(nn::svc::ilp32::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//                                   Register 0  ref 16 pContext
//                                   Register 1  ref  8 pTlsAddr
//                                   Register 2  ref  4 pFlag
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1      16 pContext   
//     Register 2      16 pContext   
//     Register 3      16 pContext   
//     Register 4      16 pContext   
//     Register 5       4 pTlsAddr   
//     Register 6       4 pFlag      
//
// conversion
//   Scatter         pContext
//   Scatter         pTlsAddr
//   Scatter         pFlag

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallGetLastThreadInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallGetLastThreadInfoEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallGetLastThreadInfoEv, %function
    .type    _ZN2nn4kern3svc28SvcGetLastThreadInfo64From32EPNS_3svc5ilp3217LastThreadContextEPmPj, %function
_ZN2nn4kern3svc13Aarch64From3221CallGetLastThreadInfoEv:

    stp      x7, x30, [sp, #-16]!
    sub      sp, sp, #32

    str      w1, [sp, #0]              // pContext の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pContext の第 2 ワードをレジスタからスタックへ
    str      w3, [sp, #8]              // pContext の第 3 ワードをレジスタからスタックへ
    str      w4, [sp, #12]             // pContext の第 4 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pContext のアドレスをレジスタへ
    str      w5, [sp, #16]             // pTlsAddr の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #16               // pTlsAddr のアドレスをレジスタへ
    str      w6, [sp, #24]             // pFlag の第 1 ワードをレジスタからスタックへ
    add      x2, sp, #24               // pFlag のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc28SvcGetLastThreadInfo64From32EPNS_3svc5ilp3217LastThreadContextEPmPj

    ldr      w1, [sp, #0]              // pContext の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pContext の第 2 ワードをスタックからレジスタへ
    ldr      w3, [sp, #8]              // pContext の第 3 ワードをスタックからレジスタへ
    ldr      w4, [sp, #12]             // pContext の第 4 ワードをスタックからレジスタへ
    ldr      w5, [sp, #16]             // pTlsAddr の第 1 ワードをスタックからレジスタへ
    ldr      w6, [sp, #24]             // pFlag の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #32
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallGetLastThreadInfoEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallGetLastThreadInfoEv]

//-------------------------------------------------
// Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     Invariant s=4 r=8 p=4              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  8 value
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       8 value           
//     Register 2       8 value           
//
// conversion
//   Scatter         value

    .section .text._ZN2nn4kern3svc13Aarch64From3230CallGetResourceLimitLimitValueEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3230CallGetResourceLimitLimitValueEv
    .type    _ZN2nn4kern3svc13Aarch64From3230CallGetResourceLimitLimitValueEv, %function
    .type    _ZN2nn4kern3svc37SvcGetResourceLimitLimitValue64From32EPlNS_3svc6HandleENS3_17LimitableResourceE, %function
_ZN2nn4kern3svc13Aarch64From3230CallGetResourceLimitLimitValueEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // value の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // value の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // value のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc37SvcGetResourceLimitLimitValue64From32EPlNS_3svc6HandleENS3_17LimitableResourceE

    ldr      w1, [sp, #0]              // value の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // value の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3230CallGetResourceLimitLimitValueEv, [.-_ZN2nn4kern3svc13Aarch64From3230CallGetResourceLimitLimitValueEv]

//-------------------------------------------------
// Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     Invariant s=4 r=8 p=4              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  8 value
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       8 value           
//     Register 2       8 value           
//
// conversion
//   Scatter         value

    .section .text._ZN2nn4kern3svc13Aarch64From3232CallGetResourceLimitCurrentValueEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3232CallGetResourceLimitCurrentValueEv
    .type    _ZN2nn4kern3svc13Aarch64From3232CallGetResourceLimitCurrentValueEv, %function
    .type    _ZN2nn4kern3svc39SvcGetResourceLimitCurrentValue64From32EPlNS_3svc6HandleENS3_17LimitableResourceE, %function
_ZN2nn4kern3svc13Aarch64From3232CallGetResourceLimitCurrentValueEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // value の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // value の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // value のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc39SvcGetResourceLimitCurrentValue64From32EPlNS_3svc6HandleENS3_17LimitableResourceE

    ldr      w1, [sp, #0]              // value の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // value の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3232CallGetResourceLimitCurrentValueEv, [.-_ZN2nn4kern3svc13Aarch64From3232CallGetResourceLimitCurrentValueEv]

//-------------------------------------------------
// Result SetThreadActivity(nn::svc::Handle handle, nn::svc::ThreadActivity activity)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallSetThreadActivityEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallSetThreadActivityEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallSetThreadActivityEv, %function
    .type    _ZN2nn4kern3svc28SvcSetThreadActivity64From32ENS_3svc6HandleENS2_14ThreadActivityE, %function
_ZN2nn4kern3svc13Aarch64From3221CallSetThreadActivityEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcSetThreadActivity64From32ENS_3svc6HandleENS2_14ThreadActivityE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallSetThreadActivityEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallSetThreadActivityEv]

//-------------------------------------------------
// Result GetThreadContext3(KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle handle)
//
//     Invariant s=4 r=8 p=4          AArch64 s=8 r=8 p=8
// in  svc                            abi
//     Register 0  ref 332 pContext   Register 0  ref 332 pContext
//     Register 1       4 handle      Register 1       4 handle
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallGetThreadContext3Ev, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallGetThreadContext3Ev
    .type    _ZN2nn4kern3svc13Aarch64From3221CallGetThreadContext3Ev, %function
    .type    _ZN2nn4kern3svc28SvcGetThreadContext364From32ENS1_12KUserPointerIPNS_3svc13ThreadContextEvEENS3_6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3221CallGetThreadContext3Ev:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcGetThreadContext364From32ENS1_12KUserPointerIPNS_3svc13ThreadContextEvEENS3_6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallGetThreadContext3Ev, [.-_ZN2nn4kern3svc13Aarch64From3221CallGetThreadContext3Ev]

//-------------------------------------------------
// Result WaitForAddress(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       8 ns       Register 3       8 ns
//     Register 4       8 ns       
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion
//   Pack            ns

    .section .text._ZN2nn4kern3svc13Aarch64From3218CallWaitForAddressEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3218CallWaitForAddressEv
    .type    _ZN2nn4kern3svc13Aarch64From3218CallWaitForAddressEv, %function
    .type    _ZN2nn4kern3svc25SvcWaitForAddress64From32EmNS_3svc15ArbitrationTypeEil, %function
_ZN2nn4kern3svc13Aarch64From3218CallWaitForAddressEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x3, x3, x4, lsl #32       // ns を 32 bit x2 から 64 bit へ

    bl       _ZN2nn4kern3svc25SvcWaitForAddress64From32EmNS_3svc15ArbitrationTypeEil
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3218CallWaitForAddressEv, [.-_ZN2nn4kern3svc13Aarch64From3218CallWaitForAddressEv]

//-------------------------------------------------
// Result SignalToAddress(uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       4 num      Register 3       4 num
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3219CallSignalToAddressEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3219CallSignalToAddressEv
    .type    _ZN2nn4kern3svc13Aarch64From3219CallSignalToAddressEv, %function
    .type    _ZN2nn4kern3svc26SvcSignalToAddress64From32EmNS_3svc10SignalTypeEii, %function
_ZN2nn4kern3svc13Aarch64From3219CallSignalToAddressEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc26SvcSignalToAddress64From32EmNS_3svc10SignalTypeEii
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3219CallSignalToAddressEv, [.-_ZN2nn4kern3svc13Aarch64From3219CallSignalToAddressEv]

//-------------------------------------------------
// void KernelDebug(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 type     Register 0       4 type
//     Register 1       8 param1   Register 1       8 param0
//     Register 2       8 param0   Register 2       8 param1
//     Register 3       8 param0   Register 3       8 param2
//     Register 4       8 param1   
//     Register 5       8 param2   
//     Register 6       8 param2   
//
// in  svc                         abi
//
// conversion
//   Pack            param1
//   Pack            param0
//   Pack            param2

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallKernelDebugEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallKernelDebugEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallKernelDebugEv, %function
    .type    _ZN2nn4kern3svc22SvcKernelDebug64From32ENS_3svc15KernelDebugTypeEmmm, %function
_ZN2nn4kern3svc13Aarch64From3215CallKernelDebugEv:

    stp      x7, x30, [sp, #-16]!
    orr      x7, x1, x4, lsl #32       // param1 を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // param0 を 32 bit x2 から 64 bit へ
    orr      x3, x5, x6, lsl #32       // param2 を 32 bit x2 から 64 bit へ
    mov      x2, x7                    // param1

    bl       _ZN2nn4kern3svc22SvcKernelDebug64From32ENS_3svc15KernelDebugTypeEmmm
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallKernelDebugEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallKernelDebugEv]

//-------------------------------------------------
// void ChangeKernelTraceState(nn::svc::KernelTraceState state)
//
//     Invariant s=4 r=8 p=4      AArch64 s=8 r=8 p=8
// in  svc                        abi
//     Register 0       4 state   Register 0       4 state
//
// in  svc                        abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3226CallChangeKernelTraceStateEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3226CallChangeKernelTraceStateEv
    .type    _ZN2nn4kern3svc13Aarch64From3226CallChangeKernelTraceStateEv, %function
    .type    _ZN2nn4kern3svc33SvcChangeKernelTraceState64From32ENS_3svc16KernelTraceStateE, %function
_ZN2nn4kern3svc13Aarch64From3226CallChangeKernelTraceStateEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc33SvcChangeKernelTraceState64From32ENS_3svc16KernelTraceStateE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3226CallChangeKernelTraceStateEv, [.-_ZN2nn4kern3svc13Aarch64From3226CallChangeKernelTraceStateEv]

//-------------------------------------------------
// Result CreateSession(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name)
//
//     Invariant s=4 r=8 p=4               AArch64 s=8 r=8 p=8
// in  svc                                 abi
//                                         Register 0  ref  4 pServerSession
//                                         Register 1  ref  4 pClientSession
//     Register 2       1 isLight          Register 2       1 isLight
//     Register 3       4 name             Register 3       8 name
//
// in  svc                                 abi
//     Register 0       4 return           Register 0       4 return
//     Register 1       4 pServerSession   
//     Register 2       4 pClientSession   
//
// conversion
//   Scatter         pServerSession
//   Scatter         pClientSession

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallCreateSessionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallCreateSessionEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallCreateSessionEv, %function
    .type    _ZN2nn4kern3svc24SvcCreateSession64From32EPNS_3svc6HandleES4_bm, %function
_ZN2nn4kern3svc13Aarch64From3217CallCreateSessionEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pServerSession の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pServerSession のアドレスをレジスタへ
    str      w2, [sp, #8]              // pClientSession の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pClientSession のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcCreateSession64From32EPNS_3svc6HandleES4_bm

    ldr      w1, [sp, #0]              // pServerSession の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #8]              // pClientSession の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallCreateSessionEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallCreateSessionEv]

//-------------------------------------------------
// Result AcceptSession(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 port     Register 1       4 port
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallAcceptSessionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallAcceptSessionEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallAcceptSessionEv, %function
    .type    _ZN2nn4kern3svc24SvcAcceptSession64From32EPNS_3svc6HandleES3_, %function
_ZN2nn4kern3svc13Aarch64From3217CallAcceptSessionEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcAcceptSession64From32EPNS_3svc6HandleES3_

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallAcceptSessionEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallAcceptSessionEv]

//-------------------------------------------------
// Result ReplyAndReceiveLight(nn::svc::Handle session)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 session   Register 0       4 session
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallReplyAndReceiveLightEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallReplyAndReceiveLightEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallReplyAndReceiveLightEv, %function
    .type    _ZN2nn4kern3svc31SvcReplyAndReceiveLight64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3224CallReplyAndReceiveLightEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc31SvcReplyAndReceiveLight64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallReplyAndReceiveLightEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallReplyAndReceiveLightEv]

//-------------------------------------------------
// Result ReplyAndReceive(int32_t* pIndex, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     Invariant s=4 r=8 p=4            AArch64 s=8 r=8 p=8
// in  svc                              abi
//     Register 0       8 ns            Register 0  ref  4 pIndex
//     Register 1  ref -- pHandles      Register 1  ref -- pHandles
//     Register 2       4 numHandle     Register 2       4 numHandle
//     Register 3       4 replyTarget   Register 3       4 replyTarget
//     Register 4       8 ns            Register 4       8 ns
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pIndex        
//
// conversion
//   Pack            ns
//   Scatter         pIndex

    .section .text._ZN2nn4kern3svc13Aarch64From3219CallReplyAndReceiveEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3219CallReplyAndReceiveEv
    .type    _ZN2nn4kern3svc13Aarch64From3219CallReplyAndReceiveEv, %function
    .type    _ZN2nn4kern3svc26SvcReplyAndReceive64From32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l, %function
_ZN2nn4kern3svc13Aarch64From3219CallReplyAndReceiveEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    sub      sp, sp, #16

    orr      x4, x0, x4, lsl #32       // ns を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pIndex の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pIndex のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc26SvcReplyAndReceive64From32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l

    ldr      w1, [sp, #0]              // pIndex の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3219CallReplyAndReceiveEv, [.-_ZN2nn4kern3svc13Aarch64From3219CallReplyAndReceiveEv]

//-------------------------------------------------
// Result ReplyAndReceiveWithUserBuffer(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     Invariant s=4 r=8 p=4            AArch64 s=8 r=8 p=8
// in  svc                              abi
//     Register 0       4 numHandle     Register 0  ref  4 pIndex
//     Register 1       4 pMessage      Register 1       8 pMessage
//     Register 2       4 bufferSize    Register 2       8 bufferSize
//     Register 3  ref -- pHandles      Register 3  ref -- pHandles
//     Register 4       4 replyTarget   Register 4       4 numHandle
//     Register 5       8 ns            Register 5       4 replyTarget
//     Register 6       8 ns            Register 6       8 ns
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pIndex        
//
// conversion
//   Move            numHandle
//   Move            replyTarget
//   Pack            ns
//   Scatter         pIndex

    .section .text._ZN2nn4kern3svc13Aarch64From3233CallReplyAndReceiveWithUserBufferEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3233CallReplyAndReceiveWithUserBufferEv
    .type    _ZN2nn4kern3svc13Aarch64From3233CallReplyAndReceiveWithUserBufferEv, %function
    .type    _ZN2nn4kern3svc40SvcReplyAndReceiveWithUserBuffer64From32EPimmNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l, %function
_ZN2nn4kern3svc13Aarch64From3233CallReplyAndReceiveWithUserBufferEv:

    stp      x7, x30, [sp, #-16]!
    sub      sp, sp, #16

    orr      x6, x5, x6, lsl #32       // ns を 32 bit x2 から 64 bit へ
    mov      x5, x4                    // replyTarget
    mov      x4, x0                    // numHandle

    str      w1, [sp, #0]              // pIndex の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pIndex のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc40SvcReplyAndReceiveWithUserBuffer64From32EPimmNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l

    ldr      w1, [sp, #0]              // pIndex の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3233CallReplyAndReceiveWithUserBufferEv, [.-_ZN2nn4kern3svc13Aarch64From3233CallReplyAndReceiveWithUserBufferEv]

//-------------------------------------------------
// Result CreateEvent(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle)
//
//     Invariant s=4 r=8 p=4             AArch64 s=8 r=8 p=8
// in  svc                               abi
//                                       Register 0  ref  4 pWriteHandle
//                                       Register 1  ref  4 pReadHandle
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pWriteHandle   
//     Register 2       4 pReadHandle    
//
// conversion
//   Scatter         pWriteHandle
//   Scatter         pReadHandle

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallCreateEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallCreateEventEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallCreateEventEv, %function
    .type    _ZN2nn4kern3svc22SvcCreateEvent64From32EPNS_3svc6HandleES4_, %function
_ZN2nn4kern3svc13Aarch64From3215CallCreateEventEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pWriteHandle の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pWriteHandle のアドレスをレジスタへ
    str      w2, [sp, #8]              // pReadHandle の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pReadHandle のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcCreateEvent64From32EPNS_3svc6HandleES4_

    ldr      w1, [sp, #0]              // pWriteHandle の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #8]              // pReadHandle の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallCreateEventEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallCreateEventEv]

//-------------------------------------------------
// Result MapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3227CallMapPhysicalMemoryUnsafeEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3227CallMapPhysicalMemoryUnsafeEv
    .type    _ZN2nn4kern3svc13Aarch64From3227CallMapPhysicalMemoryUnsafeEv, %function
    .type    _ZN2nn4kern3svc34SvcMapPhysicalMemoryUnsafe64From32Emm, %function
_ZN2nn4kern3svc13Aarch64From3227CallMapPhysicalMemoryUnsafeEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc34SvcMapPhysicalMemoryUnsafe64From32Emm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3227CallMapPhysicalMemoryUnsafeEv, [.-_ZN2nn4kern3svc13Aarch64From3227CallMapPhysicalMemoryUnsafeEv]

//-------------------------------------------------
// Result UnmapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3229CallUnmapPhysicalMemoryUnsafeEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3229CallUnmapPhysicalMemoryUnsafeEv
    .type    _ZN2nn4kern3svc13Aarch64From3229CallUnmapPhysicalMemoryUnsafeEv, %function
    .type    _ZN2nn4kern3svc36SvcUnmapPhysicalMemoryUnsafe64From32Emm, %function
_ZN2nn4kern3svc13Aarch64From3229CallUnmapPhysicalMemoryUnsafeEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc36SvcUnmapPhysicalMemoryUnsafe64From32Emm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3229CallUnmapPhysicalMemoryUnsafeEv, [.-_ZN2nn4kern3svc13Aarch64From3229CallUnmapPhysicalMemoryUnsafeEv]

//-------------------------------------------------
// Result SetUnsafeLimit(size_t limitSize)
//
//     Invariant s=4 r=8 p=4          AArch64 s=8 r=8 p=8
// in  svc                            abi
//     Register 0       4 limitSize   Register 0       8 limitSize
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3218CallSetUnsafeLimitEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3218CallSetUnsafeLimitEv
    .type    _ZN2nn4kern3svc13Aarch64From3218CallSetUnsafeLimitEv, %function
    .type    _ZN2nn4kern3svc25SvcSetUnsafeLimit64From32Em, %function
_ZN2nn4kern3svc13Aarch64From3218CallSetUnsafeLimitEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc25SvcSetUnsafeLimit64From32Em
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3218CallSetUnsafeLimitEv, [.-_ZN2nn4kern3svc13Aarch64From3218CallSetUnsafeLimitEv]

//-------------------------------------------------
// Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 addr     Register 1       8 addr
//     Register 2       4 size     Register 2       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3220CallCreateCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3220CallCreateCodeMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3220CallCreateCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc27SvcCreateCodeMemory64From32EPNS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3220CallCreateCodeMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc27SvcCreateCodeMemory64From32EPNS_3svc6HandleEmm

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3220CallCreateCodeMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3220CallCreateCodeMemoryEv]

//-------------------------------------------------
// Result ControlCodeMemory(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       4 handle       Register 0       4 handle
//     Register 1       4 operation    Register 1       4 operation
//     Register 2       8 address      Register 2       8 address
//     Register 3       8 address      Register 3       8 size
//     Register 4       8 size         Register 4       4 permission
//     Register 5       8 size         
//     Register 6       4 permission   
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion
//   Pack            address
//   Pack            size
//   Move            permission

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallControlCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallControlCodeMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallControlCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc28SvcControlCodeMemory64From32ENS_3svc6HandleENS2_19CodeMemoryOperationEmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3221CallControlCodeMemoryEv:

    stp      x7, x30, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // address を 32 bit x2 から 64 bit へ
    orr      x3, x4, x5, lsl #32       // size を 32 bit x2 から 64 bit へ
    mov      x4, x6                    // permission

    bl       _ZN2nn4kern3svc28SvcControlCodeMemory64From32ENS_3svc6HandleENS2_19CodeMemoryOperationEmmNS2_16MemoryPermissionE
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallControlCodeMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallControlCodeMemoryEv]

//-------------------------------------------------
// void SleepSystem()
//
//     Invariant s=4 r=8 p=4   AArch64 s=8 r=8 p=8
// in  svc   abi
//
// in  svc   abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3215CallSleepSystemEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3215CallSleepSystemEv
    .type    _ZN2nn4kern3svc13Aarch64From3215CallSleepSystemEv, %function
    .type    _ZN2nn4kern3svc22SvcSleepSystem64From32Ev, %function
_ZN2nn4kern3svc13Aarch64From3215CallSleepSystemEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc22SvcSleepSystem64From32Ev
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3215CallSleepSystemEv, [.-_ZN2nn4kern3svc13Aarch64From3215CallSleepSystemEv]

//-------------------------------------------------
// Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 mask      Register 0  ref  4 pOut
//     Register 1       4 value     Register 1       8 address
//     Register 2       8 address   Register 2       4 mask
//     Register 3       8 address   Register 3       4 value
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//     Register 1       4 pOut      
//
// conversion
//   Move            mask
//   Move            value
//   Pack            address
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallReadWriteRegisterEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallReadWriteRegisterEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallReadWriteRegisterEv, %function
    .type    _ZN2nn4kern3svc28SvcReadWriteRegister64From32EPjmjj, %function
_ZN2nn4kern3svc13Aarch64From3221CallReadWriteRegisterEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    mov      x4, x0                    // mask
    mov      x0, x1                    // value
    orr      x1, x2, x3, lsl #32       // address を 32 bit x2 から 64 bit へ
    mov      x2, x4                    // mask
    mov      x3, x0                    // value

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc28SvcReadWriteRegister64From32EPjmjj

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallReadWriteRegisterEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallReadWriteRegisterEv]

//-------------------------------------------------
// Result SetProcessActivity(nn::svc::Handle handle, nn::svc::ProcessActivity activity)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallSetProcessActivityEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallSetProcessActivityEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallSetProcessActivityEv, %function
    .type    _ZN2nn4kern3svc29SvcSetProcessActivity64From32ENS_3svc6HandleENS2_15ProcessActivityE, %function
_ZN2nn4kern3svc13Aarch64From3222CallSetProcessActivityEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc29SvcSetProcessActivity64From32ENS_3svc6HandleENS2_15ProcessActivityE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallSetProcessActivityEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallSetProcessActivityEv]

//-------------------------------------------------
// Result CreateSharedMemory(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission)
//
//     Invariant s=4 r=8 p=4                AArch64 s=8 r=8 p=8
// in  svc                                  abi
//                                          Register 0  ref  4 pOut
//     Register 1       4 size              Register 1       8 size
//     Register 2       4 myPermission      Register 2       4 myPermission
//     Register 3       4 otherPermission   Register 3       4 otherPermission
//
// in  svc                                  abi
//     Register 0       4 return            Register 0       4 return
//     Register 1       4 pOut              
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallCreateSharedMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallCreateSharedMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallCreateSharedMemoryEv, %function
    .type    _ZN2nn4kern3svc29SvcCreateSharedMemory64From32EPNS_3svc6HandleEmNS2_16MemoryPermissionES5_, %function
_ZN2nn4kern3svc13Aarch64From3222CallCreateSharedMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcCreateSharedMemory64From32EPNS_3svc6HandleEmNS2_16MemoryPermissionES5_

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallCreateSharedMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallCreateSharedMemoryEv]

//-------------------------------------------------
// Result MapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission)
//
//     Invariant s=4 r=8 p=4                AArch64 s=8 r=8 p=8
// in  svc                                  abi
//     Register 0       4 handle            Register 0       4 handle
//     Register 1       4 addr              Register 1       8 addr
//     Register 2       4 size              Register 2       8 size
//     Register 3       4 ownerPermission   Register 3       4 ownerPermission
//
// in  svc                                  abi
//     Register 0       4 return            Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallMapTransferMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallMapTransferMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallMapTransferMemoryEv, %function
    .type    _ZN2nn4kern3svc28SvcMapTransferMemory64From32ENS_3svc6HandleEmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3221CallMapTransferMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcMapTransferMemory64From32ENS_3svc6HandleEmmNS2_16MemoryPermissionE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallMapTransferMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallMapTransferMemoryEv]

//-------------------------------------------------
// Result UnmapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 handle   Register 0       4 handle
//     Register 1       4 addr     Register 1       8 addr
//     Register 2       4 size     Register 2       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3223CallUnmapTransferMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3223CallUnmapTransferMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3223CallUnmapTransferMemoryEv, %function
    .type    _ZN2nn4kern3svc30SvcUnmapTransferMemory64From32ENS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3223CallUnmapTransferMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc30SvcUnmapTransferMemory64From32ENS_3svc6HandleEmm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3223CallUnmapTransferMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3223CallUnmapTransferMemoryEv]

//-------------------------------------------------
// Result CreateInterruptEvent(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type)
//
//     Invariant s=4 r=8 p=4            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pReadHandle
//     Register 1       4 name          Register 1       4 name
//     Register 2       4 type          Register 2       4 type
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pReadHandle   
//
// conversion
//   Scatter         pReadHandle

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallCreateInterruptEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallCreateInterruptEventEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallCreateInterruptEventEv, %function
    .type    _ZN2nn4kern3svc31SvcCreateInterruptEvent64From32EPNS_3svc6HandleEiNS2_13InterruptTypeE, %function
_ZN2nn4kern3svc13Aarch64From3224CallCreateInterruptEventEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pReadHandle の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pReadHandle のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc31SvcCreateInterruptEvent64From32EPNS_3svc6HandleEiNS2_13InterruptTypeE

    ldr      w1, [sp, #0]              // pReadHandle の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallCreateInterruptEventEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallCreateInterruptEventEv]

//-------------------------------------------------
// Result QueryPhysicalAddress(nn::svc::ilp32::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//                                     Register 0  ref 16 pBlockInfo
//     Register 1       4 addr         Register 1       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1      16 pBlockInfo   
//     Register 2      16 pBlockInfo   
//     Register 3      16 pBlockInfo   
//     Register 4      16 pBlockInfo   
//
// conversion
//   Scatter         pBlockInfo

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallQueryPhysicalAddressEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallQueryPhysicalAddressEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallQueryPhysicalAddressEv, %function
    .type    _ZN2nn4kern3svc31SvcQueryPhysicalAddress64From32EPNS_3svc5ilp3218PhysicalMemoryInfoEm, %function
_ZN2nn4kern3svc13Aarch64From3224CallQueryPhysicalAddressEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pBlockInfo の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pBlockInfo の第 2 ワードをレジスタからスタックへ
    str      w3, [sp, #8]              // pBlockInfo の第 3 ワードをレジスタからスタックへ
    str      w4, [sp, #12]             // pBlockInfo の第 4 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pBlockInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc31SvcQueryPhysicalAddress64From32EPNS_3svc5ilp3218PhysicalMemoryInfoEm

    ldr      w1, [sp, #0]              // pBlockInfo の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pBlockInfo の第 2 ワードをスタックからレジスタへ
    ldr      w3, [sp, #8]              // pBlockInfo の第 3 ワードをスタックからレジスタへ
    ldr      w4, [sp, #12]             // pBlockInfo の第 4 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallQueryPhysicalAddressEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallQueryPhysicalAddressEv]

//-------------------------------------------------
// Result QueryIoMapping(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size)
//
//     Invariant s=4 r=8 p=4                AArch64 s=8 r=8 p=8
// in  svc                                  abi
//     Register 0       4 size              Register 0  ref  8 pOut
//                                          Register 1       8 physicalAddress
//     Register 2       8 physicalAddress   Register 2       8 size
//     Register 3       8 physicalAddress   
//
// in  svc                                  abi
//     Register 0       4 return            Register 0       4 return
//     Register 1       4 pOut              
//
// conversion
//   Move            size
//   Pack            physicalAddress
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3218CallQueryIoMappingEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3218CallQueryIoMappingEv
    .type    _ZN2nn4kern3svc13Aarch64From3218CallQueryIoMappingEv, %function
    .type    _ZN2nn4kern3svc25SvcQueryIoMapping64From32EPmmm, %function
_ZN2nn4kern3svc13Aarch64From3218CallQueryIoMappingEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    orr      x1, x2, x3, lsl #32       // physicalAddress を 32 bit x2 から 64 bit へ
    mov      x2, x0                    // size

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcQueryIoMapping64From32EPmmm

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3218CallQueryIoMappingEv, [.-_ZN2nn4kern3svc13Aarch64From3218CallQueryIoMappingEv]

//-------------------------------------------------
// Result CreateDeviceAddressSpace(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize)
//
//     Invariant s=4 r=8 p=4             AArch64 s=8 r=8 p=8
// in  svc                               abi
//     Register 0       8 spaceSize      Register 0  ref  4 pOut
//     Register 1       8 spaceSize      Register 1       8 spaceAddress
//     Register 2       8 spaceAddress   Register 2       8 spaceSize
//     Register 3       8 spaceAddress   
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pOut           
//
// conversion
//   Pack            spaceSize
//   Pack            spaceAddress
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3228CallCreateDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3228CallCreateDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc13Aarch64From3228CallCreateDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc35SvcCreateDeviceAddressSpace64From32EPNS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3228CallCreateDeviceAddressSpaceEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    orr      x4, x0, x1, lsl #32       // spaceSize を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // spaceAddress を 32 bit x2 から 64 bit へ
    mov      x2, x4                    // spaceSize

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc35SvcCreateDeviceAddressSpace64From32EPNS_3svc6HandleEmm

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3228CallCreateDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc13Aarch64From3228CallCreateDeviceAddressSpaceEv]

//-------------------------------------------------
// Result AttachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       4 deviceName   Register 0       4 deviceName
//     Register 1       4 handle       Register 1       4 handle
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3228CallAttachDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3228CallAttachDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc13Aarch64From3228CallAttachDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc35SvcAttachDeviceAddressSpace64From32ENS_3svc10DeviceNameENS2_6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3228CallAttachDeviceAddressSpaceEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc35SvcAttachDeviceAddressSpace64From32ENS_3svc10DeviceNameENS2_6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3228CallAttachDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc13Aarch64From3228CallAttachDeviceAddressSpaceEv]

//-------------------------------------------------
// Result DetachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       4 deviceName   Register 0       4 deviceName
//     Register 1       4 handle       Register 1       4 handle
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3228CallDetachDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3228CallDetachDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc13Aarch64From3228CallDetachDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc35SvcDetachDeviceAddressSpace64From32ENS_3svc10DeviceNameENS2_6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3228CallDetachDeviceAddressSpaceEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc35SvcDetachDeviceAddressSpace64From32ENS_3svc10DeviceNameENS2_6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3228CallDetachDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc13Aarch64From3228CallDetachDeviceAddressSpaceEv]

//-------------------------------------------------
// Result MapDeviceAddressSpaceByForce(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     Invariant s=4 r=8 p=4                 AArch64 s=8 r=8 p=8
// in  svc                                   abi
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 processAddress     Register 3       8 size
//     Register 4       4 size               Register 4       8 deviceAddress
//     Register 5       8 deviceAddress      Register 5       4 devicePermission
//     Register 6       8 deviceAddress      
//     Register 7       4 devicePermission   
//
// in  svc                                   abi
//     Register 0       4 return             Register 0       4 return
//
// conversion
//   Pack            processAddress
//   Move            size
//   Pack            deviceAddress
//   Move            devicePermission

    .section .text._ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceByForceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceByForceEv
    .type    _ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceByForceEv, %function
    .type    _ZN2nn4kern3svc39SvcMapDeviceAddressSpaceByForce64From32ENS_3svc6HandleES3_mmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceByForceEv:

    stp      x29, x30, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // processAddress を 32 bit x2 から 64 bit へ
    mov      x3, x4                    // size
    orr      x4, x5, x6, lsl #32       // deviceAddress を 32 bit x2 から 64 bit へ
    mov      x5, x7                    // devicePermission

    bl       _ZN2nn4kern3svc39SvcMapDeviceAddressSpaceByForce64From32ENS_3svc6HandleES3_mmmNS2_16MemoryPermissionE
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceByForceEv, [.-_ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceByForceEv]

//-------------------------------------------------
// Result MapDeviceAddressSpaceAligned(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     Invariant s=4 r=8 p=4                 AArch64 s=8 r=8 p=8
// in  svc                                   abi
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 processAddress     Register 3       8 size
//     Register 4       4 size               Register 4       8 deviceAddress
//     Register 5       8 deviceAddress      Register 5       4 devicePermission
//     Register 6       8 deviceAddress      
//     Register 7       4 devicePermission   
//
// in  svc                                   abi
//     Register 0       4 return             Register 0       4 return
//
// conversion
//   Pack            processAddress
//   Move            size
//   Pack            deviceAddress
//   Move            devicePermission

    .section .text._ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceAlignedEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceAlignedEv
    .type    _ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceAlignedEv, %function
    .type    _ZN2nn4kern3svc39SvcMapDeviceAddressSpaceAligned64From32ENS_3svc6HandleES3_mmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceAlignedEv:

    stp      x29, x30, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // processAddress を 32 bit x2 から 64 bit へ
    mov      x3, x4                    // size
    orr      x4, x5, x6, lsl #32       // deviceAddress を 32 bit x2 から 64 bit へ
    mov      x5, x7                    // devicePermission

    bl       _ZN2nn4kern3svc39SvcMapDeviceAddressSpaceAligned64From32ENS_3svc6HandleES3_mmmNS2_16MemoryPermissionE
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceAlignedEv, [.-_ZN2nn4kern3svc13Aarch64From3232CallMapDeviceAddressSpaceAlignedEv]

//-------------------------------------------------
// Result MapDeviceAddressSpace(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     Invariant s=4 r=8 p=4                 AArch64 s=8 r=8 p=8
// in  svc                                   abi
//     Register 0       8 processAddress     Register 0  ref  8 pMappedSize
//     Register 1       4 addressSpace       Register 1       4 addressSpace
//     Register 2       4 process            Register 2       4 process
//     Register 3       8 processAddress     Register 3       8 processAddress
//     Register 4       4 size               Register 4       8 size
//     Register 5       8 deviceAddress      Register 5       8 deviceAddress
//     Register 6       8 deviceAddress      Register 6       4 devicePermission
//     Register 7       4 devicePermission   
//
// in  svc                                   abi
//     Register 0       4 return             Register 0       4 return
//     Register 1       4 pMappedSize        
//
// conversion
//   Pack            processAddress
//   Pack            deviceAddress
//   Move            devicePermission
//   Scatter         pMappedSize

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallMapDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallMapDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallMapDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc32SvcMapDeviceAddressSpace64From32EPmNS_3svc6HandleES4_mmmNS3_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3225CallMapDeviceAddressSpaceEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    orr      x3, x0, x3, lsl #32       // processAddress を 32 bit x2 から 64 bit へ
    orr      x5, x5, x6, lsl #32       // deviceAddress を 32 bit x2 から 64 bit へ
    mov      x6, x7                    // devicePermission

    str      w1, [sp, #0]              // pMappedSize の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pMappedSize のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc32SvcMapDeviceAddressSpace64From32EPmNS_3svc6HandleES4_mmmNS3_16MemoryPermissionE

    ldr      w1, [sp, #0]              // pMappedSize の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallMapDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallMapDeviceAddressSpaceEv]

//-------------------------------------------------
// Result UnmapDeviceAddressSpace(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress)
//
//     Invariant s=4 r=8 p=4               AArch64 s=8 r=8 p=8
// in  svc                                 abi
//     Register 0       4 addressSpace     Register 0       4 addressSpace
//     Register 1       4 process          Register 1       4 process
//     Register 2       8 processAddress   Register 2       8 processAddress
//     Register 3       8 processAddress   Register 3       8 size
//     Register 4       4 size             Register 4       8 deviceAddress
//     Register 5       8 deviceAddress    
//     Register 6       8 deviceAddress    
//
// in  svc                                 abi
//     Register 0       4 return           Register 0       4 return
//
// conversion
//   Pack            processAddress
//   Move            size
//   Pack            deviceAddress

    .section .text._ZN2nn4kern3svc13Aarch64From3227CallUnmapDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3227CallUnmapDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc13Aarch64From3227CallUnmapDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc34SvcUnmapDeviceAddressSpace64From32ENS_3svc6HandleES3_mmm, %function
_ZN2nn4kern3svc13Aarch64From3227CallUnmapDeviceAddressSpaceEv:

    stp      x7, x30, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // processAddress を 32 bit x2 から 64 bit へ
    mov      x3, x4                    // size
    orr      x4, x5, x6, lsl #32       // deviceAddress を 32 bit x2 から 64 bit へ

    bl       _ZN2nn4kern3svc34SvcUnmapDeviceAddressSpace64From32ENS_3svc6HandleES3_mmm
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3227CallUnmapDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc13Aarch64From3227CallUnmapDeviceAddressSpaceEv]

//-------------------------------------------------
// Result InvalidateProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 size      Register 1       8 addr
//     Register 2       8 addr      Register 2       8 size
//     Register 3       8 addr      
//     Register 4       8 size      
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Pack            size
//   Pack            addr

    .section .text._ZN2nn4kern3svc13Aarch64From3230CallInvalidateProcessDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3230CallInvalidateProcessDataCacheEv
    .type    _ZN2nn4kern3svc13Aarch64From3230CallInvalidateProcessDataCacheEv, %function
    .type    _ZN2nn4kern3svc37SvcInvalidateProcessDataCache64From32ENS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3230CallInvalidateProcessDataCacheEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x5, x1, x4, lsl #32       // size を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // addr を 32 bit x2 から 64 bit へ
    mov      x2, x5                    // size

    bl       _ZN2nn4kern3svc37SvcInvalidateProcessDataCache64From32ENS_3svc6HandleEmm
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3230CallInvalidateProcessDataCacheEv, [.-_ZN2nn4kern3svc13Aarch64From3230CallInvalidateProcessDataCacheEv]

//-------------------------------------------------
// Result StoreProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 size      Register 1       8 addr
//     Register 2       8 addr      Register 2       8 size
//     Register 3       8 addr      
//     Register 4       8 size      
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Pack            size
//   Pack            addr

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallStoreProcessDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallStoreProcessDataCacheEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallStoreProcessDataCacheEv, %function
    .type    _ZN2nn4kern3svc32SvcStoreProcessDataCache64From32ENS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3225CallStoreProcessDataCacheEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x5, x1, x4, lsl #32       // size を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // addr を 32 bit x2 から 64 bit へ
    mov      x2, x5                    // size

    bl       _ZN2nn4kern3svc32SvcStoreProcessDataCache64From32ENS_3svc6HandleEmm
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallStoreProcessDataCacheEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallStoreProcessDataCacheEv]

//-------------------------------------------------
// Result FlushProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 size      Register 1       8 addr
//     Register 2       8 addr      Register 2       8 size
//     Register 3       8 addr      
//     Register 4       8 size      
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Pack            size
//   Pack            addr

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallFlushProcessDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallFlushProcessDataCacheEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallFlushProcessDataCacheEv, %function
    .type    _ZN2nn4kern3svc32SvcFlushProcessDataCache64From32ENS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3225CallFlushProcessDataCacheEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x5, x1, x4, lsl #32       // size を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // addr を 32 bit x2 から 64 bit へ
    mov      x2, x5                    // size

    bl       _ZN2nn4kern3svc32SvcFlushProcessDataCache64From32ENS_3svc6HandleEmm
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallFlushProcessDataCacheEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallFlushProcessDataCacheEv]

//-------------------------------------------------
// Result DebugActiveProcess(nn::svc::Handle* pOut, nn::Bit64 processId)
//
//     Invariant s=4 r=8 p=4          AArch64 s=8 r=8 p=8
// in  svc                            abi
//                                    Register 0  ref  4 pOut
//                                    Register 1       8 processId
//     Register 2       8 processId   
//     Register 3       8 processId   
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//     Register 1       4 pOut        
//
// conversion
//   Pack            processId
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallDebugActiveProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallDebugActiveProcessEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallDebugActiveProcessEv, %function
    .type    _ZN2nn4kern3svc29SvcDebugActiveProcess64From32EPNS_3svc6HandleEm, %function
_ZN2nn4kern3svc13Aarch64From3222CallDebugActiveProcessEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    orr      x1, x2, x3, lsl #32       // processId を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcDebugActiveProcess64From32EPNS_3svc6HandleEm

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallDebugActiveProcessEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallDebugActiveProcessEv]

//-------------------------------------------------
// Result BreakDebugProcess(nn::svc::Handle debug)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 debug    Register 0       4 debug
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallBreakDebugProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallBreakDebugProcessEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallBreakDebugProcessEv, %function
    .type    _ZN2nn4kern3svc28SvcBreakDebugProcess64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3221CallBreakDebugProcessEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcBreakDebugProcess64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallBreakDebugProcessEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallBreakDebugProcessEv]

//-------------------------------------------------
// Result TerminateDebugProcess(nn::svc::Handle debug)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 debug    Register 0       4 debug
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallTerminateDebugProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallTerminateDebugProcessEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallTerminateDebugProcessEv, %function
    .type    _ZN2nn4kern3svc32SvcTerminateDebugProcess64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3225CallTerminateDebugProcessEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc32SvcTerminateDebugProcess64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallTerminateDebugProcessEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallTerminateDebugProcessEv]

//-------------------------------------------------
// Result GetDebugEvent(KUserPointer<nn::svc::ilp32::DebugEventInfo*> pInfo, nn::svc::Handle debug)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0  ref 56 pInfo    Register 0  ref 56 pInfo
//     Register 1       4 debug    Register 1       4 debug
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallGetDebugEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallGetDebugEventEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallGetDebugEventEv, %function
    .type    _ZN2nn4kern3svc24SvcGetDebugEvent64From32ENS1_12KUserPointerIPNS_3svc5ilp3214DebugEventInfoEvEENS3_6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3217CallGetDebugEventEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc24SvcGetDebugEvent64From32ENS1_12KUserPointerIPNS_3svc5ilp3214DebugEventInfoEvEENS3_6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallGetDebugEventEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallGetDebugEventEv]

//-------------------------------------------------
// Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, KUserPointer<const nn::Bit64*> pThreadIds, int32_t arraySize)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       4 debug        Register 0       4 debug
//     Register 1       4 flags        Register 1       4 flags
//     Register 2  ref -- pThreadIds   Register 2  ref -- pThreadIds
//     Register 3       4 arraySize    Register 3       4 arraySize
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallContinueDebugEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallContinueDebugEventEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallContinueDebugEventEv, %function
    .type    _ZN2nn4kern3svc29SvcContinueDebugEvent64From32ENS_3svc6HandleEjNS1_12KUserPointerIPKmvEEi, %function
_ZN2nn4kern3svc13Aarch64From3222CallContinueDebugEventEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc29SvcContinueDebugEvent64From32ENS_3svc6HandleEjNS1_12KUserPointerIPKmvEEi
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallContinueDebugEventEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallContinueDebugEventEv]

//-------------------------------------------------
// Result GetProcessList(int32_t* pNumProcesses, KUserPointer<nn::Bit64*> pProcessIds, int32_t arraySize)
//
//     Invariant s=4 r=8 p=4              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  4 pNumProcesses
//     Register 1  ref -- pProcessIds     Register 1  ref -- pProcessIds
//     Register 2       4 arraySize       Register 2       4 arraySize
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       4 pNumProcesses   
//
// conversion
//   Scatter         pNumProcesses

    .section .text._ZN2nn4kern3svc13Aarch64From3218CallGetProcessListEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3218CallGetProcessListEv
    .type    _ZN2nn4kern3svc13Aarch64From3218CallGetProcessListEv, %function
    .type    _ZN2nn4kern3svc25SvcGetProcessList64From32EPiNS1_12KUserPointerIPmvEEi, %function
_ZN2nn4kern3svc13Aarch64From3218CallGetProcessListEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pNumProcesses の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pNumProcesses のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcGetProcessList64From32EPiNS1_12KUserPointerIPmvEEi

    ldr      w1, [sp, #0]              // pNumProcesses の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3218CallGetProcessListEv, [.-_ZN2nn4kern3svc13Aarch64From3218CallGetProcessListEv]

//-------------------------------------------------
// Result GetThreadList(int32_t* pNumThreads, KUserPointer<nn::Bit64*> pThreadIds, int32_t arraySize, nn::svc::Handle domain)
//
//     Invariant s=4 r=8 p=4            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pNumThreads
//     Register 1  ref -- pThreadIds    Register 1  ref -- pThreadIds
//     Register 2       4 arraySize     Register 2       4 arraySize
//     Register 3       4 domain        Register 3       4 domain
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pNumThreads   
//
// conversion
//   Scatter         pNumThreads

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallGetThreadListEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallGetThreadListEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallGetThreadListEv, %function
    .type    _ZN2nn4kern3svc24SvcGetThreadList64From32EPiNS1_12KUserPointerIPmvEEiNS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3217CallGetThreadListEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pNumThreads の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pNumThreads のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcGetThreadList64From32EPiNS1_12KUserPointerIPmvEEiNS_3svc6HandleE

    ldr      w1, [sp, #0]              // pNumThreads の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallGetThreadListEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallGetThreadListEv]

//-------------------------------------------------
// Result GetDebugThreadContext(KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags)
//
//     Invariant s=4 r=8 p=4             AArch64 s=8 r=8 p=8
// in  svc                               abi
//     Register 0  ref 332 pContext      Register 0  ref 332 pContext
//     Register 1       4 debug          Register 1       4 debug
//     Register 2       8 threadId       Register 2       8 threadId
//     Register 3       8 threadId       Register 3       4 controlFlags
//     Register 4       4 controlFlags   
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//
// conversion
//   Pack            threadId
//   Move            controlFlags

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallGetDebugThreadContextEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallGetDebugThreadContextEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallGetDebugThreadContextEv, %function
    .type    _ZN2nn4kern3svc32SvcGetDebugThreadContext64From32ENS1_12KUserPointerIPNS_3svc13ThreadContextEvEENS3_6HandleEmj, %function
_ZN2nn4kern3svc13Aarch64From3225CallGetDebugThreadContextEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // threadId を 32 bit x2 から 64 bit へ
    mov      x3, x4                    // controlFlags

    bl       _ZN2nn4kern3svc32SvcGetDebugThreadContext64From32ENS1_12KUserPointerIPNS_3svc13ThreadContextEvEENS3_6HandleEmj
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallGetDebugThreadContextEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallGetDebugThreadContextEv]

//-------------------------------------------------
// Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, KUserPointer<const nn::svc::ThreadContext*> context, nn::Bit32 controlFlags)
//
//     Invariant s=4 r=8 p=4             AArch64 s=8 r=8 p=8
// in  svc                               abi
//     Register 0       4 debug          Register 0       4 debug
//     Register 1  ref 332 context       Register 1       8 threadId
//     Register 2       8 threadId       Register 2  ref 332 context
//     Register 3       8 threadId       Register 3       4 controlFlags
//     Register 4       4 controlFlags   
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//
// conversion
//   Move            context
//   Pack            threadId
//   Move            controlFlags

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallSetDebugThreadContextEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallSetDebugThreadContextEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallSetDebugThreadContextEv, %function
    .type    _ZN2nn4kern3svc32SvcSetDebugThreadContext64From32ENS_3svc6HandleEmNS1_12KUserPointerIPKNS2_13ThreadContextEvEEj, %function
_ZN2nn4kern3svc13Aarch64From3225CallSetDebugThreadContextEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    mov      x5, x1                    // context
    orr      x1, x2, x3, lsl #32       // threadId を 32 bit x2 から 64 bit へ
    mov      x3, x4                    // controlFlags
    mov      x2, x5                    // context

    bl       _ZN2nn4kern3svc32SvcSetDebugThreadContext64From32ENS_3svc6HandleEmNS1_12KUserPointerIPKNS2_13ThreadContextEvEEj
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallSetDebugThreadContextEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallSetDebugThreadContextEv]

//-------------------------------------------------
// Result QueryDebugProcessMemory(KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//                                     Register 1  ref  4 pPageInfo
//     Register 2       4 process      Register 2       4 process
//     Register 3       4 addr         Register 3       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc13Aarch64From3227CallQueryDebugProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3227CallQueryDebugProcessMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3227CallQueryDebugProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc34SvcQueryDebugProcessMemory64From32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm, %function
_ZN2nn4kern3svc13Aarch64From3227CallQueryDebugProcessMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc34SvcQueryDebugProcessMemory64From32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm

    ldr      w1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3227CallQueryDebugProcessMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3227CallQueryDebugProcessMemoryEv]

//-------------------------------------------------
// Result ReadDebugProcessMemory(uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 buf      Register 0       8 buf
//     Register 1       4 debug    Register 1       4 debug
//     Register 2       4 addr     Register 2       8 addr
//     Register 3       4 size     Register 3       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3226CallReadDebugProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3226CallReadDebugProcessMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3226CallReadDebugProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc33SvcReadDebugProcessMemory64From32EmNS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3226CallReadDebugProcessMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc33SvcReadDebugProcessMemory64From32EmNS_3svc6HandleEmm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3226CallReadDebugProcessMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3226CallReadDebugProcessMemoryEv]

//-------------------------------------------------
// Result WriteDebugProcessMemory(nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       4 debug    Register 0       4 debug
//     Register 1       4 buf      Register 1       8 buf
//     Register 2       4 addr     Register 2       8 addr
//     Register 3       4 size     Register 3       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3227CallWriteDebugProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3227CallWriteDebugProcessMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3227CallWriteDebugProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc34SvcWriteDebugProcessMemory64From32ENS_3svc6HandleEmmm, %function
_ZN2nn4kern3svc13Aarch64From3227CallWriteDebugProcessMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc34SvcWriteDebugProcessMemory64From32ENS_3svc6HandleEmmm
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3227CallWriteDebugProcessMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3227CallWriteDebugProcessMemoryEv]

//-------------------------------------------------
// Result SetHardwareBreakPoint(nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 regNo     Register 0       4 regNo
//     Register 1       8 value     Register 1       8 control
//     Register 2       8 control   Register 2       8 value
//     Register 3       8 control   
//     Register 4       8 value     
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Pack            value
//   Pack            control

    .section .text._ZN2nn4kern3svc13Aarch64From3225CallSetHardwareBreakPointEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3225CallSetHardwareBreakPointEv
    .type    _ZN2nn4kern3svc13Aarch64From3225CallSetHardwareBreakPointEv, %function
    .type    _ZN2nn4kern3svc32SvcSetHardwareBreakPoint64From32ENS_3svc30HardwareBreakPointRegisterNameEmm, %function
_ZN2nn4kern3svc13Aarch64From3225CallSetHardwareBreakPointEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x5, x1, x4, lsl #32       // value を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // control を 32 bit x2 から 64 bit へ
    mov      x2, x5                    // value

    bl       _ZN2nn4kern3svc32SvcSetHardwareBreakPoint64From32ENS_3svc30HardwareBreakPointRegisterNameEmm
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3225CallSetHardwareBreakPointEv, [.-_ZN2nn4kern3svc13Aarch64From3225CallSetHardwareBreakPointEv]

//-------------------------------------------------
// Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       8 threadId   Register 0  ref  8 pOut1
//     Register 1       8 threadId   Register 1  ref  4 pOut2
//     Register 2       4 debug      Register 2       4 debug
//     Register 3       4 select     Register 3       8 threadId
//                                   Register 4       4 select
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1       8 pOut1      
//     Register 2       8 pOut1      
//     Register 3       4 pOut2      
//
// conversion
//   Pack            threadId
//   Move            select
//   Scatter         pOut1
//   Scatter         pOut2

    .section .text._ZN2nn4kern3svc13Aarch64From3223CallGetDebugThreadParamEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3223CallGetDebugThreadParamEv
    .type    _ZN2nn4kern3svc13Aarch64From3223CallGetDebugThreadParamEv, %function
    .type    _ZN2nn4kern3svc30SvcGetDebugThreadParam64From32EPmPjNS_3svc6HandleEmNS4_16DebugThreadParamE, %function
_ZN2nn4kern3svc13Aarch64From3223CallGetDebugThreadParamEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    mov      x4, x3                    // select
    orr      x3, x0, x1, lsl #32       // threadId を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pOut1 の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pOut1 の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut1 のアドレスをレジスタへ
    str      w3, [sp, #8]              // pOut2 の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pOut2 のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc30SvcGetDebugThreadParam64From32EPmPjNS_3svc6HandleEmNS4_16DebugThreadParamE

    ldr      w1, [sp, #0]              // pOut1 の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pOut1 の第 2 ワードをスタックからレジスタへ
    ldr      w3, [sp, #8]              // pOut2 の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3223CallGetDebugThreadParamEv, [.-_ZN2nn4kern3svc13Aarch64From3223CallGetDebugThreadParamEv]

//-------------------------------------------------
// Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//     Register 0       8 param    Register 0  ref  8 pOut
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Pack            param
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallGetSystemInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallGetSystemInfoEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallGetSystemInfoEv, %function
    .type    _ZN2nn4kern3svc24SvcGetSystemInfo64From32EPmNS_3svc14SystemInfoTypeENS3_6HandleEm, %function
_ZN2nn4kern3svc13Aarch64From3217CallGetSystemInfoEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    orr      x3, x0, x3, lsl #32       // param を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcGetSystemInfo64From32EPmNS_3svc14SystemInfoTypeENS3_6HandleEm

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallGetSystemInfoEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallGetSystemInfoEv]

//-------------------------------------------------
// Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name)
//
//     Invariant s=4 r=8 p=4            AArch64 s=8 r=8 p=8
// in  svc                              abi
//     Register 0       4 name          Register 0  ref  4 pOutServer
//                                      Register 1  ref  4 pOutClient
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//     Register 3       1 isLight       Register 3       1 isLight
//                                      Register 4       8 name
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOutServer    
//     Register 2       4 pOutClient    
//
// conversion
//   Move            name
//   Scatter         pOutServer
//   Scatter         pOutClient

    .section .text._ZN2nn4kern3svc13Aarch64From3214CallCreatePortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3214CallCreatePortEv
    .type    _ZN2nn4kern3svc13Aarch64From3214CallCreatePortEv, %function
    .type    _ZN2nn4kern3svc21SvcCreatePort64From32EPNS_3svc6HandleES4_ibm, %function
_ZN2nn4kern3svc13Aarch64From3214CallCreatePortEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    mov      x4, x0                    // name

    str      w1, [sp, #0]              // pOutServer の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOutServer のアドレスをレジスタへ
    str      w2, [sp, #8]              // pOutClient の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pOutClient のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc21SvcCreatePort64From32EPNS_3svc6HandleES4_ibm

    ldr      w1, [sp, #0]              // pOutServer の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #8]              // pOutClient の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3214CallCreatePortEv, [.-_ZN2nn4kern3svc13Aarch64From3214CallCreatePortEv]

//-------------------------------------------------
// Result ManageNamedPort(nn::svc::Handle* pOutServer, KUserPointer<const char*> name, int32_t maxSessions)
//
//     Invariant s=4 r=8 p=4            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pOutServer
//     Register 1  ref -- name          Register 1  ref -- name
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOutServer    
//
// conversion
//   Scatter         pOutServer

    .section .text._ZN2nn4kern3svc13Aarch64From3219CallManageNamedPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3219CallManageNamedPortEv
    .type    _ZN2nn4kern3svc13Aarch64From3219CallManageNamedPortEv, %function
    .type    _ZN2nn4kern3svc26SvcManageNamedPort64From32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEEi, %function
_ZN2nn4kern3svc13Aarch64From3219CallManageNamedPortEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOutServer の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOutServer のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc26SvcManageNamedPort64From32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEEi

    ldr      w1, [sp, #0]              // pOutServer の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3219CallManageNamedPortEv, [.-_ZN2nn4kern3svc13Aarch64From3219CallManageNamedPortEv]

//-------------------------------------------------
// Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 port     Register 1       4 port
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallConnectToPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallConnectToPortEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallConnectToPortEv, %function
    .type    _ZN2nn4kern3svc24SvcConnectToPort64From32EPNS_3svc6HandleES3_, %function
_ZN2nn4kern3svc13Aarch64From3217CallConnectToPortEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcConnectToPort64From32EPNS_3svc6HandleES3_

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallConnectToPortEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallConnectToPortEv]

//-------------------------------------------------
// Result SetProcessMemoryPermission(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0       4 process      Register 0       4 process
//     Register 1       8 size         Register 1       8 addr
//     Register 2       8 addr         Register 2       8 size
//     Register 3       8 addr         Register 3       4 permission
//     Register 4       8 size         
//     Register 5       4 permission   
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion
//   Pack            size
//   Pack            addr
//   Move            permission

    .section .text._ZN2nn4kern3svc13Aarch64From3230CallSetProcessMemoryPermissionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3230CallSetProcessMemoryPermissionEv
    .type    _ZN2nn4kern3svc13Aarch64From3230CallSetProcessMemoryPermissionEv, %function
    .type    _ZN2nn4kern3svc37SvcSetProcessMemoryPermission64From32ENS_3svc6HandleEmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc13Aarch64From3230CallSetProcessMemoryPermissionEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    orr      x6, x1, x4, lsl #32       // size を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // addr を 32 bit x2 から 64 bit へ
    mov      x3, x5                    // permission
    mov      x2, x6                    // size

    bl       _ZN2nn4kern3svc37SvcSetProcessMemoryPermission64From32ENS_3svc6HandleEmmNS2_16MemoryPermissionE
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3230CallSetProcessMemoryPermissionEv, [.-_ZN2nn4kern3svc13Aarch64From3230CallSetProcessMemoryPermissionEv]

//-------------------------------------------------
// Result MapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 fromAddr   Register 3       8 size
//     Register 4       4 size       
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Pack            fromAddr
//   Move            size

    .section .text._ZN2nn4kern3svc13Aarch64From3220CallMapProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3220CallMapProcessMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3220CallMapProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc27SvcMapProcessMemory64From32EmNS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3220CallMapProcessMemoryEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // fromAddr を 32 bit x2 から 64 bit へ
    mov      x3, x4                    // size

    bl       _ZN2nn4kern3svc27SvcMapProcessMemory64From32EmNS_3svc6HandleEmm
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3220CallMapProcessMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3220CallMapProcessMemoryEv]

//-------------------------------------------------
// Result UnmapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 fromAddr   Register 3       8 size
//     Register 4       4 size       
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Pack            fromAddr
//   Move            size

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallUnmapProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallUnmapProcessMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallUnmapProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc29SvcUnmapProcessMemory64From32EmNS_3svc6HandleEmm, %function
_ZN2nn4kern3svc13Aarch64From3222CallUnmapProcessMemoryEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // fromAddr を 32 bit x2 から 64 bit へ
    mov      x3, x4                    // size

    bl       _ZN2nn4kern3svc29SvcUnmapProcessMemory64From32EmNS_3svc6HandleEmm
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallUnmapProcessMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallUnmapProcessMemoryEv]

//-------------------------------------------------
// Result QueryProcessMemory(KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr)
//
//     Invariant s=4 r=8 p=4           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1       8 addr         Register 1  ref  4 pPageInfo
//     Register 2       4 process      Register 2       4 process
//     Register 3       8 addr         Register 3       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Pack            addr
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc13Aarch64From3222CallQueryProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3222CallQueryProcessMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3222CallQueryProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc29SvcQueryProcessMemory64From32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm, %function
_ZN2nn4kern3svc13Aarch64From3222CallQueryProcessMemoryEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    orr      x3, x1, x3, lsl #32       // addr を 32 bit x2 から 64 bit へ

    str      w1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcQueryProcessMemory64From32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm

    ldr      w1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3222CallQueryProcessMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3222CallQueryProcessMemoryEv]

//-------------------------------------------------
// Result MapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 fromAddr   Register 1       8 toAddr
//     Register 2       8 toAddr     Register 2       8 fromAddr
//     Register 3       8 toAddr     Register 3       8 size
//     Register 4       8 fromAddr   
//     Register 5       8 size       
//     Register 6       8 size       
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Pack            fromAddr
//   Pack            toAddr
//   Pack            size

    .section .text._ZN2nn4kern3svc13Aarch64From3224CallMapProcessCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3224CallMapProcessCodeMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3224CallMapProcessCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc31SvcMapProcessCodeMemory64From32ENS_3svc6HandleEmmm, %function
_ZN2nn4kern3svc13Aarch64From3224CallMapProcessCodeMemoryEv:

    stp      x7, x30, [sp, #-16]!
    orr      x7, x1, x4, lsl #32       // fromAddr を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // toAddr を 32 bit x2 から 64 bit へ
    orr      x3, x5, x6, lsl #32       // size を 32 bit x2 から 64 bit へ
    mov      x2, x7                    // fromAddr

    bl       _ZN2nn4kern3svc31SvcMapProcessCodeMemory64From32ENS_3svc6HandleEmmm
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3224CallMapProcessCodeMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3224CallMapProcessCodeMemoryEv]

//-------------------------------------------------
// Result UnmapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 fromAddr   Register 1       8 toAddr
//     Register 2       8 toAddr     Register 2       8 fromAddr
//     Register 3       8 toAddr     Register 3       8 size
//     Register 4       8 fromAddr   
//     Register 5       8 size       
//     Register 6       8 size       
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Pack            fromAddr
//   Pack            toAddr
//   Pack            size

    .section .text._ZN2nn4kern3svc13Aarch64From3226CallUnmapProcessCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3226CallUnmapProcessCodeMemoryEv
    .type    _ZN2nn4kern3svc13Aarch64From3226CallUnmapProcessCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc33SvcUnmapProcessCodeMemory64From32ENS_3svc6HandleEmmm, %function
_ZN2nn4kern3svc13Aarch64From3226CallUnmapProcessCodeMemoryEv:

    stp      x7, x30, [sp, #-16]!
    orr      x7, x1, x4, lsl #32       // fromAddr を 32 bit x2 から 64 bit へ
    orr      x1, x2, x3, lsl #32       // toAddr を 32 bit x2 から 64 bit へ
    orr      x3, x5, x6, lsl #32       // size を 32 bit x2 から 64 bit へ
    mov      x2, x7                    // fromAddr

    bl       _ZN2nn4kern3svc33SvcUnmapProcessCodeMemory64From32ENS_3svc6HandleEmmm
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3226CallUnmapProcessCodeMemoryEv, [.-_ZN2nn4kern3svc13Aarch64From3226CallUnmapProcessCodeMemoryEv]

//-------------------------------------------------
// Result CreateProcess(nn::svc::Handle* pOut, KUserPointer<const nn::svc::ilp32::CreateProcessParameter*> params, KUserPointer<const nn::Bit32*> flags, int32_t flagsNum)
//
//     Invariant s=4 r=8 p=4         AArch64 s=8 r=8 p=8
// in  svc                           abi
//                                   Register 0  ref  4 pOut
//     Register 1  ref 48 params     Register 1  ref 48 params
//     Register 2  ref -- flags      Register 2  ref -- flags
//     Register 3       4 flagsNum   Register 3       4 flagsNum
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1       4 pOut       
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3217CallCreateProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3217CallCreateProcessEv
    .type    _ZN2nn4kern3svc13Aarch64From3217CallCreateProcessEv, %function
    .type    _ZN2nn4kern3svc24SvcCreateProcess64From32EPNS_3svc6HandleENS1_12KUserPointerIPKNS2_5ilp3222CreateProcessParameterEvEENS5_IPKjvEEi, %function
_ZN2nn4kern3svc13Aarch64From3217CallCreateProcessEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcCreateProcess64From32EPNS_3svc6HandleENS1_12KUserPointerIPKNS2_5ilp3222CreateProcessParameterEvEENS5_IPKjvEEi

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3217CallCreateProcessEv, [.-_ZN2nn4kern3svc13Aarch64From3217CallCreateProcessEv]

//-------------------------------------------------
// Result StartProcess(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize)
//
//     Invariant s=4 r=8 p=4          AArch64 s=8 r=8 p=8
// in  svc                            abi
//     Register 0       4 runner      Register 0       4 runner
//     Register 1       4 priority    Register 1       4 priority
//     Register 2       4 coreNo      Register 2       4 coreNo
//     Register 3       8 stackSize   Register 3       8 stackSize
//     Register 4       8 stackSize   
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//
// conversion
//   Pack            stackSize

    .section .text._ZN2nn4kern3svc13Aarch64From3216CallStartProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3216CallStartProcessEv
    .type    _ZN2nn4kern3svc13Aarch64From3216CallStartProcessEv, %function
    .type    _ZN2nn4kern3svc23SvcStartProcess64From32ENS_3svc6HandleEiim, %function
_ZN2nn4kern3svc13Aarch64From3216CallStartProcessEv:

    stp      x7, x30, [sp, #-16]!
    stp      x5, x6, [sp, #-16]!
    orr      x3, x3, x4, lsl #32       // stackSize を 32 bit x2 から 64 bit へ

    bl       _ZN2nn4kern3svc23SvcStartProcess64From32ENS_3svc6HandleEiim
    ldp      x5, x6, [sp], #16
    ldp      x7, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3216CallStartProcessEv, [.-_ZN2nn4kern3svc13Aarch64From3216CallStartProcessEv]

//-------------------------------------------------
// Result TerminateProcess(nn::svc::Handle process)
//
//     Invariant s=4 r=8 p=4        AArch64 s=8 r=8 p=8
// in  svc                          abi
//     Register 0       4 process   Register 0       4 process
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3220CallTerminateProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3220CallTerminateProcessEv
    .type    _ZN2nn4kern3svc13Aarch64From3220CallTerminateProcessEv, %function
    .type    _ZN2nn4kern3svc27SvcTerminateProcess64From32ENS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3220CallTerminateProcessEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc27SvcTerminateProcess64From32ENS_3svc6HandleE
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3220CallTerminateProcessEv, [.-_ZN2nn4kern3svc13Aarch64From3220CallTerminateProcessEv]

//-------------------------------------------------
// Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 handle   Register 1       4 handle
//     Register 2       4 type     Register 2       4 type
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3218CallGetProcessInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3218CallGetProcessInfoEv
    .type    _ZN2nn4kern3svc13Aarch64From3218CallGetProcessInfoEv, %function
    .type    _ZN2nn4kern3svc25SvcGetProcessInfo64From32EPlNS_3svc6HandleENS3_15ProcessInfoTypeE, %function
_ZN2nn4kern3svc13Aarch64From3218CallGetProcessInfoEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      w2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcGetProcessInfo64From32EPlNS_3svc6HandleENS3_15ProcessInfoTypeE

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      w2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3218CallGetProcessInfoEv, [.-_ZN2nn4kern3svc13Aarch64From3218CallGetProcessInfoEv]

//-------------------------------------------------
// Result CreateResourceLimit(nn::svc::Handle* pOut)
//
//     Invariant s=4 r=8 p=4       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc13Aarch64From3223CallCreateResourceLimitEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3223CallCreateResourceLimitEv
    .type    _ZN2nn4kern3svc13Aarch64From3223CallCreateResourceLimitEv, %function
    .type    _ZN2nn4kern3svc30SvcCreateResourceLimit64From32EPNS_3svc6HandleE, %function
_ZN2nn4kern3svc13Aarch64From3223CallCreateResourceLimitEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    sub      sp, sp, #16

    str      w1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc30SvcCreateResourceLimit64From32EPNS_3svc6HandleE

    ldr      w1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3223CallCreateResourceLimitEv, [.-_ZN2nn4kern3svc13Aarch64From3223CallCreateResourceLimitEv]

//-------------------------------------------------
// Result SetResourceLimitLimitValue(nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value)
//
//     Invariant s=4 r=8 p=4              AArch64 s=8 r=8 p=8
// in  svc                                abi
//     Register 0       4 resourceLimit   Register 0       4 resourceLimit
//     Register 1       4 resource        Register 1       4 resource
//     Register 2       8 value           Register 2       8 value
//     Register 3       8 value           
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//
// conversion
//   Pack            value

    .section .text._ZN2nn4kern3svc13Aarch64From3230CallSetResourceLimitLimitValueEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3230CallSetResourceLimitLimitValueEv
    .type    _ZN2nn4kern3svc13Aarch64From3230CallSetResourceLimitLimitValueEv, %function
    .type    _ZN2nn4kern3svc37SvcSetResourceLimitLimitValue64From32ENS_3svc6HandleENS2_17LimitableResourceEl, %function
_ZN2nn4kern3svc13Aarch64From3230CallSetResourceLimitLimitValueEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    orr      x2, x2, x3, lsl #32       // value を 32 bit x2 から 64 bit へ

    bl       _ZN2nn4kern3svc37SvcSetResourceLimitLimitValue64From32ENS_3svc6HandleENS2_17LimitableResourceEl
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3230CallSetResourceLimitLimitValueEv, [.-_ZN2nn4kern3svc13Aarch64From3230CallSetResourceLimitLimitValueEv]

//-------------------------------------------------
// void CallSecureMonitor()
//
//     Invariant s=4 r=8 p=4   AArch64 s=8 r=8 p=8
// in  svc   abi
//
// in  svc   abi
//
// conversion

    .section .text._ZN2nn4kern3svc13Aarch64From3221CallCallSecureMonitorEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc13Aarch64From3221CallCallSecureMonitorEv
    .type    _ZN2nn4kern3svc13Aarch64From3221CallCallSecureMonitorEv, %function
    .type    _ZN2nn4kern3svc28SvcCallSecureMonitor64From32Ev, %function
_ZN2nn4kern3svc13Aarch64From3221CallCallSecureMonitorEv:

    stp      x29, x30, [sp, #-16]!
    stp      x6, x7, [sp, #-16]!
    stp      x4, x5, [sp, #-16]!
    bl       _ZN2nn4kern3svc28SvcCallSecureMonitor64From32Ev
    ldp      x4, x5, [sp], #16
    ldp      x6, x7, [sp], #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc13Aarch64From3221CallCallSecureMonitorEv, [.-_ZN2nn4kern3svc13Aarch64From3221CallCallSecureMonitorEv]

    .end

