﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM64/kern_Assembly.h"

/*
 * EL1 Sync例外ハンドラの中で ELR_EL1 が
 * _ZN2nn4kern5ARM6431BeginUserMemoryCopyFunctionAreaEv
 *  ～ _ZN2nn4kern5ARM6429EndUserMemoryCopyFunctionAreaEv のときは、
 * mov x0, #0
 * msr elr_el1, x30
 * eret
 * としてやる。
 */



    .section ".text"
    .globl  _ZN2nn4kern5ARM6431BeginUserMemoryCopyFunctionAreaEv
_ZN2nn4kern5ARM6431BeginUserMemoryCopyFunctionAreaEv:

// bool CopyMemoryFromUser(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6418CopyMemoryFromUserEPvPKvm)
    cmp     x2, #0
    b.eq    1f

    add     x3, x1, x2
loopCopyMemoryFromUser:
    ldtrb   w2, [x1]
    strb    w2, [x0], #1
    add     x1, x1, #1
    cmp     x1, x3
    b.ne    loopCopyMemoryFromUser
1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6418CopyMemoryFromUserEPvPKvm)

// bool CopyMemoryFromUserAlign4(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6424CopyMemoryFromUserAlign4EPvPKvm)
1:  cmp     x2, #0x3f
    b.ls    loopCopyMemoryFromUserAlign4Less64
    // size >= 64
    ldtr    x4,  [x1, #0]
    ldtr    x5,  [x1, #8]
    ldtr    x6,  [x1, #16]
    ldtr    x7,  [x1, #24]
    ldtr    x8,  [x1, #32]
    ldtr    x9,  [x1, #40]
    ldtr    x10, [x1, #48]
    ldtr    x11, [x1, #56]
    str     x4,  [x0, #0]
    str     x5,  [x0, #8]
    str     x6,  [x0, #16]
    str     x7,  [x0, #24]
    str     x8,  [x0, #32]
    str     x9,  [x0, #40]
    str     x10, [x0, #48]
    str     x11, [x0, #56]
    add     x0, x0, #64
    add     x1, x1, #64
    sub     x2, x2, #64
    b       1b

loopCopyMemoryFromUserAlign4Less64:
2:  cmp     x2, #0
    b.eq    3f
    ldtr    w4,  [x1]
    str     w4,  [x0], #4
    add     x1, x1, #4
    sub     x2, x2, #4
    b       2b
3:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6424CopyMemoryFromUserAlign4EPvPKvm)

// bool CopyMemoryFromUserAlign4(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6424CopyMemoryFromUserAlign8EPvPKvm)
    cmp     x2, #0
    b.eq    1f

    add     x3, x1, x2
loopCopyMemoryFromUserAlign8:
    ldtr    x2, [x1]
    str     x2, [x0], #8
    add     x1, x1, #8
    cmp     x1, x3
    b.ne    loopCopyMemoryFromUserAlign8
1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6424CopyMemoryFromUserAlign8EPvPKvm)

// bool CopyMemoryFromUserOnly4(void*, const void*)
ENTRY(_ZN2nn4kern5ARM6423CopyMemoryFromUserOnly4EPvPKv)
    ldtr    w2, [x1]
    str     w2, [x0]
    mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6423CopyMemoryFromUserOnly4EPvPKv)


// int32_t CopyStringFromUser(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6418CopyStringFromUserEPvPKvm)
    cmp     x2, #0
    b.eq    2f

    mov     x4, x1
    add     x3, x1, x2
.LloopCopyStringFromUser:
    ldtrb   w2, [x1]
    strb    w2, [x0], #1
    add     x1, x1, #1
    cmp     w2, #0
    b.eq    1f
    cmp     x1, x3
    b.ne    .LloopCopyStringFromUser
1:  sub     x0, x1, x4
    ret
2:  mov     x0, #0
    ret
SET_SIZE(_ZN2nn4kern5ARM6418CopyStringFromUserEPvPKvm)

// bool CopyMemoryToUser(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6416CopyMemoryToUserEPvPKvm)
    cmp     x2, #0
    b.eq    1f

    add     x3, x1, x2
.LloopCopyMemoryToUser:
    ldrb    w2, [x1], #1
    sttrb   w2, [x0]
    add     x0, x0, #1
    cmp     x1, x3
    b.ne    .LloopCopyMemoryToUser
1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6416CopyMemoryToUserEPvPKvm)

// bool CopyMemoryToUser(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6422CopyMemoryToUserAlign4EPvPKvm)
1:  cmp     x2, #0x3f
    b.ls    .LloopCopyMemoryToUserAlign4Less64
    // size >= 64
    ldr     x4,  [x1, #0]
    ldr     x5,  [x1, #8]
    ldr     x6,  [x1, #16]
    ldr     x7,  [x1, #24]
    ldr     x8,  [x1, #32]
    ldr     x9,  [x1, #40]
    ldr     x10, [x1, #48]
    ldr     x11, [x1, #56]
    sttr    x4,  [x0, #0]
    sttr    x5,  [x0, #8]
    sttr    x6,  [x0, #16]
    sttr    x7,  [x0, #24]
    sttr    x8,  [x0, #32]
    sttr    x9,  [x0, #40]
    sttr    x10,  [x0, #48]
    sttr    x11,  [x0, #56]
    add     x0, x0, #64
    add     x1, x1, #64
    sub     x2, x2, #64
    b       1b

.LloopCopyMemoryToUserAlign4Less64:
2:  cmp     x2, #0
    b.eq    3f
    ldr     w4, [x1], #4
    sttr    w4, [x0]
    add     x0, x0, #4
    sub     x2, x2, #4
    b       2b
3:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6422CopyMemoryToUserAlign4EPvPKvm)

// bool CopyMemoryToUser(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6422CopyMemoryToUserAlign8EPvPKvm)
    cmp     x2, #0
    b.eq    1f

    add     x3, x1, x2
.LloopCopyMemoryToUserAlign8:
    ldr     x2, [x1], #8
    sttr    x2, [x0]
    add     x0, x0, #8
    cmp     x1, x3
    b.ne    .LloopCopyMemoryToUserAlign8
1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6422CopyMemoryToUserAlign8EPvPKvm)

// bool CopyMemoryToUserOnly4(void*, const void*)
ENTRY(_ZN2nn4kern5ARM6421CopyMemoryToUserOnly4EPvPKv)
    ldr     w2, [x1]
    sttr    w2, [x0]
    mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6421CopyMemoryToUserOnly4EPvPKv)


// int32_t CopyStringToUser(void*, const void*, size_t)
ENTRY(_ZN2nn4kern5ARM6416CopyStringToUserEPvPKvj)
    cmp     x2, #0
    b.eq    2f

    mov     x4, x1
    add     x3, x1, x2
.LloopCopyStringToUser:
    ldrb    w2, [x1], #1
    sttrb   w2, [x0]
    add     x0, x0, #1
    cmp     w2, #0
    b.eq    1f
    cmp     x1, x3
    b.ne    .LloopCopyStringToUser
1:  sub     x0, x1, x4
    ret
2:  mov     x0, #0
    ret
SET_SIZE(_ZN2nn4kern5ARM6416CopyStringToUserEPvPKvj)

//  bool ClearUserMemory(void*, size_t)
ENTRY(_ZN2nn4kern5ARM6415ClearUserMemoryEPvj)
    cmp     x1, #0
    b.eq    1f

    add     x3, x0, x1
    mov     w2, #0
.LloopClearUserMemory:
    sttrb   w2, [x0]
    add     x0, x0, #1
    cmp     x0, x3
    b.ne    .LloopClearUserMemory
1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6415ClearUserMemoryEPvj)

//bool ClearUserMemoryAlign4(void*, size_t)
ENTRY(_ZN2nn4kern5ARM6421ClearUserMemoryAlign4EPvj)
    cmp     x1, #0
    b.eq    1f

    add     x3, x0, x1
    mov     w2, #0
.LloopClearUserMemoryAlign4:
    sttr    w2, [x0]
    add     x0, x0, #4
    cmp     x0, x3
    b.ne    .LloopClearUserMemoryAlign4
1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6421ClearUserMemoryAlign4EPvj)

//bool ClearUserMemoryOnly4(void*)
ENTRY(_ZN2nn4kern5ARM6420ClearUserMemoryOnly4EPv)
    mov     w2, #0
    sttr    w2, [x0]
    mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6420ClearUserMemoryOnly4EPv)


ENTRY(_ZN2nn4kern5ARM6414StoreDataCacheEmm)
//bool StoreDataCache(uintptr_t begin, uintptr_t end)
    cmp     x1, x0
    b.eq    1f
.LloopStoreDataCache:
    dc      cvac, x0
    add     x0, x0, #DATA_CACHE_LINE_SIZE
    cmp     x1, x0
    b.ne    .LloopStoreDataCache

1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6414StoreDataCacheEmm)

ENTRY(_ZN2nn4kern5ARM6414FlushDataCacheEmm)
//bool FlushDataCache(uintptr_t begin, uintptr_t end)
    cmp     x1, x0
    b.eq    1f
.LloopFlushDataCache:
    dc      civac, x0
    add     x0, x0, #DATA_CACHE_LINE_SIZE
    cmp     x1, x0
    b.ne    .LloopFlushDataCache

1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6414FlushDataCacheEmm)

ENTRY(_ZN2nn4kern5ARM6419InvalidateDataCacheEmm)
//bool InvalidateDataCache(uintptr_t begin, uintptr_t end)
    cmp     x1, x0
    b.eq    1f
.LloopInvalidateDataCache:
    dc      ivac, x0
    add     x0, x0, #DATA_CACHE_LINE_SIZE
    cmp     x1, x0
    b.ne    .LloopInvalidateDataCache

1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6419InvalidateDataCacheEmm)

ENTRY(_ZN2nn4kern5ARM6426InvalidateInstructionCacheEmm)
//bool InvalidateInstructionCache(uintptr_t begin, uintptr_t end)
    cmp     x1, x0
    b.eq    1f
.LloopInvalidateInstructionCache:
    ic      ivau, x0
    add     x0, x0, #INSTRUCTION_CACHE_LINE_SIZE
    cmp     x1, x0
    b.ne    .LloopInvalidateInstructionCache

1:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6426InvalidateInstructionCacheEmm)

ENTRY(_ZN2nn4kern5ARM6414ReadIoMemory32EPvPKvm)
// bool ReadIoMemory32(void* dstUser, const void* srcUser, size_t length);
    cmp     x2, #0
    b.eq    3f

    mov     x4, x0
    mov     x5, x1
    mov     x6, x2
    add     x7, x5, x6
    mov     x8, x30

1:  adr     x30, 4f
    ldtr    w9, [x5]
    dsb     sy
    nop
2:  mov     x30, x8
    sttr    w9, [x4]
    add     x4, x4, #4
    add     x5, x5, #4
    cmp     x5, x7
    b.ne    1b
3:  mov     x0, #1
    ret
4:  mov     w9, #0xffffffff
    b       2b
SET_SIZE(_ZN2nn4kern5ARM6414ReadIoMemory32EPvPKvm)

ENTRY(_ZN2nn4kern5ARM6414ReadIoMemory16EPvPKvm)
// bool ReadIoMemory16(void* dstUser, const void* srcUser, size_t length);
    cmp     x2, #0
    b.eq    3f

    mov     x4, x0
    mov     x5, x1
    mov     x6, x2
    add     x7, x5, x6
    mov     x8, x30

1:  adr     x30, 2f
    ldtrh   w9, [x5]
    dsb     sy
    nop
2:  mov     x30, x8
    sttrh   w9, [x4]
    add     x4, x4, #2
    add     x5, x5, #2
    cmp     x5, x7
    b.ne    1b
3:  mov     x0, #1
    ret
4:  mov     w9, #0xffffffff
    b       2b
SET_SIZE(_ZN2nn4kern5ARM6414ReadIoMemory16EPvPKvm)

ENTRY(_ZN2nn4kern5ARM6413ReadIoMemory8EPvPKvm)
// bool ReadIoMemory8(void* dstUser, const void* srcUser, size_t length);
    cmp     x2, #0
    b.eq    3f

    mov     x4, x0
    mov     x5, x1
    mov     x6, x2
    add     x7, x5, x6
    mov     x8, x30

1:  adr     x30, 4f
    ldtrb   w9, [x5]
    dsb     sy
    nop
2:  mov     x30, x8
    sttrb   w9, [x4]
    add     x4, x4, #1
    add     x5, x5, #1
    cmp     x5, x7
    b.ne    1b
3:  mov     x0, #1
    ret
4:  mov     w9, #0xffffffff
    b       2b
SET_SIZE(_ZN2nn4kern5ARM6413ReadIoMemory8EPvPKvm)

ENTRY(_ZN2nn4kern5ARM6415WriteIoMemory32EPvPKvm)
// bool WriteIoMemory32(void* dstUser, const void* srcUser, size_t length);
    cmp     x2, #0
    b.eq    3f

    mov     x4, x0
    mov     x5, x1
    mov     x6, x2
    add     x7, x5, x6
    mov     x8, x30

1:  mov     x30, x8
    ldtr    w9, [x5]
    adr     x30, 2f
    sttr    w9, [x4]
    dsb     sy
2:  nop
    add     x4, x4, #4
    add     x5, x5, #4
    cmp     x5, x7
    b.ne    1b
3:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6415WriteIoMemory32EPvPKvm)

ENTRY(_ZN2nn4kern5ARM6415WriteIoMemory16EPvPKvm)
// bool WriteIoMemory16(void* dstUser, const void* srcUser, size_t length);
    cmp     x2, #0
    b.eq    3f

    mov     x4, x0
    mov     x5, x1
    mov     x6, x2
    add     x7, x5, x6
    mov     x8, x30

1:  mov     x30, x8
    ldtrh   w9, [x5]
    adr     x30, 2f
    sttrh   w9, [x4]
    dsb     sy
2:  nop
    add     x4, x4, #2
    add     x5, x5, #2
    cmp     x5, x7
    b.ne    1b
3:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6415WriteIoMemory16EPvPKvm)

ENTRY(_ZN2nn4kern5ARM6414WriteIoMemory8EPvPKvm)
// bool WriteIoMemory8(void* dstUser, const void* srcUser, size_t length);
    cmp     x2, #0
    b.eq    3f

    mov     x4, x0
    mov     x5, x1
    mov     x6, x2
    add     x7, x5, x6
    mov     x8, x30

1:  mov     x30, x8
    ldtrb   w9, [x5]
    adr     x30, 2f
    sttrb   w9, [x4]
    dsb     sy
2:  nop
    add     x4, x4, #1
    add     x5, x5, #1
    cmp     x5, x7
    b.ne    1b
3:  mov     x0, #1
    ret
SET_SIZE(_ZN2nn4kern5ARM6414WriteIoMemory8EPvPKvm)


    .globl  _ZN2nn4kern5ARM6429EndUserMemoryCopyFunctionAreaEv
_ZN2nn4kern5ARM6429EndUserMemoryCopyFunctionAreaEv:

