﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Kernel.h>
#include "../../kern_Result.h"
#include "../../kern_KContextBase.h"
#include "../../kern_KTaggedAddress.h"
#include <nn/nn_BitTypes.h>

namespace nn { namespace kern {
    class KThread;
    namespace ARM64 {
class KContext : public KContextBase
{
#ifdef NN_BUILD_FOR_ASSEMBLY_OFFSET
public:
#endif
    Bit64     m_CpuRegisters[11]; // r19-r29
    Bit64     m_Lr;
    Bit64     m_Sp;
#if defined(NN_BUILD_CONFIG_FPU_FP_ARM64)
    Bit64     m_Cpacr;          // cpacr_el1
    Bit64     m_Fpcr;
    Bit64     m_Fpsr;
    NN_ALIGNAS(16) Bit128 m_FpuRegisters[32];
#endif
    bool      m_Lock;

public:
    explicit KContext(){}

    Result Initialize(KVirtualAddress initialPc, KVirtualAddress kernelSp, KVirtualAddress userSp, uintptr_t firstArg, bool isUserMode, bool is64Bit, bool isMain);
    Result Finalize();
    void SetFirstArgument(uintptr_t firstArg, uintptr_t secondArg);
    size_t GetNumOfVfpRegisters() const
    {
        return sizeof(m_FpuRegisters) / sizeof(*m_FpuRegisters);
    }

    static void FpuSwitchHandler(KThread* pNext);
    static void OnThreadCoreChanged(KThread* pThread);
    static void OnThreadTerminating(const KThread* pThread);

    const Bit128* GetFpuRegisters() const;
    Bit32 GetFpsr() const;
    Bit32 GetFpcr() const;
    void SetFpuRegisters(const Bit128* x, bool is64Bit);
    void SetFpsr(Bit32 fpsr);
    void SetFpcr(Bit32 fpcr);
    void CloneFpuStatus();

private:
    static void RestoreFpu32(const KContext& pContext);
    static void RestoreFpu64(const KContext& pContext);
};
    }
}}

