﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../kern_Assembly.h"

#define SVC_ID_MASK 0xFF
#define SVC_STACK_OFFSET    EXCEPTION_CONTEXT_SIZE
    .syntax unified

#ifdef NN_KERN_ENABLE_KTRACE
#define NN_KERN_KTRACE_SVC_ENTER_TRACE      \
    push    {r0-r7};                        \
    mov     r0, sp;                         \
    bl      SvcEnterTrace;                  \
    pop     {r0-r7}

#define NN_KERN_KTRACE_SVC_LEAVE_TRACE      \
    push    {r0-r7};                        \
    mov     r0, sp;                         \
    bl      SvcLeaveTrace;                  \
    pop     {r0-r7}

#else
#define NN_KERN_KTRACE_SVC_ENTER_TRACE
#define NN_KERN_KTRACE_SVC_LEAVE_TRACE
#endif

ENTRY(_ZN2nn4kern3svc10SwiHandlerEv)
        // SVCモード -----------------------------
        // コンテキストスイッチに必要となるレジスタの保存
        srsdb   #HW_PSR_SVC_MODE!                  // 呼び出し側の PC と CPSR を保存

        // r0-7 = svc param
        // lr   = pc_usr

        // SwiHandler で使用するレジスタおよびユーザモードレジスタを保存
        // ip, write
        sub     sp, sp, #(4 * 2)
        str     ip, [sp, #0]
        mov     ip, #0
        str     ip, [sp, #4]

        sub     sp, sp, #(4 * 2)
        mrc     p15, 0, ip, c13, c0, 2
        str     ip, [sp, #0]

        stmdb   sp, {r13-r14}^
        sub     sp, sp, #8
        push    {r8-r11}
        sub     sp, sp, #(4 * 8)    // r0-r7

        // システムコール番号取得
        mrs     r9, spsr
        ands    r9, r9, #HW_PSR_STATE_MASK  // 呼び出し元が THUMB か？
        ldreq   r9, [lr, #-4]               //   ARM
        ldrhne  r9, [lr, #-2]               //   THUMB
        // r0-7 = svc param
        // r9   = swi code

        mov     r8, #1
        strb    r8, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]

        ldr     r8, = nnkernServiceTableAarch32     // システムコールアドレス（4バイトテーブル）取得
        and     r9, r9, #SVC_ID_MASK                // 命令コードからシステムコール番号を取得
        // r8   = SWI_TABLE
        // r9   = svc no.

        cmp     r9, #128
        blo     skip_invalid_svc_handler

//--------------------------------------------
//
invalid_svc_handler:
        stm     sp, {r0-r7}

        mov     r1, #1
        strb    r1, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_INEXCEPTIONHANDLER)]

        // ハンドラ呼び出し
        mov     r0, sp
        ldr     ip, =_ZN2nn4kern6ARMv7A16HandleInvalidSvcEPNS0_3ARM16ExceptionContextE
        blx     ip
        cpsid   ifa

        mov     r1, #0
        strb    r1, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_INEXCEPTIONHANDLER)]

        // コンテキストを復帰
        pop     {r0-r11}
        ldmia   sp, {r13-r14}^
        add     sp, sp, #8
        pop     {ip, lr}
        mcr     p15, 0, ip, c13, c0, 2
        pop     {ip, lr}

        // 例外から復帰
        rfeia   sp!

skip_invalid_svc_handler:
        // システムコールハンドラを取得
        ldr     r8, [r8, r9, lsl #2]
        cmp     r8, #0
        beq     invalid_svc_handler

        // プロセスに許可されている SVC_ID か否かをチェック
        add     r10, sp, r9, lsr #3
        mov     r11, #1
        ldrb    r10, [r10, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_SVCPERMISSION)]
        and     lr, r9, #0x7
        tst     r10, r11, lsl lr
        beq     invalid_svc_handler

        // r0-7 = svc param
        // r8   = svc handler
        // r9   = svc no.

        strb    r9, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_SVCNO)]

        stm     sp, {r0-r7}

        NN_KERN_KTRACE_SVC_ENTER_TRACE

        cpsie   i

        // SVC ハンドラを呼び出す
        blx     r8

        cpsid   i

dpc_handler:
        // 終了指示されているなら終了する
        ldrb    lr, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_DPCFLAGS)]
        cmp     lr, #0
        beq     swi_return

        push    {r0-r3}
        bl      _ZN2nn4kern3svc10DpcHandlerEv
        pop     {r0-r3}
        b       dpc_handler

swi_return:
        NN_KERN_KTRACE_SVC_LEAVE_TRACE
        mov     lr, #0
        strb    lr, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]

        // r0-7 = svc result
        // レジスタを書き戻す
        ldr     ip, [sp, #EXCEPTION_CONTEXT_WRITE]
        cmp     ip, #0
        beq     1f
        ldm     sp, {r0-r7}
        ldr     ip, [sp, #EXCEPTION_CONTEXT_IP]
1:      add     sp, sp, #(4 * 8)
        pop     {r8-r11}
        ldmia   sp, {r13-r14}^
        add     sp, sp, #8
        pop     {ip, lr}
        mcr     p15, 0, ip, c13, c0, 2
        add     sp, sp, #8    // ip,write
        rfeia   sp!
SET_SIZE(_ZN2nn4kern3svc10SwiHandlerEv)

ENTRY(_ZN2nn4kern3svc14RestoreContextEj)
        mov     sp, r0

        cpsid   i
dpc_handler1:
        // 終了指示されているなら終了する
        ldrb    lr, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_DPCFLAGS)]
        cmp     lr, #0
        beq     swi_return1

        push    {r0-r3}
        bl      _ZN2nn4kern3svc10DpcHandlerEv
        pop     {r0-r3}
        b       dpc_handler1

swi_return1:
        mov     lr, #0
        strb    lr, [sp, #(SVC_STACK_OFFSET + PARAMS_ON_STACK_ISCALLINGSVC)]

        // r0-7 = svc result
        // レジスタを書き戻す
        ldm     sp, {r0-r7}
        ldr     ip, [sp, #EXCEPTION_CONTEXT_IP]
        add     sp, sp, #(4 * 8)
        pop     {r8-r11}
        ldmia   sp, {r13-r14}^
        add     sp, sp, #8
        pop     {ip, lr}
        mcr     p15, 0, ip, c13, c0, 2
        add     sp, sp, #8    // ip,write
        rfeia   sp!
SET_SIZE(_ZN2nn4kern3svc14RestoreContextEj)

ENTRY(_ZN2nn4kern3svc24SvcReturnFromException32ENS_6ResultE)
    bl      _ZN2nn4kern6ARMv7A19ReturnFromExceptionENS_6ResultE
1:  b       1b
SET_SIZE(_ZN2nn4kern3svc24SvcReturnFromException32ENS_6ResultE)
