﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "../../../kern_Platform.h"
#include "kern_SvcDrivers.aarch32.autogen.h"
#include "kern_SvcHandlers.32.autogen.h"
#include "../../../kern_Kernel.h"
#include "../../../kern_KProcess.h"
#include "../../../kern_KThread.h"
#include "../../../kern_Panic.h"
#include "../kern_RegisterAccess.h"
#include "../../../kern_DpcManager.h"
#include "../../../kern_KTrace.h"

namespace nn {
    namespace kern {
        namespace svc {

#ifdef NN_KERN_ENABLE_SVC_PROFILE
void PreSvcHandler(Bit32 svcId)
{
    GetCurrentThread().IncrementNumSvc(svcId);
}
#endif

#ifdef NN_KERN_ENABLE_SVC_PROFILE
void PostSvcHandler(Bit32 svcId)
{
    NN_UNUSED(svcId);
}
#endif

void DpcHandler()
{
    DpcManager::DpcHandler();
}


#if defined NN_KERN_ENABLE_KTRACE
extern "C" void SvcEnterTrace(Bit32 *reg)
{
    NN_KERN_KTRACE_SVC_ENTER(GetCurrentThread().GetSvcNo(),
            reg[0], reg[1], reg[2], reg[3], reg[4], reg[5], reg[6], reg[7]);
    NN_KERN_KTRACE_BACKTRACE();
}

extern "C" void SvcLeaveTrace(Bit32 *reg)
{
    NN_KERN_KTRACE_SVC_LEAVE(GetCurrentThread().GetSvcNo(),
            reg[0], reg[1], reg[2], reg[3], reg[4], reg[5], reg[6], reg[7]);
}
#endif
        }
    }
}
