﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "../../kern_Platform.h"
#include "kern_KContext.h"
#include "../../kern_Kernel.h"
#include "../../kern_KThread.h"
#include "../../kern_KProcess.h"
#include "../../kern_KScheduler.h"
#include "kern_ExceptionContext.h"
#include "kern_UserContext.h"

namespace nn { namespace kern {
namespace ARM {

void GetUserContext(nn::svc::ThreadContext* pUserContext, const KThread* pThread)
{
    const ExceptionContext* pExcContext = GetExceptionContext(pThread);
    const KContext* pContext = pThread->GetContext();
    NN_KERN_ASSERT(KScheduler::IsSchedulerLocked());
    NN_KERN_ASSERT(pThread->IsSuspended());
    NN_KERN_ASSERT(pThread->GetParentPointer());

    for (size_t i = 0; i < 12; i++)
    {
        pUserContext->r[i] = static_cast<uint32_t>(pExcContext->r[i]);
    }
    pUserContext->sp =  static_cast<uint32_t>(pExcContext->sp_usr);
    pUserContext->lr =  static_cast<uint32_t>(pExcContext->lr_usr);
    pUserContext->pc =  static_cast<uint32_t>(pExcContext->pc);
    pUserContext->cpsr = (pExcContext->cpsr & HW_PSR_PL0_MASK);

    if (pThread->IsCallingSvc())
    {
        if (pExcContext->write == 0)
        {
            pUserContext->pc -= ((pExcContext->cpsr & HW_PSR_THUMB_STATE)? 2: 4);
        }
    }
    pUserContext->tpidr = pExcContext->tpidr;
    const Bit64 *fpr = pContext->GetVfpRegisters();
    for (size_t i = 0; i < pContext->GetNumOfVfpRegisters(); i++)
    {
        pUserContext->fpuRegisters[i] = fpr[i];
    }

    pUserContext->fpscr = pContext->GetFpscr();
    pUserContext->fpexc = 0;
}

uintptr_t GetUserStackPointer(const KThread* pThread)
{
    const ExceptionContext* pExcContext = GetExceptionContext(pThread);
    return static_cast<uint32_t>(pExcContext->sp_usr);
}
}
}}

