﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#endif

// マクロの展開で失敗するようなら展開してしまうこと
#define NN_KERN_CALC_END(name)      ((name) + (name ## _SIZE))
#define NN_KERN_CALC_SIZE(name)     ((name ## _END) - (name))
#define NN_KERN_CALC_HEAD(name)     ((name ## _END) - (name ## _SIZE))

#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ul
#endif

//---------------------------------------------------------------------------
// 物理アドレス

// CortexA9 プライベート領域
#define NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION       0x1E000000
#define NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION_SIZE  0x2000
#define NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION_END   NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION )

// MAIN_MEMORY
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY                   0x40000000
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_SIZE              0x20000000
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_END               NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY )
#define NN_KERN_DETAIL_P_ADDR_RESERVED_LO_SIZE              0x00000000
#define NN_KERN_DETAIL_P_ADDR_RESERVED_HI_SIZE              0x00000000

// PL310 (L2 Cache)
#define NN_KERN_DETAIL_P_ADDR_PL310_REGISTER                0x1E00A000
#define NN_KERN_DETAIL_P_ADDR_PL310_REGISTER_SIZE           0x1000
#define NN_KERN_DETAIL_P_ADDR_PL310_REGISTER_END            NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_PL310_REGISTER)

// UART1
#define NN_KERN_DETAIL_P_ADDR_UART1_REGISTER                0xE1030000
#define NN_KERN_DETAIL_P_ADDR_UART1_REGISTER_SIZE           0x1000
#define NN_KERN_DETAIL_P_ADDR_UART1_REGISTER_END            NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_UART1_REGISTER)

//---------------------------------------------------------------------------
// 仮想アドレス

// .........

// UART1
#define NN_KERN_DETAIL_V_ADDR_UART1_REGISTER            (NN_KERN_DETAIL_V_ADDR_UART1_REGISTER_END - NN_KERN_DETAIL_V_ADDR_UART1_REGISTER_SIZE)
#define NN_KERN_DETAIL_V_ADDR_UART1_REGISTER_SIZE       NN_KERN_DETAIL_P_ADDR_UART1_REGISTER_SIZE
#define NN_KERN_DETAIL_V_ADDR_UART1_REGISTER_END        (NN_KERN_DETAIL_V_ADDR_PL310_REGISTER - 0x1000)

// PL310 レジスタ
#define NN_KERN_DETAIL_V_ADDR_PL310_REGISTER            (NN_KERN_DETAIL_V_ADDR_PL310_REGISTER_END - NN_KERN_DETAIL_V_ADDR_PL310_REGISTER_SIZE)
#define NN_KERN_DETAIL_V_ADDR_PL310_REGISTER_SIZE       NN_KERN_DETAIL_P_ADDR_PL310_REGISTER_SIZE
#define NN_KERN_DETAIL_V_ADDR_PL310_REGISTER_END        NN_KERN_DETAIL_V_ADDR_IO_REGISTER_END
