﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#endif

#ifndef NN_KERN_CALC_END
#define NN_KERN_CALC_END(name)      ((name) + (name ## _SIZE))
#define NN_KERN_CALC_SIZE(name)     ((name ## _END) - (name))
#define NN_KERN_CALC_HEAD(name)     ((name ## _END) - (name ## _SIZE))
#endif

#ifndef NN_KERN_UL
#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ull
#endif
#endif

//---------------------------------------------------------------------------
// 物理アドレス
#define NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER               NN_KERN_UL(0x50041000)
#define NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER_SIZE          NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER_END           NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER)
#define NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE                 NN_KERN_UL(0x50042000)
#define NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE_SIZE            NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE_END             NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE)

// MAIN_MEMORY
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY                   NN_KERN_UL(0x80000000)
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_SIZE              NN_KERN_UL(0x200000000)
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_END               NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY)

#define NN_KERN_DETAIL_P_ADDR_RESERVED_LO_SIZE              NN_KERN_UL(0x00060000)
#define NN_KERN_DETAIL_P_ADDR_RESERVED_HI_SIZE              NN_KERN_UL(0x00000000)

#define NN_KERN_DETAIL_P_ADDR_UART0_REGISTER                NN_KERN_UL(0x70006000)
#define NN_KERN_DETAIL_P_ADDR_UART0_REGISTER_SIZE           NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_UART0_REGISTER_END            NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_UART0_REGISTER)

#define NN_KERN_DETAIL_P_ADDR_MC_REGISTER                   NN_KERN_UL(0x70019000)
#define NN_KERN_DETAIL_P_ADDR_MC_REGISTER_SIZE              NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_MC_REGISTER_END               NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_MC_REGISTER)

#define NN_KERN_DETAIL_P_ADDR_MC0_REGISTER                  NN_KERN_UL(0x7001c000)
#define NN_KERN_DETAIL_P_ADDR_MC0_REGISTER_SIZE             NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_MC0_REGISTER_END              NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_MC0_REGISTER)

#define NN_KERN_DETAIL_P_ADDR_MC1_REGISTER                  NN_KERN_UL(0x7001d000)
#define NN_KERN_DETAIL_P_ADDR_MC1_REGISTER_SIZE             NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_MC1_REGISTER_END              NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_MC1_REGISTER)

#define NN_KERN_DETAIL_P_ADDR_CLK_RST_REGISTER              NN_KERN_UL(0x60006000)
#define NN_KERN_DETAIL_P_ADDR_CLK_RST_REGISTER_SIZE         NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_CLK_RST_REGISTER_END          NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_CLK_RST_REGISTER)

#define NN_KERN_DETAIL_P_ADDR_RTC_PMC_REGISTER              NN_KERN_UL(0x7000E000)
#define NN_KERN_DETAIL_P_ADDR_RTC_PMC_REGISTER_SIZE         NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_RTC_PMC_REGISTER_END          NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_RTC_PMC_REGISTER)

#define NN_KERN_DETAIL_P_ADDR_PMC_REGISTER                  (NN_KERN_DETAIL_P_ADDR_RTC_PMC_REGISTER + 0x0400)
#define NN_KERN_DETAIL_P_ADDR_PMC_REGISTER_SIZE             NN_KERN_UL(0x0c00)
#define NN_KERN_DETAIL_P_ADDR_PMC_REGISTER_END              NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_PMC_REGISTER)


