﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Result.h>
#include <nnc/nn_Macro.h>

#define NN_RESULT_DETAIL_CONCATENATE_IMPL_( x, y ) x##y
#define NN_RESULT_DETAIL_CONCATENATE( x, y ) NN_RESULT_DETAIL_CONCATENATE_IMPL_( x, y )

// #define NN_DEFINE_ERROR_RANGE_RESULT_PREFIX

#define NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(name, module, descriptionBegin, descriptionEnd) \
    static NNC_INLINE bool NN_RESULT_DETAIL_CONCATENATE(NN_DEFINE_ERROR_RANGE_RESULT_PREFIX, name##Includes)(nnResult result) \
    { \
        int m = nnResultGetModule(result); \
        int d = nnResultGetDescription(result); \
        return m == module && descriptionBegin <= d && d < descriptionEnd; \
    }

#define NN_DEFINE_ERROR_RANGE_RESULT(name, module, descriptionBegin, descriptionEnd) \
    NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(name, module, descriptionBegin, descriptionEnd) \
    static NNC_INLINE nnResult NN_RESULT_DETAIL_CONCATENATE(NN_DEFINE_ERROR_RANGE_RESULT_PREFIX, Make##name)(void) \
    { \
        nnResult ret = { (module << nnResultModuleBitsOffset) | (descriptionBegin << nnResultDescriptionBitsOffset) }; \
        return ret; \
    }
