﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief  スレッドローカルストレージの C 言語用共通定義
 */

#pragma once

#include <nnc/nn_Common.h>

#include <nn/os/detail/os_TypesDefinition.h>

#if defined(NN_BUILD_FOR_DOCUMENT_GENERATION)
//--------------------------------------------------------------------------
/**
 * @brief   TLS のスロット番号を表す型です。
 */
typedef struct nnosTlsSlot
{
    // 詳細は割愛
    // 実体は NN_OS_DETAIL_DEFINE_ALIGNED_STORAGE により定義
} nnosTlsSlot;
#endif

NN_OS_DETAIL_DEFINE_ALIGNED_STORAGE(nnosTlsSlot, nn::os::TlsSlot, NN_OS_SIZEOF_TLS_SLOT, uint32_t);

//--------------------------------------------------------------------------
/**
 * @brief   TLS のデストラクタ関数を表す型です。
 */
typedef void    (*nnosTlsDestructor)(uintptr_t value);


//--------------------------------------------------------------------------
/**
 * @brief   TLS スロットの総数を示す定数です。
 */
#define NN_OS_TLS_SLOT_COUNT_MAX 16  // NOLINT(preprocessor/const)

//--------------------------------------------------------------------------
