﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief  スレッドローカルストレージに関する C 言語用 API の宣言
 */

#pragma once

#include <nnc/nn_Macro.h>
#include <nnc/nn_Result.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/os_ThreadLocalStorageCommon.h>
#include <nnc/os/detail/os_MacroImpl.h>

//--------------------------------------------------------------------------
//  C 向けの宣言
//--------------------------------------------------------------------------

//! @name スレッド固有領域関連 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   空き TLS スロットを確保します。
 *
 * @details
 *  詳細は nn::os::AllocateTlsSlot() を参照して下さい。
 *
 */
NN_OS_EXTERN_C nnResult  nnosAllocateTlsSlot(nnosTlsSlot* outTlsSlot, nnosTlsDestructor function);


//--------------------------------------------------------------------------
/**
 * @brief   TLS スロットを返却します。
 *
 * @details
 *  詳細は nn::os::FreeTlsSlot() を参照して下さい。
 *
 */
NN_OS_EXTERN_C void    nnosFreeTlsSlot(nnosTlsSlot tlsSlot);


//--------------------------------------------------------------------------
/**
 * @brief   指定された TLS スロットから値を取得します。
 *
 * @details
 *  詳細は nn::os::GetTlsValue() を参照して下さい。
 *
 */
NN_OS_EXTERN_C uintptr_t   nnosGetTlsValue(nnosTlsSlot tlsSlot);


//--------------------------------------------------------------------------
/**
 * @brief   指定された TLS スロットに値を設定します。
 *
 * @details
 *  詳細は nn::os::SetTlsValue() を参照して下さい。
 *
 */
NN_OS_EXTERN_C void    nnosSetTlsValue(nnosTlsSlot tlsSlot, uintptr_t value);


//--------------------------------------------------------------------------
/**
 * @brief   確保済みの TLS スロット数を取得します。
 *
 * @details
 *  詳細は nn::os::GetUsedTlsSlotCount() を参照して下さい。
 *
 */
NN_OS_EXTERN_C int     nnosGetUsedTlsSlotCount();

//! @}

//--------------------------------------------------------------------------
