﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   スレッドに関する C 言語用の共通定義
 */

#pragma once

#include <nnc/nn_Common.h>

//--------------------------------------------------------------------------
//  C 向けの宣言
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
/**
 * @brief   スレッド名の最大文字数を表す定数です。@n
 *          文字列終端の '\0' 文字を含んだ文字数です。
 */
#define NN_OS_THREAD_NAME_LENGTH_MAX        32  // NOLINT(readability/define)

//--------------------------------------------------------------------------
//  スレッドの優先度の範囲
#define NN_OS_THREAD_PRIORITY_RANGE_SIZE    32  // NOLINT(readability/define)

/**
 * @brief   スレッドの最高優先度を表す定数です。0 です。
 */
#define NN_OS_HIGHEST_THREAD_PRIORITY       0   // NOLINT(readability/define)

/**
 * @brief   スレッド優先度のデフォルト値を表す定数です。16 です。
 */
#define NN_OS_DEFAULT_THREAD_PRIORITY   \
        (NN_OS_THREAD_PRIORITY_RANGE_SIZE / 2)  // NOLINT(readability/define)

/**
 * @brief   スレッドの最低優先度を表す定数です。31 です。
 */
#define NN_OS_LOWEST_THREAD_PRIORITY    \
        (NN_OS_THREAD_PRIORITY_RANGE_SIZE - 1)  // NOLINT(readability/define)

#define NN_OS_INVALID_THREAD_PRIORITY      127  // NOLINT(readability/define)

//--------------------------------------------------------------------------
/**
 * @brief   ガード付きスタック領域のアライメント制約を表す定数です。
 */
#define NN_OS_GUARDED_STACK_ALIGNMENT   4096    // NOLINT(readability/define)

//--------------------------------------------------------------------------
/**
 * @brief   スレッドスタック領域のアライメント制約を表す定数です。
 */
#define NN_OS_THREAD_STACK_ALIGNMENT    4096    // NOLINT(readability/define)

//--------------------------------------------------------------------------
/**
 * @brief   スタック領域のアライメント制約を表す定数です。
 *
 * @deprecated
 *
 * @details
 *  この定数マクロは削除予定です。 NN_OS_THREAD_STACK_ALIGNMENT をご使用下さい。
 */
#define NN_OS_STACK_REGION_ALIGNMENT    4096    // NOLINT(readability/define)

//--------------------------------------------------------------------------
/**
 * @brief   スレッド関数のエントリを表す型です。
 */
typedef void    (*nnosThreadFunction)(void*);

