﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/result/result_ResultBase.h>

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct nnResult
{
    nnResultInnerType _value;
} nnResult;

int nnResultGetModule(nnResult result);
int nnResultGetDescription(nnResult result);
bool nnResultIsSuccess(nnResult result);
bool nnResultIsFailure(nnResult result);
nnResult nnResultSuccess(void); // NOLINT(readability/function)

#ifdef __cplusplus
}
#endif
