﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/nn_Result.h>

#include <nnc/dt/dt_Types.h>
#include <nnc/dt/dt_Api.h>

/**
 * @brief 指定されたノードが扱うレジスタ空間のアドレスを取得します。
 * @details 詳細は ::nn::dt::GetRegisterAddress() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterAddressInt32(int32_t * pOutAddress, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のアドレスを取得します。
 * @details 詳細は ::nn::dt::GetRegisterAddress() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterAddressUInt32(uint32_t * pOutAddress, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のアドレスの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterAddressArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterAddressArrayInt32(int32_t * pOutArray, int count, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のアドレスの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterAddressArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterAddressArrayUInt32(uint32_t * pOutArray, int count, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のアドレスの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterAddressList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterAddressListInt32(int32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のアドレスの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterAddressList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterAddressListUInt32(uint32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のサイズを取得します。
 * @details 詳細は ::nn::dt::GetRegisterSize() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterSizeInt32(int32_t * pOutSize, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のサイズを取得します。
 * @details 詳細は ::nn::dt::GetRegisterSize() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterSizeUInt32(uint32_t * pOutSize, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のサイズの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterSizeArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterSizeArrayInt32(int32_t * pOutArray, int count, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のサイズの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterSizeArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterSizeArrayUInt32(uint32_t * pOutArray, int count, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のサイズの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterSizeList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterSizeListInt32(int32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱うレジスタ空間のサイズの配列を取得します。
 * @details 詳細は ::nn::dt::GetRegisterSizeList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetRegisterSizeListUInt32(uint32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode);
