﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/nn_Result.h>

#include <nnc/dt/dt_Types.h>
#include <nnc/dt/dt_Api.h>

/**
 * @brief プロパティに格納されている int8_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyInt8(int8_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint8_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyUInt8(uint8_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int16_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyInt16(int16_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint16_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyUInt16(uint16_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int32_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyInt32(int32_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint32_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyUInt32(uint32_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int64_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyInt64(int64_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint64_t 型の値を取得します。
 * @details 詳細は ::nn::dt::GetProperty() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyUInt64(uint64_t * pOutValue, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int8_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayInt8(int8_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint8_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayUInt8(uint8_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int16_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayInt16(int16_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint16_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayUInt16(uint16_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int32_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayInt32(int32_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint32_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayUInt32(uint32_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int64_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayInt64(int64_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint64_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyArrayUInt64(uint64_t * pOutArray, int count, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int8_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListInt8(int8_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint8_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListUInt8(uint8_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている int16_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListInt16(int16_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint16_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListUInt16(uint16_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);
/**
 * @brief プロパティに格納されている int32_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListInt32(int32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint32_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListUInt32(uint32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);
/**
 * @brief プロパティに格納されている int64_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListInt64(int64_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている uint64_t 型の配列を取得します。
 * @details 詳細は ::nn::dt::GetPropertyList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyListUInt64(uint64_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name);
