﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>

namespace nn { namespace svc { namespace aarch32 {
struct ExceptionInfoAarch32Status32
{
    Bit32   cpsr;
    Bit32   fsr;
    Bit32   far;
    Bit32   fpexc;
    Bit32   fpinst;
    Bit32   fpinst2;
};
struct ExceptionInfoAarch32Status64
{
    Bit32   pstate;
    Bit32   afsr0;
    Bit32   afsr1;
    Bit32   esr;
    Bit32   far;
};

union ExceptionInfoAarch32Status
{
    ExceptionInfoAarch32Status32 on32;
    ExceptionInfoAarch32Status64 on64;
};

struct ExceptionInfo
{
    Bit32   r[8];
    Bit32   sp;
    Bit32   lr;
    Bit32   pc;
    Bit32   flags;
    ExceptionInfoAarch32Status status;
};

struct ProcessLocalRegion
{
    Bit32           work[94];
    ExceptionInfo   info;
    Bit64           dyingMessageRegionAddress;
    Bit64           dyingMessageRegionSize;
    Bit64           reserved[6];
};

NN_STATIC_ASSERT(sizeof(ProcessLocalRegion) == 512);

}}}

