﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_BitTypes.h>

namespace nn {
namespace svc {
    const int TLS_NUM = 16;

    struct ThreadLocalRegion
    {
        Bit32       messageBuffer[64];
#if defined NN_BUILD_CONFIG_ABI_LP64
        uintptr_t   reserved[16];
        struct
        {
            Bit64       threadId;
            uintptr_t   tls[TLS_NUM - 7];
            void*       _locale_ptr;
            int64_t     _errno_val;
            void*       thread_data;
            void*       eh_globals;
            uintptr_t   thread_pointer;
            uintptr_t   pThreadType;
        };
#else
        uintptr_t   reserved[48];
        struct
        {
            Bit64       threadId;
            uintptr_t   tls[TLS_NUM - 8];
            void*       _locale_ptr;
            int32_t     _errno_val;
            void*       thread_data;
            void*       eh_globals;
            uintptr_t   thread_pointer;
            uintptr_t   pThreadType;
        };
#endif
    };

    inline void StaticAssert()
    {
        static_assert( sizeof(ThreadLocalRegion) == 512, "" );
    }

    inline ThreadLocalRegion* GetThreadLocalRegion()
    {
        ThreadLocalRegion* p;
#if defined NN_BUILD_CONFIG_CPU_ARM64
        asm volatile("mrs  %0, tpidrro_el0": "=&r"(p)::"memory");
#else
        asm volatile("mrc  p15, 0, %0, c13, c0, 3": "=&r"(p)::"memory");
#endif
        return p;
    }

}   // end of namespace svc
}   // end of namespace nn

