﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_TcbType.h>

#ifdef __cplusplus

namespace nn {
namespace svc {
namespace aarch64 {
namespace lp64 {

    Result SetUnsafeLimit             (size_t limitSize);
    void   SleepSystem                ();
    Result GetSystemInfo              (nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param);
    Result CreatePort                 (nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name);
    Result ManageNamedPort            (nn::svc::Handle* pOutServer, const char name[], int32_t maxSessions);
    Result ConnectToPort              (nn::svc::Handle* pOut, nn::svc::Handle port);
    Result SetProcessMemoryPermission (nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission);
    Result MapProcessMemory           (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result UnmapProcessMemory         (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result QueryProcessMemory         (nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr);
    Result MapProcessCodeMemory       (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result UnmapProcessCodeMemory     (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result CreateProcess              (nn::svc::Handle* pOut, const nn::svc::lp64::CreateProcessParameter& params, const nn::Bit32 flags[], int32_t flagsNum);
    Result StartProcess               (nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize);
    Result TerminateProcess           (nn::svc::Handle process);
    Result GetProcessInfo             (int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type);
    Result CreateResourceLimit        (nn::svc::Handle* pOut);
    Result SetResourceLimitLimitValue (nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value);
    void   CallSecureMonitor          ();

} // end of namespace lp64
} // end of namespace aarch64
} // end of namespace svc
} // end of namespace nn

#endif  // ifdef __cplusplus

