﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>
namespace nn
{
    namespace svc
    {
#if defined (NN_BUILD_CONFIG_CPU_ARM64)
    #if defined (NN_BUILD_CONFIG_ABI_LP64)
        namespace lp64
        {
        }
        namespace aarch64
        {
            namespace lp64
            {
            }
        }

        using namespace ::nn::svc::lp64;
        using namespace ::nn::svc::aarch64;
        using namespace ::nn::svc::aarch64::lp64;
    #elif defined (NN_BUILD_CONFIG_ABI_ILP32)
        namespace lp64
        {
        }
        namespace aarch64
        {
            namespace ilp32
            {
            }
        }

        using namespace ::nn::svc::lp64;
        using namespace ::nn::svc::aarch64;
        using namespace ::nn::svc::aarch64::ilp32;
    #else
        #error not defined NN_BUILD_CONFIG_ABI
    #endif
#elif defined (NN_BUILD_CONFIG_CPU_ARM)
        namespace ilp32
        {
        }
        namespace aarch32
        {
        }

        using namespace ::nn::svc::ilp32;
        using namespace ::nn::svc::aarch32;
#else
#error not defined NN_BUILD_CONFIG_CPU
#endif
    }
}
