﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>

#if defined(NN_BUILD_CONFIG_CPU_ARM_V7A)
    #define NN_SVC_ADDR_MEMORY_REGION_SMALL32_SIZE      0x20000000ul
    #define NN_SVC_ADDR_MEMORY_REGION_LARGE32_SIZE      0x60000000ul
    #define NN_SVC_ADDR_MEMORY_REGION_HEAP32_SIZE       0x40000000ul
    #define NN_SVC_ADDR_MEMORY_REGION_RESERVED32_SIZE   0x20000000ul

    #define NN_SVC_ADDR_MEMORY_REGION_SMALL36_SIZE      0x0
    #define NN_SVC_ADDR_MEMORY_REGION_LARGE36_SIZE      0x0
    #define NN_SVC_ADDR_MEMORY_REGION_HEAP36_SIZE       0x0
    #define NN_SVC_ADDR_MEMORY_REGION_RESERVED36_SIZE   0x0

    #define NN_SVC_ADDR_MEMORY_REGION_SMALL39_SIZE      0x0
    #define NN_SVC_ADDR_MEMORY_REGION_STACK39_SIZE      0x0
    #define NN_SVC_ADDR_MEMORY_REGION_HEAP39_SIZE       0x0
    #define NN_SVC_ADDR_MEMORY_REGION_RESERVED39_SIZE   0x0

#elif defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
    #define NN_SVC_ADDR_MEMORY_REGION_SMALL32_SIZE      0x40000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_LARGE32_SIZE      0xC0000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_HEAP32_SIZE       0x40000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_RESERVED32_SIZE   0x40000000ull

    #define NN_SVC_ADDR_MEMORY_REGION_SMALL36_SIZE      0x080000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_LARGE36_SIZE      0xF80000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_HEAP36_SIZE       0x180000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_RESERVED36_SIZE   0x180000000ull

    #define NN_SVC_ADDR_MEMORY_REGION_SMALL39_SIZE      0x1000000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_STACK39_SIZE      0x080000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_HEAP39_SIZE       0x180000000ull
    #define NN_SVC_ADDR_MEMORY_REGION_RESERVED39_SIZE   0x1000000000ull
#else
    #error not defined NN_BUILD_CONFIG_CPU_
#endif

#if defined NN_BUILD_CONFIG_SPEC_NX
#define NN_SVC_ADDR_NULL_GUARD32_SIZE               0x00200000ul
#define NN_SVC_ADDR_NULL_GUARD64_SIZE               0x08000000ul
#else
#define NN_SVC_ADDR_NULL_GUARD32_SIZE               0x00200000ul
#define NN_SVC_ADDR_NULL_GUARD64_SIZE               0x00200000ul
#endif


// 32bit address process
#define NN_SVC_ADDR_MEMORY_REGION_SMALL32_BEGIN     0x00000000ul
#define NN_SVC_ADDR_MEMORY_REGION_SMALL32_END       (NN_SVC_ADDR_MEMORY_REGION_SMALL32_BEGIN + NN_SVC_ADDR_MEMORY_REGION_SMALL32_SIZE)
#define NN_SVC_ADDR_MEMORY_REGION_LARGE32_BEGIN     NN_SVC_ADDR_MEMORY_REGION_SMALL32_END
#define NN_SVC_ADDR_MEMORY_REGION_LARGE32_END       (NN_SVC_ADDR_MEMORY_REGION_LARGE32_BEGIN + NN_SVC_ADDR_MEMORY_REGION_LARGE32_SIZE)

#define NN_SVC_ADDR_SMALL_MAP32_BEGIN               (NN_SVC_ADDR_MEMORY_REGION_SMALL32_BEGIN + NN_SVC_ADDR_NULL_GUARD32_SIZE)
#define NN_SVC_ADDR_SMALL_MAP32_SIZE                (NN_SVC_ADDR_SMALL_MAP32_END - NN_SVC_ADDR_SMALL_MAP32_BEGIN)
#define NN_SVC_ADDR_SMALL_MAP32_END                 NN_SVC_ADDR_MEMORY_REGION_SMALL32_END

#define NN_SVC_ADDR_LARGE_MAP32_BEGIN               NN_SVC_ADDR_MEMORY_REGION_LARGE32_BEGIN
#define NN_SVC_ADDR_LARGE_MAP32_SIZE                (NN_SVC_ADDR_LARGE_MAP32_END - NN_SVC_ADDR_LARGE_MAP32_BEGIN)
#define NN_SVC_ADDR_LARGE_MAP32_END                 NN_SVC_ADDR_MEMORY_REGION_LARGE32_END

// 64bit address process(64GB)
#define NN_SVC_ADDR_MEMORY_REGION_SMALL36_BEGIN     0x00000000ul
#define NN_SVC_ADDR_MEMORY_REGION_SMALL36_END       (NN_SVC_ADDR_MEMORY_REGION_SMALL36_BEGIN + NN_SVC_ADDR_MEMORY_REGION_SMALL36_SIZE)
#define NN_SVC_ADDR_MEMORY_REGION_LARGE36_BEGIN     NN_SVC_ADDR_MEMORY_REGION_SMALL36_END
#define NN_SVC_ADDR_MEMORY_REGION_LARGE36_END       (NN_SVC_ADDR_MEMORY_REGION_LARGE36_BEGIN + NN_SVC_ADDR_MEMORY_REGION_LARGE36_SIZE)

#define NN_SVC_ADDR_SMALL_MAP36_BEGIN               (NN_SVC_ADDR_MEMORY_REGION_SMALL36_BEGIN + NN_SVC_ADDR_NULL_GUARD64_SIZE)
#define NN_SVC_ADDR_SMALL_MAP36_SIZE                (NN_SVC_ADDR_SMALL_MAP36_END - NN_SVC_ADDR_SMALL_MAP36_BEGIN)
#define NN_SVC_ADDR_SMALL_MAP36_END                 NN_SVC_ADDR_MEMORY_REGION_SMALL36_END

#define NN_SVC_ADDR_LARGE_MAP36_BEGIN               NN_SVC_ADDR_MEMORY_REGION_LARGE36_BEGIN
#define NN_SVC_ADDR_LARGE_MAP36_SIZE                (NN_SVC_ADDR_LARGE_MAP36_END - NN_SVC_ADDR_LARGE_MAP36_BEGIN)
#define NN_SVC_ADDR_LARGE_MAP36_END                 NN_SVC_ADDR_MEMORY_REGION_LARGE36_END


// 64bit address process(512GB)
#define NN_SVC_ADDR_MAP39_BEGIN               (0ull + NN_SVC_ADDR_NULL_GUARD64_SIZE)
#define NN_SVC_ADDR_MAP39_SIZE                (NN_SVC_ADDR_MAP39_END - NN_SVC_ADDR_MAP39_BEGIN)
#define NN_SVC_ADDR_MAP39_END                 (1ull << 39)

