﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#ifdef NN_PLATFORM_WIN32
    typedef void *HANDLE;
#endif

    //-------------------------------------------------------------------
// for C / C++

#ifdef __cplusplus
extern "C" {
#endif  // ifdef __cplusplus

    typedef struct nnHandle
    {
        uint32_t   value;
    }
    nnHandle;

    extern const nnHandle NN_INVALID_HANDLE_VALUE;

#ifdef __cplusplus
}
#endif  // ifdef __cplusplus



//-------------------------------------------------------------------
// for C++

#ifdef __cplusplus

namespace nn { namespace svc {

    class HandleImpl
    {
    public:
        HandleImpl() : m_Handle(0)
        {
        }

        NN_IMPLICIT HandleImpl(nnHandle handle) : m_Handle(handle.value)
        {
        }
        struct WithoutInitialize
        {
        };
        NN_IMPLICIT HandleImpl(const WithoutInitialize& dummy)
        {
            NN_UNUSED(dummy);
        }

        explicit HandleImpl(uint32_t handle)
        {
            m_Handle = handle;
        }

        bool IsValid() const
        {
            return m_Handle != 0;
        }

    #if ! defined(NN_SWITCH_DISABLE_DEBUG_PRINT) || ! defined(NN_SWITCH_DISABLE_DEBUG_PRINT_FOR_SDK)
        uint32_t GetPrintableBits() const
        {
            return m_Handle;
        }
    #endif

        bool operator ==(const HandleImpl& rhs) const { return this->m_Handle == rhs.m_Handle; }
        bool operator !=(const HandleImpl& rhs) const { return this->m_Handle != rhs.m_Handle; }
        NN_EXPLICIT_OPERATOR nnHandle() const
        {
            nnHandle handle = { this->m_Handle};
            return handle;
        }

        // TORIAEZU
#ifdef NN_PLATFORM_WIN32
        void Set(HANDLE pHandle)
        {
            m_Handle = reinterpret_cast<uint32_t>(pHandle);
        }
        HANDLE Get()
        {
            return reinterpret_cast<HANDLE>(m_Handle);
        }
#endif

    private:
        uint32_t m_Handle;
    };

    class Handle : public HandleImpl
    {
    public:
        Handle() : HandleImpl() {}
        NN_IMPLICIT Handle(nnHandle handle) : HandleImpl(handle) {}
        explicit Handle(uint32_t handle) : HandleImpl(handle) {}
        NN_IMPLICIT Handle(const WithoutInitialize& dummy) : HandleImpl(dummy) {}
        enum
        {
            WaitMask = 1u << 30
        };
    };

    const int ArgumentHandleCountMax = 64;

    namespace
    {
        const nnHandle PSEUDO_HANDLE_CURRENT_THREAD  = {0xFFFF8000};
        const nnHandle PSEUDO_HANDLE_CURRENT_PROCESS = {0xFFFF8001};
#ifndef NN_PLATFORM_WIN32
        const nnHandle INVALID_HANDLE_VALUE = {0};
#else
        const nnHandle NN_HANDLE_INVALID_VALUE = {0}; // windows には上記名で定義があるので別名を付ける
#endif
    }
}}
#endif  // ifdef __cplusplus

