﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_DmntType.h>

#ifdef __cplusplus

namespace nn {
namespace svc {
namespace ilp32 {

    struct DebugInfoCreateProcess
    {
        ProgramId programId;
        Bit64     processId;
        char      programName[12];
        Bit32     flag;
        UIntPtr32 processRegionAddress;
    };

    struct DebugInfoCreateThread
    {
        Bit64     id;
        UIntPtr32 localRegionBaseAddress;
        UIntPtr32 entryAddress;
    };

    struct DebugInfoExitProcess
    {
        ProcessExitReason exitReason;
    };

    struct DebugInfoExitThread
    {
        ThreadExitReason exitReason;
    };

    struct DebugInfoExceptionAccessViolationData
    {
        UIntPtr32 faultAddress;
    };

    struct DebugInfoExceptionDataTypeMissaligned
    {
        UIntPtr32 faultAddress;
    };

    struct DebugInfoExceptionBreakPoint
    {
        BreakPointType type;
        UIntPtr32      dataAddress;
    };

    struct DebugInfoExceptionUserBreak
    {
        BreakReason reason;
        UIntPtr32   data;
        Size32      size;
    };

    struct DebugInfoExceptionDebuggerBreak
    {
        Bit64 currentThreadId[4];
    };

    struct DebugInfoExceptionUndefinedInstruction
    {
        int32_t code;
    };

    struct DebugInfoExceptionUndefinedSystemCall
    {
        int32_t svcId;
    };

    union DebugInfoExceptionDetail
    {
        DebugInfoExceptionAccessViolationData  accessViolationData;
        DebugInfoExceptionDataTypeMissaligned  dataTypeMissaligned;
        DebugInfoExceptionBreakPoint           breakPoint;
        DebugInfoExceptionUserBreak            userBreak;
        DebugInfoExceptionDebuggerBreak        debuggerBreak;
        DebugInfoExceptionUndefinedInstruction undefinedInstruction;
        DebugInfoExceptionUndefinedSystemCall  undefinedSystemCall;
    };

    struct DebugInfoException
    {
        DebugException           exceptionCode;
        UIntPtr32                exceptionAddress;
        DebugInfoExceptionDetail detail;
    };

    union DebugInfo
    {
        DebugInfoCreateProcess createProcess;
        DebugInfoCreateThread  createThread;
        DebugInfoExitProcess   exitProcess;
        DebugInfoExitThread    exitThread;
        DebugInfoException     exception;
    };

    struct DebugEventInfo
    {
        DebugEvent event;
        Bit32      flags;
        Bit64      threadId;
        DebugInfo  info;
    };

} // end of namespace ilp32
} // end of namespace svc
} // end of namespace nn

#endif  // ifdef __cplusplus

