﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_DdType.h>

#ifdef __cplusplus

namespace nn {
namespace svc {
namespace aarch32 {

    Result CreateSharedMemory           (nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission);
    Result MapTransferMemory            (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission);
    Result UnmapTransferMemory          (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result CreateInterruptEvent         (nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type);
    Result QueryPhysicalAddress         (nn::svc::ilp32::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr);
    Result QueryIoMapping               (uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size);
    Result CreateDeviceAddressSpace     (nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize);
    Result AttachDeviceAddressSpace     (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result DetachDeviceAddressSpace     (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result MapDeviceAddressSpaceByForce (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result MapDeviceAddressSpaceAligned (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result MapDeviceAddressSpace        (size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result UnmapDeviceAddressSpace      (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress);
    Result InvalidateProcessDataCache   (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result StoreProcessDataCache        (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result FlushProcessDataCache        (nn::svc::Handle process, uint64_t addr, uint64_t size);

} // end of namespace aarch32
} // end of namespace svc
} // end of namespace nn

#endif  // ifdef __cplusplus

