﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/spl/spl_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace spl { namespace detail { // NOLINT(whitespace/braces)

class IGeneralInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IGeneralInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IGeneralInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetConfig, (::nn::sf::Out<::nn::Bit64> pOut, ::std::int32_t key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ModularExponentiate, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& baseValue, const ::nn::sf::InArray<::nn::Bit8>& exponent, const ::nn::sf::InArray<::nn::Bit8>& modulus))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetConfig, (::std::int32_t key, ::nn::Bit64 value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateRandomBytes, (const ::nn::sf::OutArray<::nn::Bit8>& result))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsDevelopment, (::nn::sf::Out<bool> isDevelopment))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetBootReason, (::nn::spl::BootReasonValue bootReason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBootReason, (::nn::sf::Out<::nn::spl::BootReasonValue> bootReason))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IGeneralInterface)

        ::nn::Result GetConfig(::nn::sf::Out<::nn::Bit64> pOut, ::std::int32_t key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetConfig, (pOut, key));
        }

        ::nn::Result ModularExponentiate(const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& baseValue, const ::nn::sf::InArray<::nn::Bit8>& exponent, const ::nn::sf::InArray<::nn::Bit8>& modulus) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ModularExponentiate, (result, baseValue, exponent, modulus));
        }

        ::nn::Result SetConfig(::std::int32_t key, ::nn::Bit64 value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetConfig, (key, value));
        }

        ::nn::Result GenerateRandomBytes(const ::nn::sf::OutArray<::nn::Bit8>& result) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateRandomBytes, (result));
        }

        ::nn::Result IsDevelopment(::nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsDevelopment, (isDevelopment));
        }

        ::nn::Result SetBootReason(::nn::spl::BootReasonValue bootReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetBootReason, (bootReason));
        }

        ::nn::Result GetBootReason(::nn::sf::Out<::nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBootReason, (bootReason));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IGeneralInterface
    {
    public:
        nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT;
        nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
        nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT;
        nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
        nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT;
        nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT;
        nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT;
    nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
    nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT;
    nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
    nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT;
    nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT;
    nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::spl::detail::IGeneralInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConfig, (::nn::sf::Out<::nn::Bit64> pOut, ::std::int32_t key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetConfig, (pOut, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ModularExponentiate, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& baseValue, const ::nn::sf::InArray<::nn::Bit8>& exponent, const ::nn::sf::InArray<::nn::Bit8>& modulus))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ModularExponentiate, (result, baseValue, exponent, modulus));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetConfig, (::std::int32_t key, ::nn::Bit64 value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetConfig, (key, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateRandomBytes, (const ::nn::sf::OutArray<::nn::Bit8>& result))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateRandomBytes, (result));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsDevelopment, (::nn::sf::Out<bool> isDevelopment))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsDevelopment, (isDevelopment));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBootReason, (::nn::spl::BootReasonValue bootReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetBootReason, (bootReason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBootReason, (::nn::sf::Out<::nn::spl::BootReasonValue> bootReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBootReason, (bootReason));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::spl::detail::IGeneralInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::spl::detail::IGeneralInterface))

    // nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetConfig)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetConfig)

    // nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ModularExponentiate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(result, 0, (const ::nn::sf::OutArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(baseValue, 1, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(exponent, 2, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(modulus, 3, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (result, baseValue, exponent, modulus))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(baseValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(exponent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(modulus)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ModularExponentiate)

    // nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetConfig)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (key, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetConfig)

    // nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateRandomBytes)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(result, 0, (const ::nn::sf::OutArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (result))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateRandomBytes)

    // nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsDevelopment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isDevelopment, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isDevelopment))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isDevelopment)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsDevelopment)

    // nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBootReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bootReason, (::nn::spl::BootReasonValue), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bootReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bootReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBootReason)

    // nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBootReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(bootReason, (::nn::spl::BootReasonValue), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (bootReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bootReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBootReason)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::BootReasonValue), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::spl::detail::IGeneralInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::spl::detail::IGeneralInterface))

    // nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConfig, (::nn::sf::Out<::nn::Bit64> pOut, ::std::int32_t key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetConfig)
    }

    // nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ModularExponentiate, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& baseValue, const ::nn::sf::InArray<::nn::Bit8>& exponent, const ::nn::sf::InArray<::nn::Bit8>& modulus))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ModularExponentiate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(baseValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(exponent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(modulus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ModularExponentiate)
    }

    // nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetConfig, (::std::int32_t key, ::nn::Bit64 value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetConfig)
    }

    // nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateRandomBytes, (const ::nn::sf::OutArray<::nn::Bit8>& result))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateRandomBytes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateRandomBytes)
    }

    // nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsDevelopment, (::nn::sf::Out<bool> isDevelopment))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsDevelopment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isDevelopment)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsDevelopment)
    }

    // nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBootReason, (::nn::spl::BootReasonValue bootReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBootReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bootReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBootReason)
    }

    // nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBootReason, (::nn::sf::Out<::nn::spl::BootReasonValue> bootReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBootReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bootReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBootReason)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::spl::detail::IGeneralInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::spl::detail::IGeneralInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetConfig)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ModularExponentiate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(result)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(baseValue)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(exponent)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(modulus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ModularExponentiate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(result),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(baseValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(exponent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(modulus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetConfig)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateRandomBytes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(result)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateRandomBytes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(result)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsDevelopment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsDevelopment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isDevelopment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBootReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBootReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bootReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBootReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBootReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(bootReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ModularExponentiate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateRandomBytes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsDevelopment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBootReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBootReason)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::spl::detail::IGeneralInterface))
