﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/spl/detail/spl_InternalTypes.h>
#include <nn/spl/spl_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace spl { namespace detail { // NOLINT(whitespace/braces)

class IEsInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IEsInterface, (::nn::spl::detail::IDeviceUniqueDataInterface))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IEsInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadEsDeviceKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrepareEsTitleKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrepareCommonEsTitleKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAndStoreDrmDeviceCertKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ModularExponentiateWithDrmDeviceCertKey, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrepareEsArchiveKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IEsInterface)

        ::nn::Result LoadEsDeviceKey(const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadEsDeviceKey, (data, accessKey, keySource));
        }

        ::nn::Result PrepareEsTitleKey(::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrepareEsTitleKey, (accessKey, cipher, modulus, labelDigest, generation));
        }

        ::nn::Result PrepareCommonEsTitleKey(::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrepareCommonEsTitleKey, (accessKey, keySource, generation));
        }

        ::nn::Result DecryptAndStoreDrmDeviceCertKey(const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecryptAndStoreDrmDeviceCertKey, (data, accessKey, keySource));
        }

        ::nn::Result ModularExponentiateWithDrmDeviceCertKey(const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ModularExponentiateWithDrmDeviceCertKey, (result, cipher, modulus));
        }

        ::nn::Result PrepareEsArchiveKey(::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrepareEsArchiveKey, (accessKey, cipher, modulus, labelDigest, generation));
        }

        ::nn::Result LoadPreparedAesKey(::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (slotIndex, accessKey));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IEsInterface : public ::nn::spl::detail::IDeviceUniqueDataInterface
    {
    public:
        nn::Result LoadEsDeviceKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
        nn::Result PrepareEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT;
        nn::Result PrepareCommonEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation) NN_NOEXCEPT;
        nn::Result DecryptAndStoreDrmDeviceCertKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
        nn::Result ModularExponentiateWithDrmDeviceCertKey(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
        nn::Result PrepareEsArchiveKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT;
        nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT;
    nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
    nn::Result GenerateAesKek(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result LoadAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result GenerateAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT;
    nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
    nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT;
    nn::Result DecryptDeviceUniqueData(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result DecryptAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result ComputeCtr(const nn::sf::OutBuffer& outBuffer, std::int32_t slotIndex, const nn::sf::InBuffer& inBuffer, const nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT;
    nn::Result ComputeCmac(nn::sf::Out<nn::spl::detail::Cmac> pOut, std::int32_t slotIndex, const nn::sf::InArray<nn::Bit8>& data) NN_NOEXCEPT;
    nn::Result LoadEsDeviceKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result PrepareEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT;
    nn::Result PrepareCommonEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation) NN_NOEXCEPT;
    nn::Result AllocateAesKeySlot(nn::sf::Out<std::int32_t> slotIndex) NN_NOEXCEPT;
    nn::Result DeallocateAesKeySlot(std::int32_t slotIndex) NN_NOEXCEPT;
    nn::Result GetAesKeySlotAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT;
    nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT;
    nn::Result DecryptAndStoreDrmDeviceCertKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result ModularExponentiateWithDrmDeviceCertKey(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
    nn::Result PrepareEsArchiveKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT;
    nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::spl::detail::IEsInterface), (::nn::spl::detail::IDeviceUniqueDataInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadEsDeviceKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadEsDeviceKey, (data, accessKey, keySource));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareEsTitleKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrepareEsTitleKey, (accessKey, cipher, modulus, labelDigest, generation));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareCommonEsTitleKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrepareCommonEsTitleKey, (accessKey, keySource, generation));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAndStoreDrmDeviceCertKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecryptAndStoreDrmDeviceCertKey, (data, accessKey, keySource));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ModularExponentiateWithDrmDeviceCertKey, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ModularExponentiateWithDrmDeviceCertKey, (result, cipher, modulus));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareEsArchiveKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrepareEsArchiveKey, (accessKey, cipher, modulus, labelDigest, generation));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadPreparedAesKey, (slotIndex, accessKey));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::spl::detail::IEsInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::spl::detail::IEsInterface), (::nn::spl::detail::IDeviceUniqueDataInterface))

    // nn::Result LoadEsDeviceKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadEsDeviceKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (accessKey, keySource))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadEsDeviceKey)

    // nn::Result PrepareEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareEsTitleKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(cipher, 0, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(modulus, 1, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(labelDigest, 2, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (cipher, modulus, labelDigest))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(generation, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (generation))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (accessKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cipher), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(modulus), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(labelDigest), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(generation)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareEsTitleKey)

    // nn::Result PrepareCommonEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareCommonEsTitleKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(generation, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (keySource, generation))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (accessKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(generation)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareCommonEsTitleKey)

    // nn::Result DecryptAndStoreDrmDeviceCertKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecryptAndStoreDrmDeviceCertKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (accessKey, keySource))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecryptAndStoreDrmDeviceCertKey)

    // nn::Result ModularExponentiateWithDrmDeviceCertKey(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ModularExponentiateWithDrmDeviceCertKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(result, 0, (const ::nn::sf::OutArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(cipher, 1, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(modulus, 2, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (result, cipher, modulus))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cipher), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(modulus)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ModularExponentiateWithDrmDeviceCertKey)

    // nn::Result PrepareEsArchiveKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareEsArchiveKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(cipher, 0, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(modulus, 1, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(labelDigest, 2, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (cipher, modulus, labelDigest))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(generation, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (generation))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (accessKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cipher), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(modulus), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(labelDigest), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(generation)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareEsArchiveKey)

    // nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadPreparedAesKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slotIndex, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (accessKey, slotIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slotIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadPreparedAesKey)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::AccessKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::KeySource), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::AesKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::IvIc), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::Cmac), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::BootReasonValue), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::spl::detail::IEsInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::spl::detail::IEsInterface), (::nn::spl::detail::IDeviceUniqueDataInterface))

    // nn::Result LoadEsDeviceKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadEsDeviceKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadEsDeviceKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadEsDeviceKey)
    }

    // nn::Result PrepareEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareEsTitleKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareEsTitleKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cipher)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(modulus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(labelDigest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(generation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareEsTitleKey)
    }

    // nn::Result PrepareCommonEsTitleKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareCommonEsTitleKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareCommonEsTitleKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(generation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareCommonEsTitleKey)
    }

    // nn::Result DecryptAndStoreDrmDeviceCertKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAndStoreDrmDeviceCertKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecryptAndStoreDrmDeviceCertKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecryptAndStoreDrmDeviceCertKey)
    }

    // nn::Result ModularExponentiateWithDrmDeviceCertKey(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ModularExponentiateWithDrmDeviceCertKey, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ModularExponentiateWithDrmDeviceCertKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cipher)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(modulus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ModularExponentiateWithDrmDeviceCertKey)
    }

    // nn::Result PrepareEsArchiveKey(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest, std::int32_t generation) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareEsArchiveKey, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest, ::std::int32_t generation))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareEsArchiveKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cipher)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(modulus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(labelDigest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(generation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareEsArchiveKey)
    }

    // nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadPreparedAesKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slotIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadPreparedAesKey)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::spl::detail::IEsInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::spl::detail::IEsInterface), (::nn::spl::detail::IDeviceUniqueDataInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadEsDeviceKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadEsDeviceKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareEsTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(cipher)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(modulus)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(labelDigest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareEsTitleKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(cipher),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(modulus),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(labelDigest),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(generation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareCommonEsTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareCommonEsTitleKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(generation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecryptAndStoreDrmDeviceCertKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecryptAndStoreDrmDeviceCertKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ModularExponentiateWithDrmDeviceCertKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(result)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(cipher)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(modulus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ModularExponentiateWithDrmDeviceCertKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(result),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(cipher),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(modulus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareEsArchiveKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(cipher)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(modulus)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(labelDigest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareEsArchiveKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(cipher),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(modulus),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(labelDigest),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(generation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadPreparedAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadPreparedAesKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slotIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadEsDeviceKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareEsTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareCommonEsTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecryptAndStoreDrmDeviceCertKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ModularExponentiateWithDrmDeviceCertKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareEsArchiveKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadPreparedAesKey)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::spl::detail::IEsInterface))
