﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn     {
namespace socket {


const uint32_t DefaultStatisticsBufferSize = 2 * 1024;

enum StatisticsType
{
    StatisticsType_Default = 0,
    StatisticsType_Memory  = 1
};

enum StatisticsOption
{
    StatisticsOption_None              = 0x0,
    StatisticsOption_BsdSocketProcess  = 0x1    // statistics for BSD socket process instead of client
};

struct ResourceStatistics
{
    uint64_t pid;
    int      descriptorCount;
    uint64_t transferMemoryPoolTotalSize;
    uint64_t transferMemoryPoolTotalFreeSize;
    uint64_t transferMemoryPoolAllocatableSize;
};


}}

