﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace socket { namespace sf { // NOLINT(whitespace/braces)

class IClient;

struct Iovec;

struct LibraryConfigData;

struct MsgHdr;

struct SelectTimeval;

struct Timespec;

struct LibraryConfigData
{
    std::uint32_t version;
    std::uint32_t tcpInitialSendBufferSize;
    std::uint32_t tcpInitialReceiveBufferSize;
    std::uint32_t tcpAutoSendBufferSizeMax;
    std::uint32_t tcpAutoReceiveBufferSizeMax;
    std::uint32_t udpSendBufferSize;
    std::uint32_t udpReceiveBufferSize;
    std::int32_t socketBufferEfficiency;
};

struct Iovec
{
    std::int64_t iov_base;
    std::int64_t iov_len;
};

struct MsgHdr
{
    std::uint64_t msg_name;
    std::uint64_t msg_namelen;
    nn::socket::sf::Iovec msg_iov[2];
    std::uint64_t msg_iovlen;
    std::uint64_t msg_control;
    std::uint64_t msg_controllen;
    std::int64_t msg_flags;
};

struct SelectTimeval
{
    std::int64_t sec;
    std::int64_t usec;
    bool wasNull;
};

struct Timespec
{
    std::int64_t sec;
    std::int64_t nsec;
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IClient, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IClient)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterClient, (::nn::sf::Out<int> pOutRet, ::nn::Bit64 pid, ::nn::sf::NativeHandle&& memoryHandle, ::std::uint64_t memorySize, const ::nn::socket::sf::LibraryConfigData& configData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartMonitoring, (::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Socket, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SocketExempt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Open, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& path, int flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Select, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int numberOfDescriptors, const ::nn::sf::InBuffer& inReadDescriptors, const ::nn::sf::InBuffer& inWriteDescriptors, const ::nn::sf::InBuffer& inExceptDescriptors, const ::nn::sf::OutBuffer& outReadDescriptors, const ::nn::sf::OutBuffer& outWriteDescriptors, const ::nn::sf::OutBuffer& outExceptDescriptors, const ::nn::socket::sf::SelectTimeval& timeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Poll, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& inDescriptors, const ::nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Sysctl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& mib, const ::nn::sf::OutBuffer& outValue, ::nn::sf::Out<unsigned int> pOutValueLength, const ::nn::sf::InBuffer& inValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RecvFrom, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendTo, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags, const ::nn::sf::InBuffer& inAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPeerName, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSockName, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSockOpt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::OutBuffer& pOutOptionValue, ::nn::sf::Out<unsigned int> pOutOptionLength))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int backlog))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Ioctl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::std::uint32_t command, const ::nn::sf::InBuffer& dataInSlot0, const ::nn::sf::InBuffer& dataInSlot1, const ::nn::sf::InBuffer& dataInSlot2, const ::nn::sf::InBuffer& dataInSlot3, const ::nn::sf::OutBuffer& dataOutSlot0, const ::nn::sf::OutBuffer& dataOutSlot1, const ::nn::sf::OutBuffer& dataOutSlot2, const ::nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int command, int iocmd))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSockOpt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::InBuffer& inOptionValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int how))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ShutdownAllSockets, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int forced))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Write, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DuplicateSocket, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::nn::Bit64 ownerProcessId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetResourceStatistics, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, ::nn::Bit64 pid, int type, const ::nn::sf::OutBuffer& outBuffer, unsigned int options))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RecvMMsg, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const ::nn::socket::sf::Timespec& timeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendMMsg, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InArray<::nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const ::nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IClient)

        ::nn::Result RegisterClient(::nn::sf::Out<int> pOutRet, ::nn::Bit64 pid, ::nn::sf::NativeHandle&& memoryHandle, ::std::uint64_t memorySize, const ::nn::socket::sf::LibraryConfigData& configData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterClient, (pOutRet, pid, ::std::move(memoryHandle), memorySize, configData));
        }

        ::nn::Result StartMonitoring(::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartMonitoring, (pid));
        }

        ::nn::Result Socket(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Socket, (pOutRet, pOutError, domain, type, protocol));
        }

        ::nn::Result SocketExempt(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SocketExempt, (pOutRet, pOutError, domain, type, protocol));
        }

        ::nn::Result Open(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& path, int flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Open, (pOutRet, pOutError, path, flags));
        }

        ::nn::Result Select(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int numberOfDescriptors, const ::nn::sf::InBuffer& inReadDescriptors, const ::nn::sf::InBuffer& inWriteDescriptors, const ::nn::sf::InBuffer& inExceptDescriptors, const ::nn::sf::OutBuffer& outReadDescriptors, const ::nn::sf::OutBuffer& outWriteDescriptors, const ::nn::sf::OutBuffer& outExceptDescriptors, const ::nn::socket::sf::SelectTimeval& timeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Select, (pOutRet, pOutError, numberOfDescriptors, inReadDescriptors, inWriteDescriptors, inExceptDescriptors, outReadDescriptors, outWriteDescriptors, outExceptDescriptors, timeout));
        }

        ::nn::Result Poll(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& inDescriptors, const ::nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Poll, (pOutRet, pOutError, inDescriptors, outDescriptors, numberOfDescriptors, timeoutMilliseconds));
        }

        ::nn::Result Sysctl(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& mib, const ::nn::sf::OutBuffer& outValue, ::nn::sf::Out<unsigned int> pOutValueLength, const ::nn::sf::InBuffer& inValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Sysctl, (pOutRet, pOutError, mib, outValue, pOutValueLength, inValue));
        }

        ::nn::Result Recv(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Recv, (pOutRet, pOutError, sock, outBuffer, flags));
        }

        ::nn::Result RecvFrom(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RecvFrom, (pOutRet, pOutError, sock, outBuffer, flags, pOutAddress, pOutAddressLength));
        }

        ::nn::Result Send(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Send, (pOutRet, pOutError, sock, inBuffer, flags));
        }

        ::nn::Result SendTo(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags, const ::nn::sf::InBuffer& inAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendTo, (pOutRet, pOutError, sock, inBuffer, flags, inAddress));
        }

        ::nn::Result Accept(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Accept, (pOutRet, pOutError, sock, pOutAddress, pOutAddressLength));
        }

        ::nn::Result Bind(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Bind, (pOutRet, pOutError, sock, inAddress));
        }

        ::nn::Result Connect(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Connect, (pOutRet, pOutError, sock, inAddress));
        }

        ::nn::Result GetPeerName(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPeerName, (pOutRet, pOutError, sock, pOutAddress, pOutAddressLength));
        }

        ::nn::Result GetSockName(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSockName, (pOutRet, pOutError, sock, pOutAddress, pOutAddressLength));
        }

        ::nn::Result GetSockOpt(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::OutBuffer& pOutOptionValue, ::nn::sf::Out<unsigned int> pOutOptionLength) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSockOpt, (pOutRet, pOutError, sock, level, optionName, pOutOptionValue, pOutOptionLength));
        }

        ::nn::Result Listen(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int backlog) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Listen, (pOutRet, pOutError, sock, backlog));
        }

        ::nn::Result Ioctl(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::std::uint32_t command, const ::nn::sf::InBuffer& dataInSlot0, const ::nn::sf::InBuffer& dataInSlot1, const ::nn::sf::InBuffer& dataInSlot2, const ::nn::sf::InBuffer& dataInSlot3, const ::nn::sf::OutBuffer& dataOutSlot0, const ::nn::sf::OutBuffer& dataOutSlot1, const ::nn::sf::OutBuffer& dataOutSlot2, const ::nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Ioctl, (pOutRet, pOutError, sock, command, dataInSlot0, dataInSlot1, dataInSlot2, dataInSlot3, dataOutSlot0, dataOutSlot1, dataOutSlot2, dataOutSlot3, embeddedSegmentCount));
        }

        ::nn::Result Fcntl(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int command, int iocmd) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Fcntl, (pOutRet, pOutError, sock, command, iocmd));
        }

        ::nn::Result SetSockOpt(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::InBuffer& inOptionValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSockOpt, (pOutRet, pOutError, sock, level, optionName, inOptionValue));
        }

        ::nn::Result Shutdown(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int how) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Shutdown, (pOutRet, pOutError, sock, how));
        }

        ::nn::Result ShutdownAllSockets(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int forced) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ShutdownAllSockets, (pOutRet, pOutError, forced));
        }

        ::nn::Result Write(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Write, (pOutRet, pOutError, sock, inBuffer));
        }

        ::nn::Result Read(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Read, (pOutRet, pOutError, sock, outBuffer));
        }

        ::nn::Result Close(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Close, (pOutRet, pOutError, sock));
        }

        ::nn::Result DuplicateSocket(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::nn::Bit64 ownerProcessId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DuplicateSocket, (pOutRet, pOutError, sock, ownerProcessId));
        }

        ::nn::Result GetResourceStatistics(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, ::nn::Bit64 pid, int type, const ::nn::sf::OutBuffer& outBuffer, unsigned int options) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetResourceStatistics, (pOutRet, pOutError, pid, type, outBuffer, options));
        }

        ::nn::Result RecvMMsg(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const ::nn::socket::sf::Timespec& timeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RecvMMsg, (pOutRet, pOutError, sock, outBuffer, numMessages, flags, timeout));
        }

        ::nn::Result SendMMsg(::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InArray<::nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const ::nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendMMsg, (pOutRet, pOutError, sock, inArrayMsgHdr, numMessages, inBufferPackedMsgHdrData, flags));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IClient
    {
    public:
        nn::Result RegisterClient(nn::sf::Out<int> pOutRet, nn::Bit64 pid, nn::sf::NativeHandle&& memoryHandle, std::uint64_t memorySize, const nn::socket::sf::LibraryConfigData& configData) NN_NOEXCEPT;
        nn::Result StartMonitoring(nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result Socket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT;
        nn::Result SocketExempt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT;
        nn::Result Open(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& path, int flags) NN_NOEXCEPT;
        nn::Result Select(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int numberOfDescriptors, const nn::sf::InBuffer& inReadDescriptors, const nn::sf::InBuffer& inWriteDescriptors, const nn::sf::InBuffer& inExceptDescriptors, const nn::sf::OutBuffer& outReadDescriptors, const nn::sf::OutBuffer& outWriteDescriptors, const nn::sf::OutBuffer& outExceptDescriptors, const nn::socket::sf::SelectTimeval& timeout) NN_NOEXCEPT;
        nn::Result Poll(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& inDescriptors, const nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds) NN_NOEXCEPT;
        nn::Result Sysctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& mib, const nn::sf::OutBuffer& outValue, nn::sf::Out<unsigned int> pOutValueLength, const nn::sf::InBuffer& inValue) NN_NOEXCEPT;
        nn::Result Recv(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags) NN_NOEXCEPT;
        nn::Result RecvFrom(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
        nn::Result Send(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags) NN_NOEXCEPT;
        nn::Result SendTo(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;
        nn::Result Accept(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
        nn::Result Bind(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;
        nn::Result Connect(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;
        nn::Result GetPeerName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
        nn::Result GetSockName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
        nn::Result GetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::OutBuffer& pOutOptionValue, nn::sf::Out<unsigned int> pOutOptionLength) NN_NOEXCEPT;
        nn::Result Listen(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int backlog) NN_NOEXCEPT;
        nn::Result Ioctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, std::uint32_t command, const nn::sf::InBuffer& dataInSlot0, const nn::sf::InBuffer& dataInSlot1, const nn::sf::InBuffer& dataInSlot2, const nn::sf::InBuffer& dataInSlot3, const nn::sf::OutBuffer& dataOutSlot0, const nn::sf::OutBuffer& dataOutSlot1, const nn::sf::OutBuffer& dataOutSlot2, const nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount) NN_NOEXCEPT;
        nn::Result Fcntl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int command, int iocmd) NN_NOEXCEPT;
        nn::Result SetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::InBuffer& inOptionValue) NN_NOEXCEPT;
        nn::Result Shutdown(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int how) NN_NOEXCEPT;
        nn::Result ShutdownAllSockets(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int forced) NN_NOEXCEPT;
        nn::Result Write(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
        nn::Result Read(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result Close(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock) NN_NOEXCEPT;
        nn::Result DuplicateSocket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, nn::Bit64 ownerProcessId) NN_NOEXCEPT;
        nn::Result GetResourceStatistics(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, nn::Bit64 pid, int type, const nn::sf::OutBuffer& outBuffer, unsigned int options) NN_NOEXCEPT;
        nn::Result RecvMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const nn::socket::sf::Timespec& timeout) NN_NOEXCEPT;
        nn::Result SendMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InArray<nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RegisterClient(nn::sf::Out<int> pOutRet, nn::Bit64 pid, nn::sf::NativeHandle&& memoryHandle, std::uint64_t memorySize, const nn::socket::sf::LibraryConfigData& configData) NN_NOEXCEPT;
    nn::Result StartMonitoring(nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result Socket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT;
    nn::Result SocketExempt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT;
    nn::Result Open(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& path, int flags) NN_NOEXCEPT;
    nn::Result Select(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int numberOfDescriptors, const nn::sf::InBuffer& inReadDescriptors, const nn::sf::InBuffer& inWriteDescriptors, const nn::sf::InBuffer& inExceptDescriptors, const nn::sf::OutBuffer& outReadDescriptors, const nn::sf::OutBuffer& outWriteDescriptors, const nn::sf::OutBuffer& outExceptDescriptors, const nn::socket::sf::SelectTimeval& timeout) NN_NOEXCEPT;
    nn::Result Poll(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& inDescriptors, const nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds) NN_NOEXCEPT;
    nn::Result Sysctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& mib, const nn::sf::OutBuffer& outValue, nn::sf::Out<unsigned int> pOutValueLength, const nn::sf::InBuffer& inValue) NN_NOEXCEPT;
    nn::Result Recv(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags) NN_NOEXCEPT;
    nn::Result RecvFrom(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
    nn::Result Send(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags) NN_NOEXCEPT;
    nn::Result SendTo(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;
    nn::Result Accept(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
    nn::Result Bind(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;
    nn::Result Connect(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;
    nn::Result GetPeerName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
    nn::Result GetSockName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;
    nn::Result GetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::OutBuffer& pOutOptionValue, nn::sf::Out<unsigned int> pOutOptionLength) NN_NOEXCEPT;
    nn::Result Listen(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int backlog) NN_NOEXCEPT;
    nn::Result Ioctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, std::uint32_t command, const nn::sf::InBuffer& dataInSlot0, const nn::sf::InBuffer& dataInSlot1, const nn::sf::InBuffer& dataInSlot2, const nn::sf::InBuffer& dataInSlot3, const nn::sf::OutBuffer& dataOutSlot0, const nn::sf::OutBuffer& dataOutSlot1, const nn::sf::OutBuffer& dataOutSlot2, const nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount) NN_NOEXCEPT;
    nn::Result Fcntl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int command, int iocmd) NN_NOEXCEPT;
    nn::Result SetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::InBuffer& inOptionValue) NN_NOEXCEPT;
    nn::Result Shutdown(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int how) NN_NOEXCEPT;
    nn::Result ShutdownAllSockets(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int forced) NN_NOEXCEPT;
    nn::Result Write(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result Close(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock) NN_NOEXCEPT;
    nn::Result DuplicateSocket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, nn::Bit64 ownerProcessId) NN_NOEXCEPT;
    nn::Result GetResourceStatistics(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, nn::Bit64 pid, int type, const nn::sf::OutBuffer& outBuffer, unsigned int options) NN_NOEXCEPT;
    nn::Result RecvMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const nn::socket::sf::Timespec& timeout) NN_NOEXCEPT;
    nn::Result SendMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InArray<nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::socket::sf::IClient))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterClient, (::nn::sf::Out<int> pOutRet, ::nn::Bit64 pid, ::nn::sf::NativeHandle&& memoryHandle, ::std::uint64_t memorySize, const ::nn::socket::sf::LibraryConfigData& configData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterClient, (pOutRet, pid, ::std::move(memoryHandle), memorySize, configData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartMonitoring, (::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartMonitoring, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Socket, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Socket, (pOutRet, pOutError, domain, type, protocol));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SocketExempt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SocketExempt, (pOutRet, pOutError, domain, type, protocol));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Open, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& path, int flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Open, (pOutRet, pOutError, path, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Select, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int numberOfDescriptors, const ::nn::sf::InBuffer& inReadDescriptors, const ::nn::sf::InBuffer& inWriteDescriptors, const ::nn::sf::InBuffer& inExceptDescriptors, const ::nn::sf::OutBuffer& outReadDescriptors, const ::nn::sf::OutBuffer& outWriteDescriptors, const ::nn::sf::OutBuffer& outExceptDescriptors, const ::nn::socket::sf::SelectTimeval& timeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Select, (pOutRet, pOutError, numberOfDescriptors, inReadDescriptors, inWriteDescriptors, inExceptDescriptors, outReadDescriptors, outWriteDescriptors, outExceptDescriptors, timeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Poll, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& inDescriptors, const ::nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Poll, (pOutRet, pOutError, inDescriptors, outDescriptors, numberOfDescriptors, timeoutMilliseconds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Sysctl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& mib, const ::nn::sf::OutBuffer& outValue, ::nn::sf::Out<unsigned int> pOutValueLength, const ::nn::sf::InBuffer& inValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Sysctl, (pOutRet, pOutError, mib, outValue, pOutValueLength, inValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Recv, (pOutRet, pOutError, sock, outBuffer, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvFrom, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RecvFrom, (pOutRet, pOutError, sock, outBuffer, flags, pOutAddress, pOutAddressLength));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Send, (pOutRet, pOutError, sock, inBuffer, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendTo, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags, const ::nn::sf::InBuffer& inAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendTo, (pOutRet, pOutError, sock, inBuffer, flags, inAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Accept, (pOutRet, pOutError, sock, pOutAddress, pOutAddressLength));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Bind, (pOutRet, pOutError, sock, inAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Connect, (pOutRet, pOutError, sock, inAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPeerName, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPeerName, (pOutRet, pOutError, sock, pOutAddress, pOutAddressLength));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSockName, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSockName, (pOutRet, pOutError, sock, pOutAddress, pOutAddressLength));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSockOpt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::OutBuffer& pOutOptionValue, ::nn::sf::Out<unsigned int> pOutOptionLength))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSockOpt, (pOutRet, pOutError, sock, level, optionName, pOutOptionValue, pOutOptionLength));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int backlog))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Listen, (pOutRet, pOutError, sock, backlog));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Ioctl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::std::uint32_t command, const ::nn::sf::InBuffer& dataInSlot0, const ::nn::sf::InBuffer& dataInSlot1, const ::nn::sf::InBuffer& dataInSlot2, const ::nn::sf::InBuffer& dataInSlot3, const ::nn::sf::OutBuffer& dataOutSlot0, const ::nn::sf::OutBuffer& dataOutSlot1, const ::nn::sf::OutBuffer& dataOutSlot2, const ::nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Ioctl, (pOutRet, pOutError, sock, command, dataInSlot0, dataInSlot1, dataInSlot2, dataInSlot3, dataOutSlot0, dataOutSlot1, dataOutSlot2, dataOutSlot3, embeddedSegmentCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int command, int iocmd))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Fcntl, (pOutRet, pOutError, sock, command, iocmd));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSockOpt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::InBuffer& inOptionValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSockOpt, (pOutRet, pOutError, sock, level, optionName, inOptionValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int how))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Shutdown, (pOutRet, pOutError, sock, how));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ShutdownAllSockets, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int forced))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ShutdownAllSockets, (pOutRet, pOutError, forced));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Write, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Write, (pOutRet, pOutError, sock, inBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Read, (pOutRet, pOutError, sock, outBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Close, (pOutRet, pOutError, sock));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DuplicateSocket, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::nn::Bit64 ownerProcessId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DuplicateSocket, (pOutRet, pOutError, sock, ownerProcessId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetResourceStatistics, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, ::nn::Bit64 pid, int type, const ::nn::sf::OutBuffer& outBuffer, unsigned int options))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetResourceStatistics, (pOutRet, pOutError, pid, type, outBuffer, options));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvMMsg, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const ::nn::socket::sf::Timespec& timeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RecvMMsg, (pOutRet, pOutError, sock, outBuffer, numMessages, flags, timeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendMMsg, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InArray<::nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const ::nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendMMsg, (pOutRet, pOutError, sock, inArrayMsgHdr, numMessages, inBufferPackedMsgHdrData, flags));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::socket::sf::IClient>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::socket::sf::IClient))

    // nn::Result RegisterClient(nn::sf::Out<int> pOutRet, nn::Bit64 pid, nn::sf::NativeHandle&& memoryHandle, std::uint64_t memorySize, const nn::socket::sf::LibraryConfigData& configData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterClient)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(memoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (memoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(configData, (::nn::socket::sf::LibraryConfigData), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(memorySize, (::std::uint64_t), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (configData, pid, memorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRet))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(memoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(memorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(configData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterClient)

    // nn::Result StartMonitoring(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartMonitoring)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartMonitoring)

    // nn::Result Socket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Socket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(domain, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(protocol, (int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (domain, type, protocol))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(domain), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(protocol)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Socket)

    // nn::Result SocketExempt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SocketExempt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(domain, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(protocol, (int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (domain, type, protocol))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(domain), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(protocol)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SocketExempt)

    // nn::Result Open(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& path, int flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Open)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(path, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Open)

    // nn::Result Select(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int numberOfDescriptors, const nn::sf::InBuffer& inReadDescriptors, const nn::sf::InBuffer& inWriteDescriptors, const nn::sf::InBuffer& inExceptDescriptors, const nn::sf::OutBuffer& outReadDescriptors, const nn::sf::OutBuffer& outWriteDescriptors, const nn::sf::OutBuffer& outExceptDescriptors, const nn::socket::sf::SelectTimeval& timeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Select)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inReadDescriptors, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inWriteDescriptors, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inExceptDescriptors, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outReadDescriptors, 3, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outWriteDescriptors, 4, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outExceptDescriptors, 5, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(6, (inReadDescriptors, inWriteDescriptors, inExceptDescriptors, outReadDescriptors, outWriteDescriptors, outExceptDescriptors))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(numberOfDescriptors, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::socket::sf::SelectTimeval), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (numberOfDescriptors, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(numberOfDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inReadDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inWriteDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inExceptDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWriteDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outExceptDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Select)

    // nn::Result Poll(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& inDescriptors, const nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Poll)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inDescriptors, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outDescriptors, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inDescriptors, outDescriptors))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(numberOfDescriptors, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeoutMilliseconds, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (numberOfDescriptors, timeoutMilliseconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(numberOfDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeoutMilliseconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Poll)

    // nn::Result Sysctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& mib, const nn::sf::OutBuffer& outValue, nn::sf::Out<unsigned int> pOutValueLength, const nn::sf::InBuffer& inValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Sysctl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(mib, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outValue, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inValue, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (mib, outValue, inValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutValueLength, (unsigned int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutRet, pOutError, pOutValueLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mib), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutValueLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Sysctl)

    // nn::Result Recv(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Recv)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (sock, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Recv)

    // nn::Result RecvFrom(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RecvFrom)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutAddress, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, pOutAddress))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (sock, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddressLength, (unsigned int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutRet, pOutError, pOutAddressLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddressLength)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RecvFrom)

    // nn::Result Send(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Send)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (sock, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Send)

    // nn::Result SendTo(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendTo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inAddress, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inBuffer, inAddress))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (sock, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendTo)

    // nn::Result Accept(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Accept)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutAddress, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutAddress))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddressLength, (unsigned int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutRet, pOutError, pOutAddressLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddressLength)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Accept)

    // nn::Result Bind(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Bind)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inAddress, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inAddress))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Bind)

    // nn::Result Connect(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Connect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inAddress, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inAddress))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Connect)

    // nn::Result GetPeerName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPeerName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutAddress, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutAddress))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddressLength, (unsigned int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutRet, pOutError, pOutAddressLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddressLength)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPeerName)

    // nn::Result GetSockName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSockName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutAddress, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutAddress))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddressLength, (unsigned int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutRet, pOutError, pOutAddressLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddressLength)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSockName)

    // nn::Result GetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::OutBuffer& pOutOptionValue, nn::sf::Out<unsigned int> pOutOptionLength) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSockOpt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutOptionValue, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutOptionValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(level, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionName, (int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (sock, level, optionName))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutOptionLength, (unsigned int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutRet, pOutError, pOutOptionLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(level), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutOptionValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutOptionLength)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSockOpt)

    // nn::Result Listen(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int backlog) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Listen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(backlog, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (sock, backlog))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(backlog)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Listen)

    // nn::Result Ioctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, std::uint32_t command, const nn::sf::InBuffer& dataInSlot0, const nn::sf::InBuffer& dataInSlot1, const nn::sf::InBuffer& dataInSlot2, const nn::sf::InBuffer& dataInSlot3, const nn::sf::OutBuffer& dataOutSlot0, const nn::sf::OutBuffer& dataOutSlot1, const nn::sf::OutBuffer& dataOutSlot2, const nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Ioctl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataInSlot0, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataInSlot1, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataInSlot2, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataInSlot3, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataOutSlot0, 4, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataOutSlot1, 5, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataOutSlot2, 6, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dataOutSlot3, 7, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(8, (dataInSlot0, dataInSlot1, dataInSlot2, dataInSlot3, dataOutSlot0, dataOutSlot1, dataOutSlot2, dataOutSlot3))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(command, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(embeddedSegmentCount, (int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (sock, command, embeddedSegmentCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(command), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataInSlot0), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataInSlot1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataInSlot2), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataInSlot3), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOutSlot0), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOutSlot1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOutSlot2), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOutSlot3), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(embeddedSegmentCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Ioctl)

    // nn::Result Fcntl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int command, int iocmd) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Fcntl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(command, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(iocmd, (int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (sock, command, iocmd))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(command), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(iocmd)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Fcntl)

    // nn::Result SetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::InBuffer& inOptionValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSockOpt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inOptionValue, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inOptionValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(level, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionName, (int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (sock, level, optionName))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(level), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inOptionValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSockOpt)

    // nn::Result Shutdown(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int how) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Shutdown)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(how, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (sock, how))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(how)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Shutdown)

    // nn::Result ShutdownAllSockets(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int forced) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ShutdownAllSockets)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(forced, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (forced))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(forced)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ShutdownAllSockets)

    // nn::Result Write(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Write)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Write)

    // nn::Result Read(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Read)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Read)

    // nn::Result Close(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Close)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sock))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Close)

    // nn::Result DuplicateSocket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, nn::Bit64 ownerProcessId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DuplicateSocket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ownerProcessId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (sock, ownerProcessId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ownerProcessId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DuplicateSocket)

    // nn::Result GetResourceStatistics(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, nn::Bit64 pid, int type, const nn::sf::OutBuffer& outBuffer, unsigned int options) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResourceStatistics)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(options, (unsigned int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (type, options, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(options)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResourceStatistics)

    // nn::Result RecvMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const nn::socket::sf::Timespec& timeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RecvMMsg)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(numMessages, (unsigned int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (int), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::socket::sf::Timespec), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (sock, numMessages, flags, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(numMessages), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RecvMMsg)

    // nn::Result SendMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InArray<nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendMMsg)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inArrayMsgHdr, 0, (const ::nn::sf::InArray<::nn::socket::sf::MsgHdr>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBufferPackedMsgHdrData, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inArrayMsgHdr, inBufferPackedMsgHdrData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sock, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(numMessages, (unsigned int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (int), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (sock, numMessages, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRet, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutError, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutRet, pOutError))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sock), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inArrayMsgHdr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(numMessages), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBufferPackedMsgHdrData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendMMsg)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::socket::sf::LibraryConfigData), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::socket::sf::SelectTimeval), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::socket::sf::Timespec), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::socket::sf::MsgHdr), 80, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::socket::sf::IClient, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::socket::sf::IClient))

    // nn::Result RegisterClient(nn::sf::Out<int> pOutRet, nn::Bit64 pid, nn::sf::NativeHandle&& memoryHandle, std::uint64_t memorySize, const nn::socket::sf::LibraryConfigData& configData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterClient, (::nn::sf::Out<int> pOutRet, ::nn::Bit64 pid, ::nn::sf::NativeHandle&& memoryHandle, ::std::uint64_t memorySize, const ::nn::socket::sf::LibraryConfigData& configData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterClient)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(memoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(memorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(configData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterClient)
    }

    // nn::Result StartMonitoring(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartMonitoring, (::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartMonitoring)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartMonitoring)
    }

    // nn::Result Socket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Socket, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Socket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(domain)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(protocol)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Socket)
    }

    // nn::Result SocketExempt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int domain, int type, int protocol) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SocketExempt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int domain, int type, int protocol))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SocketExempt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(domain)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(protocol)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SocketExempt)
    }

    // nn::Result Open(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& path, int flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Open, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& path, int flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Open)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Open)
    }

    // nn::Result Select(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int numberOfDescriptors, const nn::sf::InBuffer& inReadDescriptors, const nn::sf::InBuffer& inWriteDescriptors, const nn::sf::InBuffer& inExceptDescriptors, const nn::sf::OutBuffer& outReadDescriptors, const nn::sf::OutBuffer& outWriteDescriptors, const nn::sf::OutBuffer& outExceptDescriptors, const nn::socket::sf::SelectTimeval& timeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Select, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int numberOfDescriptors, const ::nn::sf::InBuffer& inReadDescriptors, const ::nn::sf::InBuffer& inWriteDescriptors, const ::nn::sf::InBuffer& inExceptDescriptors, const ::nn::sf::OutBuffer& outReadDescriptors, const ::nn::sf::OutBuffer& outWriteDescriptors, const ::nn::sf::OutBuffer& outExceptDescriptors, const ::nn::socket::sf::SelectTimeval& timeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Select)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(numberOfDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inReadDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inWriteDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inExceptDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWriteDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outExceptDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Select)
    }

    // nn::Result Poll(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& inDescriptors, const nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Poll, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& inDescriptors, const ::nn::sf::OutBuffer& outDescriptors, int numberOfDescriptors, int timeoutMilliseconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Poll)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(numberOfDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeoutMilliseconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Poll)
    }

    // nn::Result Sysctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, const nn::sf::InBuffer& mib, const nn::sf::OutBuffer& outValue, nn::sf::Out<unsigned int> pOutValueLength, const nn::sf::InBuffer& inValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Sysctl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, const ::nn::sf::InBuffer& mib, const ::nn::sf::OutBuffer& outValue, ::nn::sf::Out<unsigned int> pOutValueLength, const ::nn::sf::InBuffer& inValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Sysctl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mib)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutValueLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Sysctl)
    }

    // nn::Result Recv(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Recv)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Recv)
    }

    // nn::Result RecvFrom(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, int flags, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvFrom, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, int flags, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RecvFrom)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddressLength)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RecvFrom)
    }

    // nn::Result Send(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Send)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Send)
    }

    // nn::Result SendTo(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer, int flags, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendTo, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer, int flags, const ::nn::sf::InBuffer& inAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendTo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendTo)
    }

    // nn::Result Accept(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Accept)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddressLength)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Accept)
    }

    // nn::Result Bind(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Bind)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Bind)
    }

    // nn::Result Connect(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Connect)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Connect)
    }

    // nn::Result GetPeerName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPeerName, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPeerName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddressLength)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPeerName)
    }

    // nn::Result GetSockName(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& pOutAddress, nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSockName, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& pOutAddress, ::nn::sf::Out<unsigned int> pOutAddressLength))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSockName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddressLength)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSockName)
    }

    // nn::Result GetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::OutBuffer& pOutOptionValue, nn::sf::Out<unsigned int> pOutOptionLength) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSockOpt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::OutBuffer& pOutOptionValue, ::nn::sf::Out<unsigned int> pOutOptionLength))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSockOpt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(level)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutOptionValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutOptionLength)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSockOpt)
    }

    // nn::Result Listen(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int backlog) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int backlog))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Listen)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(backlog)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Listen)
    }

    // nn::Result Ioctl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, std::uint32_t command, const nn::sf::InBuffer& dataInSlot0, const nn::sf::InBuffer& dataInSlot1, const nn::sf::InBuffer& dataInSlot2, const nn::sf::InBuffer& dataInSlot3, const nn::sf::OutBuffer& dataOutSlot0, const nn::sf::OutBuffer& dataOutSlot1, const nn::sf::OutBuffer& dataOutSlot2, const nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Ioctl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::std::uint32_t command, const ::nn::sf::InBuffer& dataInSlot0, const ::nn::sf::InBuffer& dataInSlot1, const ::nn::sf::InBuffer& dataInSlot2, const ::nn::sf::InBuffer& dataInSlot3, const ::nn::sf::OutBuffer& dataOutSlot0, const ::nn::sf::OutBuffer& dataOutSlot1, const ::nn::sf::OutBuffer& dataOutSlot2, const ::nn::sf::OutBuffer& dataOutSlot3, int embeddedSegmentCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Ioctl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(command)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataInSlot0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataInSlot1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataInSlot2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataInSlot3)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOutSlot0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOutSlot1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOutSlot2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOutSlot3)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(embeddedSegmentCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Ioctl)
    }

    // nn::Result Fcntl(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int command, int iocmd) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int command, int iocmd))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Fcntl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(command)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(iocmd)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Fcntl)
    }

    // nn::Result SetSockOpt(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int level, int optionName, const nn::sf::InBuffer& inOptionValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSockOpt, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int level, int optionName, const ::nn::sf::InBuffer& inOptionValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSockOpt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(level)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inOptionValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSockOpt)
    }

    // nn::Result Shutdown(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, int how) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, int how))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Shutdown)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(how)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Shutdown)
    }

    // nn::Result ShutdownAllSockets(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int forced) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ShutdownAllSockets, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int forced))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ShutdownAllSockets)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(forced)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ShutdownAllSockets)
    }

    // nn::Result Write(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Write, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Write)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Write)
    }

    // nn::Result Read(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Read)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Read)
    }

    // nn::Result Close(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Close)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Close)
    }

    // nn::Result DuplicateSocket(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, nn::Bit64 ownerProcessId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DuplicateSocket, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, ::nn::Bit64 ownerProcessId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DuplicateSocket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ownerProcessId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DuplicateSocket)
    }

    // nn::Result GetResourceStatistics(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, nn::Bit64 pid, int type, const nn::sf::OutBuffer& outBuffer, unsigned int options) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetResourceStatistics, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, ::nn::Bit64 pid, int type, const ::nn::sf::OutBuffer& outBuffer, unsigned int options))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResourceStatistics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(options)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResourceStatistics)
    }

    // nn::Result RecvMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const nn::socket::sf::Timespec& timeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvMMsg, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::OutBuffer& outBuffer, unsigned int numMessages, int flags, const ::nn::socket::sf::Timespec& timeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RecvMMsg)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(numMessages)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RecvMMsg)
    }

    // nn::Result SendMMsg(nn::sf::Out<int> pOutRet, nn::sf::Out<int> pOutError, int sock, const nn::sf::InArray<nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendMMsg, (::nn::sf::Out<int> pOutRet, ::nn::sf::Out<int> pOutError, int sock, const ::nn::sf::InArray<::nn::socket::sf::MsgHdr>& inArrayMsgHdr, unsigned int numMessages, const ::nn::sf::InBuffer& inBufferPackedMsgHdrData, int flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendMMsg)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inArrayMsgHdr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(numMessages)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBufferPackedMsgHdrData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendMMsg)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::socket::sf::IClient>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::socket::sf::IClient))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterClient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(memoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterClient)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(memoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(memorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(configData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartMonitoring)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartMonitoring)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Socket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Socket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(domain),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(protocol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SocketExempt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SocketExempt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(domain),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(protocol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Open)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Open)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Select)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inReadDescriptors)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inWriteDescriptors)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inExceptDescriptors)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outReadDescriptors)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outWriteDescriptors)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outExceptDescriptors)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Select)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(numberOfDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inReadDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inWriteDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inExceptDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outReadDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outWriteDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outExceptDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Poll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inDescriptors)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outDescriptors)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Poll)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(numberOfDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeoutMilliseconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Sysctl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(mib)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Sysctl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(mib),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutValueLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Recv)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Recv)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RecvFrom)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RecvFrom)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddressLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Send)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendTo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendTo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Accept)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Accept)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddressLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Bind)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Bind)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Connect)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPeerName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPeerName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddressLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSockName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSockName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddressLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSockOpt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutOptionValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSockOpt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(level),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutOptionValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutOptionLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Listen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Listen)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(backlog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Ioctl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataInSlot0)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataInSlot1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataInSlot2)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataInSlot3)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataOutSlot0)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataOutSlot1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataOutSlot2)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dataOutSlot3)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Ioctl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(command),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataInSlot0),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataInSlot1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataInSlot2),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataInSlot3),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataOutSlot0),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataOutSlot1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataOutSlot2),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dataOutSlot3),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(embeddedSegmentCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Fcntl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Fcntl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(command),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(iocmd)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSockOpt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inOptionValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSockOpt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(level),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inOptionValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Shutdown)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(how)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ShutdownAllSockets)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ShutdownAllSockets)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(forced)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Write)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Write)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Read)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Close)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DuplicateSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DuplicateSocket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ownerProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResourceStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResourceStatistics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(options)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RecvMMsg)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RecvMMsg)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(numMessages),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendMMsg)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inArrayMsgHdr)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBufferPackedMsgHdrData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendMMsg)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sock),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inArrayMsgHdr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(numMessages),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBufferPackedMsgHdrData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterClient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartMonitoring)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Socket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SocketExempt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Open)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Select)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Poll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Sysctl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Recv)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RecvFrom)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendTo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Accept)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Bind)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPeerName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSockName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSockOpt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Listen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Ioctl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Fcntl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSockOpt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ShutdownAllSockets)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Write)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DuplicateSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResourceStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RecvMMsg)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendMMsg)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::socket::sf::IClient))
