﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file DNS resolver server header
 * @brief provide functions to initialize the resolver server
 */

#pragma once

#include <nn/nn_Common.h>
#include <stdint.h>
#include <nn/socket/resolver/private/resolver_PrivateApi.h>

namespace nn { namespace socket { namespace resolver {

/**
 *@brief initialize the server side of the resolver library
 *@return success or error result code
 */
Result InitializeServer( ) NN_NOEXCEPT;

/**
 *@brief wait on the server to finish
 *@return success or error result code
 */
Result WaitServer( ) NN_NOEXCEPT;

/**
 *@brief finalize the server
 *@return success or error result code
 */
Result FinalizeServer( ) NN_NOEXCEPT;

}; }; };  // nn::socket::resolver
