﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      socket モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_SOCKET_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(socket, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_SOCKET_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(socket, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(socket, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(socket, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(socket, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_SOCKET_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(socket, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(socket, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(socket, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(socket, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_SOCKET_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(socket, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_SOCKET_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(socket, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_SOCKET_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(socket, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_SOCKET_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Trace, 0, format, args)
#define NN_DETAIL_SOCKET_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Trace, 1, format, args)
#define NN_DETAIL_SOCKET_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Trace, 2, format, args)
#define NN_DETAIL_SOCKET_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Trace, 3, format, args)

#define NN_DETAIL_SOCKET_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Info, 0, format, args)
#define NN_DETAIL_SOCKET_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Info, 1, format, args)
#define NN_DETAIL_SOCKET_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Info, 2, format, args)
#define NN_DETAIL_SOCKET_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Info, 3, format, args)

#define NN_DETAIL_SOCKET_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Warn, 0, format, args)
#define NN_DETAIL_SOCKET_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Warn, 1, format, args)
#define NN_DETAIL_SOCKET_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Warn, 2, format, args)
#define NN_DETAIL_SOCKET_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Warn, 3, format, args)

#define NN_DETAIL_SOCKET_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Error, 0, format, args)
#define NN_DETAIL_SOCKET_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Error, 1, format, args)
#define NN_DETAIL_SOCKET_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Error, 2, format, args)
#define NN_DETAIL_SOCKET_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Error, 3, format, args)

#define NN_DETAIL_SOCKET_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Fatal, 0, format, args)
#define NN_DETAIL_SOCKET_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Fatal, 1, format, args)
#define NN_DETAIL_SOCKET_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Fatal, 2, format, args)
#define NN_DETAIL_SOCKET_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(socket, Fatal, 3, format, args)

#define NN_DETAIL_SOCKET_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(socket, Trace, 0, text, length)
#define NN_DETAIL_SOCKET_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Trace, 1, text, length)
#define NN_DETAIL_SOCKET_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Trace, 2, text, length)
#define NN_DETAIL_SOCKET_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Trace, 3, text, length)

#define NN_DETAIL_SOCKET_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(socket, Info, 0, text, length)
#define NN_DETAIL_SOCKET_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(socket, Info, 1, text, length)
#define NN_DETAIL_SOCKET_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(socket, Info, 2, text, length)
#define NN_DETAIL_SOCKET_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(socket, Info, 3, text, length)

#define NN_DETAIL_SOCKET_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(socket, Warn, 0, text, length)
#define NN_DETAIL_SOCKET_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(socket, Warn, 1, text, length)
#define NN_DETAIL_SOCKET_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(socket, Warn, 2, text, length)
#define NN_DETAIL_SOCKET_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(socket, Warn, 3, text, length)

#define NN_DETAIL_SOCKET_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(socket, Error, 0, text, length)
#define NN_DETAIL_SOCKET_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Error, 1, text, length)
#define NN_DETAIL_SOCKET_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Error, 2, text, length)
#define NN_DETAIL_SOCKET_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Error, 3, text, length)

#define NN_DETAIL_SOCKET_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(socket, Fatal, 0, text, length)
#define NN_DETAIL_SOCKET_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Fatal, 1, text, length)
#define NN_DETAIL_SOCKET_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Fatal, 2, text, length)
#define NN_DETAIL_SOCKET_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(socket, Fatal, 3, text, length)
