﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Types.h>
#include <cstring>

namespace nn {
namespace sm {

    namespace detail
    {
        const char PortName[] = "sm:";
    }

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    Result GetServiceHandle(svc::Handle* pOut, const char* pName, size_t nameSize) NN_NOEXCEPT;
    Result RegisterService(svc::Handle* pOut, const char* pName, size_t nameSize, int sessionCountMax, bool isLight) NN_NOEXCEPT;
    Result UnregisterService(const char* pName, size_t nameSize) NN_NOEXCEPT;

    inline Result GetServiceHandle(svc::Handle* pOut, const char* pName) NN_NOEXCEPT
    {
        return GetServiceHandle(pOut, pName, std::strlen(pName));
    }
    inline Result RegisterService(svc::Handle* pOut, const char* pName, int sessionCountMax, bool isLight) NN_NOEXCEPT
    {
        return RegisterService(pOut, pName, std::strlen(pName), sessionCountMax, isLight);
    }
    inline Result UnregisterService(const char* pName) NN_NOEXCEPT
    {
        return UnregisterService(pName, std::strlen(pName));
    }

} // end of namespace sm
} // end of namespace nn
