﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief サービスフレームワークで HIPC におけるポート関連のサーバ・クライアント共通の定義を行います。
*/

#include <nn/sf/hipc/sf_HipcServiceResolutionApi.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>

namespace nn { namespace sf {

/**
    @brief HIPC サービス名の最大長を表す定数です。
*/
const size_t HipcServiceNameLengthMax = 8;

#if defined(NN_BUILD_FOR_DOCUMENT_GENERATION)
struct UnspecifiedForHipcServerPortHandle;
/**
    @brief サーバポートハンドルを表す型です。

    @details
     この型は内部型のエイリアスです。内部型を直接使わず、この型を使用するようにしてください。
*/
typedef UnspecifiedForHipcServerPortHandle HipcServerPortHandle;
#else
typedef nn::sf::hipc::HipcServerPortHandle HipcServerPortHandle;
#endif

// 以下実装
//   TODO: 整理後 .cpp への移動

static_assert(HipcServiceNameLengthMax == hipc::HipcServiceNameLengthMax, "[SF-Internal]");

}}
