﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace sf {

/**
    @brief FS 用コンテキスト値取得関数です。

    @return FS 用コンテキスト値を返します。
*/
Bit8 GetFsInlineContext() NN_NOEXCEPT;

/**
    @brief FS 用コンテキスト値設定関数です。

    @param[in] x 設定する FS 用コンテキスト値を指定します。
    @return 設定前の FS 用コンテキスト値を返します。
*/
Bit8 SetFsInlineContext(Bit8 x) NN_NOEXCEPT;

}}
