﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief サービスフレームワークでのサービスオブジェクト処理でコンテキストを制御するための API を提供します。
*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Result.h>

#include <nn/sf/detail/sf_InternalResult.h>

namespace nn { namespace sf {

//! @name 処理コンテキスト操作
//! @{

/**
    @brief (deprecated) リクエスト処理が、現在のコンテキストではなく、別のコンテキストで行われることを表す Result を返します。
    @deprecated この関数は廃止予定です。使用しないでください。

    @return リクエスト処理が、現在のコンテキストではなく、別のコンテキストで行われることを表す Result を返します。

    @details
     リクエスト処理を、現コンテキストではなく、別スレッドや、後程別途行う場合に、
     現在のコンテキストで処理が行われないことを上位層に通知するための Result を作成し返します。

     この関数の返り値を上位に返した際には、再度リクエスト処理を最初から呼び出しなおす必要があります。
     この際に呼び出すべきリクエストが何であるかは、ユーザが管理している必要があります。
     このためには、例えば、グローバル変数やスレッドローカル変数などに処理中のリクエストを保存しておき、ここで参照するなどの手段があります。
*/
Result InvalidateCurrentContext() NN_NOEXCEPT;

/**
    @brief リクエスト処理を後回しにすることを表す Result を返します。

    @return リクエスト処理を後回しにすることを表す Result を返します。

    @details
     リクエスト処理を何らかの理由で現時点では行うことができず、後回しにする必要があるような場合、
     処理の返り値としてこの関数の返り値を返します。

     ここで返された Result は ResultProcessDeferred としてハンドリングすることができ、
     HipcSimpleAllInOneServerManager::ProcessInvokeRequest などのリクエスト処理開始関数の返り値でハンドルします。
     この場合、リクエスト処理の開始側の責任で再度リクエスト処理を行う必要があります。
*/
Result DeferProcess() NN_NOEXCEPT;

//! @}

// 以下実装
// TODO: 後に .cpp に移す

inline Result InvalidateCurrentContext() NN_NOEXCEPT
{
    return nn::sf::detail::ResultCurrentContextInvalidatedByUserImpl();
}

inline Result DeferProcess() NN_NOEXCEPT
{
    return nn::sf::detail::ResultProcessDeferredByUserImpl();
}

}}
