﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>


namespace nn { namespace sf { namespace hipc { namespace server {

class HipcServerApiModel
{
private:
    bool m_EnabledIpcOnWindows;

public:
    explicit HipcServerApiModel(bool enabledIpcOnWindows) NN_NOEXCEPT
        : m_EnabledIpcOnWindows(enabledIpcOnWindows)
    {
    }

    Result CreatePort(HipcServerPortHandle* pOutServer, HipcClientPortHandle* pOutClient, int maxSessions) NN_NOEXCEPT;
    Result CreateSession(HipcServerSessionHandle* pOutServer, HipcClientSessionHandle* pOutClient) NN_NOEXCEPT;

    Result RegisterHipcService(HipcServerPortHandle* pOut, int32_t maxSessions, const char* name) NN_NOEXCEPT;
    void UnregisterHipcService(const char* name) NN_NOEXCEPT;
};

}}}}
