﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/cmif/sf_CmifDomainCommon.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>

namespace nn { namespace sf { namespace hipc { namespace client {

Result QueryPointerBufferSize(uint16_t* pOut, HipcClientSessionHandle handle) NN_NOEXCEPT;
Result ConvertSessionToDomain(cmif::CmifDomainObjectId* pOut, HipcClientSessionHandle handle) NN_NOEXCEPT;
Result DuplicateSession(HipcClientSessionHandle* pOut, HipcClientSessionHandle clientHandle) NN_NOEXCEPT;
Result DuplicateSessionEx(HipcClientSessionHandle* pOut, HipcClientSessionHandle clientHandle, uint32_t tag) NN_NOEXCEPT;

}}}}
