﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>

#include <nn/nn_SdkAssert.h>
#include <nn/sf/hipc/sf_HipcDirectApi.h>
#include <nn/sf/hipc/detail/sf_HipcMessageFormat.h>
#include <nn/sf/hipc/detail/sf_HipcMessageBufferAccessor.h>
#include <nn/sf/hipc/sf_HipcResult.h>

namespace nn { namespace sf { namespace hipc { namespace client {

inline void CloseClientSessionHandleSafely(HipcClientSessionHandle handle) NN_NOEXCEPT
{
    auto messageBuffer = hipc::GetMessageBufferOnTls();
    auto messageBufferSize = hipc::MessageBufferSizeOnTls;
    detail::HipcMessageHeaderInfo headerInfo = {};
    detail::HipcMessageBufferAccessor accessor;
    auto setupSuccessed = accessor.SetupHeader(messageBuffer, messageBufferSize, headerInfo);
    NN_UNUSED(setupSuccessed);
    NN_SDK_ASSERT(setupSuccessed, "[SF-Internal]");
    accessor.SetTag(detail::MessageType_Release);
    auto result = hipc::SendSyncRequest(handle, messageBuffer, messageBufferSize);
    NN_UNUSED(result);
    NN_SDK_ASSERT(hipc::ResultSessionClosed::Includes(result), "[SF-Internal]");
    hipc::CloseClientSessionHandle(handle);
}

}}}}
