﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// external interface
// - NN_SF_BINARY_VERSION
// - NN_SF_USE_LATEST_BINARY_VERSION
// internal interface
// - NN_SF_DETAIL_BINARY_VERSION_EFFECTIVE

#define NN_SF_LATEST_BINARY_VERSION 1 // NOLINT(preprocessor/const)

#ifndef NN_SF_DETAIL_BINARY_VERSION_EFFECTIVE
    #ifdef NN_SF_BINARY_VERSION
        #if defined(NN_SF_USE_LATEST_BINARY_VERSION)
            #error "You can define only ONE of NN_SF_BINARY_VERSION and NN_SF_USE_LATEST_BINARY_VERSION."
        #endif
        #define NN_SF_DETAIL_BINARY_VERSION_EFFECTIVE NN_SF_BINARY_VERSION
    #else
        #if defined(NN_NINTENDO_SDK) || defined(NN_SF_USE_LATEST_BINARY_VERSION) || defined(__INTELLISENSE__)
            // On SDK tree, automatically defines NN_SF_DETAIL_BINARY_VERSION_EFFECTIVE as latest.
            #define NN_SF_DETAIL_BINARY_VERSION_EFFECTIVE NN_SF_LATEST_BINARY_VERSION
        #else
            // On other environments, requires explicit definition of NN_SF_BINARY_VERSION or NN_SF_USE_LATEST_BINARY_VERSION.
            // For nvnflinger, -DNN_SF_BINARY_VERSION=0
            // For other non-NNSDK modules, -DNN_SF_USE_LATEST_BINARY_VERSION
            #error "NN_SF_BINARY_VERSION is not defined. Please compile with -DNN_SF_BINARY_VERSION or -DNN_SF_USE_LATEST_BINARY_VERSION as designated."
        #endif
    #endif
#else
    #if !defined(NN_NINTENDO_SDK)
        #error "NN_SF_DETAIL_BINARY_VERSION_EFFECTIVE must not be explicitly defined. Define NN_SF_BINARY_VERSION instead."
    #endif
#endif
