﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/detail/sf_Config.h>

namespace nn { namespace sf { namespace cmif {

/**
    @brief ポインタとサイズの組
*/
using nn::sf::detail::PointerAndSize;

struct CmifMessageMetaInfo
{
    bool inProcessIdEnable;
    std::size_t inRawDataSize;
    std::size_t outRawDataSize;
    int bufferCount;
    int inObjectCount;
    int outObjectCount;
    int inNativeHandleCount;
    int outNativeHandleCount;
    int bufferAttributes[sf::detail::ArgumentCountMax];
    int inNativeHandleAttributes[sf::detail::ArgumentCountMax];
    int outNativeHandleAttributes[sf::detail::ArgumentCountMax];
};

enum BufferAttribute
{
    BufferAttribute_In = 1,
    BufferAttribute_Out = 2,
    BufferAttribute_HipcMapAlias = 4,
    BufferAttribute_HipcPointer = 8,
    BufferAttribute_FixedSize = 16,
    BufferAttribute_HipcAutoSelect = 32,
    BufferAttribute_HipcMapTransferAllowsNonSecure = 64,
    BufferAttribute_HipcMapTransferAllowsNonDevice = 128,
};

enum NativeHandleAttribute
{
    NativeHandleAttribute_HipcCopy = 1,
    NativeHandleAttribute_HipcMove = 2,
};

}}}
