﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/cmif/sf_CmifDomainCommon.h>
#include <nn/sf/cmif/sf_CmifMessageCommon.h>
#include <nn/sf/detail/sf_CommonUtil.h>

namespace nn { namespace sf { namespace cmif { namespace detail {

enum CmifDomainRequestKind
{
    GroupedRequestKind_InvokeMethod = 1,
    GroupedRequestKind_Release = 2,
};

struct CmifDomainMessageInHeader
{
    uint8_t requestKind;
    uint8_t inObjectCount;
    uint16_t inRawSize;
    CmifDomainObjectId targetObjectId;
    uint32_t reserved1;
    uint32_t envelopData;
};
static_assert(sizeof(CmifDomainMessageInHeader) == 16, "[SF-Internal]");

struct CmifDomainMessageOutHeader
{
    std::int32_t outObjectCount;
    uint32_t reserved1;
    uint32_t reserved2;
    uint32_t reserved3;
};
static_assert(sizeof(CmifDomainMessageOutHeader) == 16, "[SF-Internal]");

NN_SF_DETAIL_CONSTEXPR inline CmifMessageMetaInfo MakeBaseMetaInfo(const CmifMessageMetaInfo& metaInfo) NN_NOEXCEPT
{
    auto baseMetaInfo = metaInfo;
    baseMetaInfo.inRawDataSize += sizeof(CmifDomainMessageInHeader);
    baseMetaInfo.inRawDataSize += metaInfo.inObjectCount * sizeof(CmifDomainObjectId);
    baseMetaInfo.inObjectCount = 0;
    baseMetaInfo.outRawDataSize += sizeof(CmifDomainMessageOutHeader);
    baseMetaInfo.outRawDataSize += metaInfo.outObjectCount * sizeof(CmifDomainObjectId);
    baseMetaInfo.outObjectCount = 0;
    return baseMetaInfo;
}

}}}}
