﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// インターフェイス生成のために、自動生成系が使用するヘッダ・マクロ群
// マクロは NN_SF_CMIF_CLIENT_DETAIL_ 以下であり、フレームワーク実装外からの使用は不可

#include <nn/sf/cmif/client/detail/sf_CmifProxy.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/sf/cmif/sf_CmifCommonFormat.h>
#include <nn/sf/cmif/sf_CmifMessageCommon.h>
#include <nn/sf/cmif/detail/sf_CmifMethodInfos.h>
#include <nn/sf/cmif/client/sf_CmifClientMessage.h>

#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>
#include <nn/sf/detail/sf_CommonUtil.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/cmif/client/sf_CmifProxyFactory.h>
#include <array>
#include <nn/nn_SdkAssert.h>
#include <nn/sf/cmif/sf_CmifResult.h>
#include <nn/sf/detail/sf_CmifProxyInfoAccessor.h>
#include <nn/sf/detail/sf_Config.h>

namespace nn { namespace sf { namespace cmif { namespace client {

template <typename Interface, typename ProxyKind, typename AllocationPolicy>
class CmifProxyFactory;

}}}}

#define NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY(type) \
namespace nn { namespace sf { namespace cmif { namespace client { namespace detail { \
\
    template <typename ProxyKind, typename AllocationPolicy, typename RootInterface> \
    class CmifProxyImpl<NN_SF_DETAIL_STRIP_PAREN(type), ProxyKind, AllocationPolicy, RootInterface> \
        : public RootInterface \
        , protected ProxyKind::ProxyBaseObject \
        , private sf::detail::CmifProxyInfo \
    { \
    private: \
        typedef NN_SF_DETAIL_STRIP_PAREN(type) _tInterface; \
        typedef typename ProxyKind::ProxyBaseObject _base; \
        typedef typename ProxyKind::ObjectInfo _objectInfo; \
        typedef typename ProxyKind::CmifClientMessage _cmifClientMessage; \
        virtual cmif::client::CmifBaseObject* GetCmifBaseObject() NN_NOEXCEPT NN_OVERRIDE final \
        { \
            return static_cast<CmifProxyImpl<_tInterface, ProxyKind, AllocationPolicy, RootInterface>*>(this); \
        } \
        virtual sf::detail::CmifProxyInfo* GetProxyInfo() NN_NOEXCEPT NN_OVERRIDE final \
        { \
            return this; \
        } \
    protected: \
        template <typename OtherInterface> \
        SharedPointer<OtherInterface> CreateSharedOther() NN_NOEXCEPT \
        { \
            auto allocator = CmifProxyFactory<RootInterface, ProxyKind, AllocationPolicy>::GetAllocator(static_cast<CmifProxy<RootInterface, ProxyKind, AllocationPolicy>*>(this)); \
            auto p = CmifProxyFactory<OtherInterface, ProxyKind, AllocationPolicy>::CreateProxyObject(allocator); \
            return SharedPointer<OtherInterface>(p, false); \
        } \
    public: \
        CmifProxyImpl() NN_NOEXCEPT \
        { \
        } \
        \
        explicit CmifProxyImpl(const _objectInfo& info) NN_NOEXCEPT \
            : _base(info) \
        { \
        } \
        _base* GetProxyBaseObject() NN_NOEXCEPT \
        { \
            return static_cast<_base*>(this->GetCmifBaseObject());\
        } \
    private:

#define NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE(type, base) \
namespace nn { namespace sf { namespace cmif { namespace client { namespace detail { \
\
    template <typename ProxyKind, typename AllocationPolicy, typename RootInterface> \
    class CmifProxyImpl<NN_SF_DETAIL_STRIP_PAREN(type), ProxyKind, AllocationPolicy, RootInterface> \
        : public CmifProxyImpl<NN_SF_DETAIL_STRIP_PAREN(base), ProxyKind, AllocationPolicy, RootInterface> \
    { \
    private: \
        typedef NN_SF_DETAIL_STRIP_PAREN(type) _tInterface; \
        typedef CmifProxyImpl<NN_SF_DETAIL_STRIP_PAREN(base), ProxyKind, AllocationPolicy, RootInterface> _base; \
        typedef typename ProxyKind::ObjectInfo _objectInfo; \
    public: \
        CmifProxyImpl() NN_NOEXCEPT \
        { \
        } \
        \
        explicit CmifProxyImpl(const _objectInfo& info) NN_NOEXCEPT \
            : _base(info) \
        { \
        } \
    private:

    #define NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(methodName) \
        using _methodInfo = ::nn::sf::cmif::detail::MethodInfos<_tInterface>::methodName; \
        using _clientProcessor = typename ::nn::sf::cmif::client::GetClientProcessor<ProxyKind, _methodInfo>::type; \
        auto _pAllocator = (_methodInfo::OutObjectCount > 0) ? ::nn::sf::cmif::client::CmifProxyFactory<RootInterface, ProxyKind, AllocationPolicy>::GetAllocator(static_cast<CmifProxy<RootInterface, ProxyKind, AllocationPolicy>*>(this)) : nullptr; \
        return _clientProcessor::template Process<AllocationPolicy>(_pAllocator, this

        #define NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name) \
            , ::std::move(name)

    #define NN_SF_CMIF_CLIENT_DETAIL_CALL_END(methodName) \
        );

    #define NN_SF_CMIF_CLIENT_DETAIL_PROXY_DEFINE_SYNC_METHOD_UNSUPPORTED NN_ABORT("[SF-CMIF-NoMethodId] Call the method which has no [MethodId] via CMIF");

#define NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END \
    }; \
}}}}}
